

(function( $ ) {
    
    /*==============================================================
        close navbar when click
     ==============================================================*/
	$('.navbar-collapse a').click(function(){
		$(".navbar-collapse").collapse('hide');
	});

    /*==============================================================
        navbar fixed top
     ==============================================================*/
    var headerHeight = 50;

    $(window).bind('scroll', function () {
        if ($(window).scrollTop() > headerHeight) {
            $('#navbar-top-custom').removeClass('navbar-top');
            $('#navbar-top-custom').addClass('top-nav-collapse');
        }
        else {
            $('#navbar-top-custom').removeClass('top-nav-collapse');
            $('#navbar-top-custom').addClass('navbar-top');
        }
    });

        $('.video-slider').owlCarousel({
                loop:true,
                autoplay: true,
                navSpeed: 2000,
                autoplayTimeout: 6000,
                nav:true,
                dots: false,
                margin: 30,
                rtl:false,
                navText: [
                          "<i><img src='/assets/images/arrow-prev.jpg'></i>",
                          "<i><img src='/assets/images/arrow-next.jpg'></i>"
                          ],

                responsive:{
                    0:{
                        items:1
                    },
                    600:{
                        items:1
                    },
                    768:{
                        items:1
                    },
                    1000:{
                        items:4
                    }

                }
            });
            
            // Hide Header on on scroll down
var didScroll;
var lastScrollTop = 0;
var delta = 5;
var navbarHeight = $('.menu-header').outerHeight();

$(window).scroll(function(event){
    didScroll = true;
});

setInterval(function() {
    if (didScroll) {
        hasScrolled();
        didScroll = false;
    }
}, 250);

function hasScrolled() {
    var st = $(this).scrollTop();

    // Make sure they scroll more than delta
    if(Math.abs(lastScrollTop - st) <= delta)
        return;

    // If they scrolled down and are past the navbar, add class .nav-up.
    // This is necessary so you never see what is "behind" the navbar.
    if (st > lastScrollTop && st > navbarHeight){
        // Scroll Down
        $('.main').removeClass('nav-down').addClass('nav-up');
    } else {
        // Scroll Up
        if(st + $(window).height() < $(document).height()) {
            $('.main').removeClass('nav-up').addClass('nav-down');
        }
    }

    lastScrollTop = st;
}

  })(jQuery);
