#!/bin/bash

#variables
user=apihml
folderPath=/home/$user/
domain=apihml.lmssambatech.com.br
port=8022

phpunit

sudo rm -rf app/cache/* app/logs/* web/js web/css
php app/console fos:js-routing:dump --env=prod;
php app/console assetic:dump --force;

sudo find . -type f -exec chmod 644 {} \;
sudo find . -type d -exec chmod 755 {} \;

rsync -avz -e "ssh -p $port -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null" --progress --exclude-from 'deploy/ignore.txt' . $user@$domain:$folderPath
ssh -tt $user@$domain -p $port "cd $folderPath; rm -rf app/cache/* app/logs/*; php app/console assets:install --symlink; php app/console doctrine:schema:update --force"