<?php

namespace ApiBundle\Controller;

use AppBundle\Entity\Client;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use ApiBundle\Controller\BaseController;
use FOS\RestBundle\Util\Codes;
use FOS\RestBundle\Controller\Annotations\QueryParam;
use FOS\RestBundle\Controller\Annotations\View;
use FOS\RestBundle\Controller\Annotations\Delete;
use FOS\RestBundle\Controller\Annotations\Post;
use FOS\RestBundle\Controller\Annotations\Put;
use FOS\RestBundle\Controller\Annotations\Get;
use FOS\RestBundle\Controller\Annotations\Patch;
use Nelmio\ApiDocBundle\Annotation\ApiDoc;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class ApiController extends BaseController
{
    protected $salt = "cb5qhiIGEdvx%wc66d9iLfnn9qsJ*mZc";

    private function APIValidateUser($user, $password)
    {
        $apiUser = $this->container->getParameter('api_user');
        $apiPassword = $this->container->getParameter('api_password');
        if ($user != $apiUser || $password != $apiPassword) {
            return false;
        }
        return true;
    }

    private function APIValidate($token)
    {
        $myToken = md5(date('h').$this->salt);
        if ($token != $myToken) {
            return false;
        }
        return true;
    }

    /**
     * @Post("/get-token").
     *
     * @ApiDoc(
     *   resource = true,
     *   headers={
     *      {
     *          "name"="X-UNIMED-USER",
     *          "description"="User",
     *          "required"=true
     *      },
     *      {
     *          "name"="X-UNIMED-PASSWORD",
     *          "description"="Password",
     *          "required"=true
     *      }
     *   },
     *   section = "Authentication",
     *   description = "Gets a valid token to requisitions",
     *   statusCodes = {
     *     200 = "Returned when successful",
     *     404 = "Returned when the page is not found"
     *   }
     * )
     * @return String token
     */
    public function getTokenAction(Request $request)
    {
        try {
            $user = $request->headers->get('X-UNIMED-USER');
            $password = $request->headers->get('X-UNIMED-PASSWORD');
            if (!$this->APIValidateUser($user, $password)) {
                $msg = array(
                    'error' => "Incorrect user/password"
                );
                
                return $this->returnErrorJson($msg);
            }
            $response = array(
                "token" =>md5(date('h').$this->salt)
            );
            
            return $this->returnJson($response);
        } catch (\Exception $e) {
            $error = utf8_encode($e);
            $msg = array(
                'error' => $error
            );
            
            return $this->returnErrorJson($msg);
        }
    }

    /**
     * @Post("/consulta-curso").
     *
     * @ApiDoc(
     *   resource = true,
     *   section = "Courses",
     *   description = "Returns a list of courses based on the sended category",
     *   headers={
     *      {
     *          "name"="X-UNIMED-TOKEN",
     *          "description"="Authenticated token",
     *          "required"=true
     *      }
     *   },
     *   parameters={
     *      {"name"="categoria", "dataType"="string", "required"=true, "description"="Category name"}
     *   },
     *   output = "String",
     *   statusCodes = {
     *     200 = "Returned when successful",
     *     404 = "Returned when the page is not found"
     *   }
     * )
     * @return string token
     */
    public function getConsultaCursoAction(Request $request)
    {
        try {
            $token = $request->headers->get('X-UNIMED-TOKEN');
            $categoria = $request->get('categoria');
            if (!$this->APIValidate($token)) {
                $msg = array(
                    'error' => "Incorrect token"
                );
                
                return $this->returnErrorJson($msg);
            }
            $categories = $this->getCategoryRepository()->findForSearch(trim($categoria));
            $courses = $this->getCourseRepository()->findForApi($categories);
            if (empty($categories) || empty($courses)) {
                $msg = array(
                    'error' => "Não foi encontrado nenhum curso ativo para a categoria ".$categoria
                );
                
                return $this->returnJson($msg);
            }
            $cursos = array();
            foreach ($courses as $course) {
                $cursoJson = array(
                    'id' => $course->getId(),
                    'nome' => $course->getTitle(),
                );

                $cursos[] = $cursoJson;
            }

            $response = array(
                'cursos' => $cursos
            );
            return $this->returnJson($response);
        } catch (\Exception $e) {
            $error = utf8_encode($e);
            $msg = array(
                'error' => $error
            );
            
            return $this->returnErrorJson($msg);
        }
    }
}
