<?php

namespace ApiBundle\Controller;

use FOS\RestBundle\Controller\FOSRestController;
use Symfony\Component\HttpFoundation\Request;
use JMS\Serializer\SerializerBuilder;
use Symfony\Component\HttpFoundation\Response;

class BaseController extends FOSRestController
{

    /**
     * Adds support for magic finders for repositories.
     *
     * @param string $method
     * @param array  $arguments
     *
     * @return object The found repository.
     * @throws \BadMethodCallException If the method called is an invalid find* method
     *                                 or no find* method at all and therefore an invalid
     *                                 method call.
     */
    public function __call($method, $arguments)
    {
        if (preg_match('/^get(\w+)Repository$/', $method, $matches)) {
            return $this->getDoctrine()->getRepository('AppBundle:' . $matches[1]);
        } else {
            throw new \BadMethodCallException(
            "Undefined method '$method'. Provide a valid repository name!"
        );
        }
    }

    /**
     * Retorna o service "logger".
     * @return \Monolog\Logger
     */
    protected function getLogger()
    {
        return $this->get("logger");
    }

    /**
     * Método para retornar o objeto User.
     * @return CoreBundle\Entity\User
     */
    public function getUser()
    {
        return parent::getUser();
    }

    /**
     * Atalho para geração de logs no sistema.
     * @param string $message Mensagem a ser incluida no log.
     * @param string $level Level do log. Default: error.
     */
    protected function log($message, $level = "error")
    {
        if (is_array($message)) {
            $message = print_r($message, true);
        }
        $this->get('logger')->log($level, '[Unimed-api] ' . $message);
    }

    /**
     * Função que retorna o json para a requisição
     * @param array $return Array de retorno
     * @return \Rockbee\AppBundle\Controller\Response
     */
    public function returnJson($return)
    {
        $serializer = SerializerBuilder::create()->build();
        $return = $serializer->serialize($return, 'json');
        return new Response($return, 200, array('Content-Type' => 'application/json'));
    }

    /**
     * Função que retorna o json para a requisição
     * @param array $return Array de retorno
     * @return \Rockbee\AppBundle\Controller\Response
     */
    public function returnErrorJson($return)
    {
        $serializer = SerializerBuilder::create()->build();
        $return = $serializer->serialize($return, 'json');
        return new Response($return, 400, array('Content-Type' => 'application/json'));
    }
}
