<?php

namespace AppBundle\Command;

use AppBundle\Entity\InscriptionStatus;
use AppBundle\Entity\PaymentStatus;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\HttpFoundation\Request;
use AppBundle\Entity\CourseAccessControl;

/**
 * Command responsável pela verificação dos status dos pedidos que precisam ser cancelados.
 *
 * @author João Zica <joaozica@gmail.com>
 */
class AutoInscriptionCommand extends ContainerAwareCommand
{

    /**
     * Configuração do command.
     */
    protected function configure()
    {
        $this
            ->setName('unimed:update:courses')
        ;
    }

    /**
     * Executa o command.
     * @param \Symfony\Component\Console\Input\InputInterface $input
     * @param \Symfony\Component\Console\Output\OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $em = $this->getContainer()->get('doctrine')->getManager();

        $courses = $this->getCourses();

        $output->writeln('Quant. Cursos');
        $output->writeln(count($courses));

        if (count($courses) > 0) {
            
            foreach ($courses as $course) {
                if($course->getAutoInscription()){
                    $courseAccessControl = $this->getCourseAccessControlRepository()->findBy(array('course'=>$course, 'access' => "Todos"));
                    if(!$courseAccessControl){
                        $output->writeln('Registrar acesso para todos!');
                        $courseAccessControl = new CourseAccessControl();
                        $courseAccessControl->setCourse($course);
                        $courseAccessControl->setAccess("Todos");
                        $em->persist($courseAccessControl);
                    }
                }else{
                    $courseAccessControl = $this->getCourseAccessControlRepository()->findBy(array('course'=>$course, 'access' => "Nenhum"));
                    if(!$courseAccessControl){
                        $output->writeln('Registrar acesso para nenhum!');
                        $courseAccessControl = new CourseAccessControl();
                        $courseAccessControl->setCourse($course);
                        $courseAccessControl->setAccess("Nenhum");
                        $em->persist($courseAccessControl);
                    }
                }
            }

            $output->writeln('Update finalizado com sucesso!');
            $em->flush();
        }
    }

    /**
     * Retorna o repositório de Inscription.
     * @return \AppBundle\Repository\InscriptionRepository
     */
    protected function getIntegrationReturnRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:IntegrationReturn');
    }

    /**
     * Retorna o repositório de Inscription.
     * @return \AppBundle\Repository\InscriptionRepository
     */
    protected function getClientRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:Client');
    }

    /**
     * Retorna o repositório de Inscription.
     * @return \AppBundle\Repository\InscriptionRepository
     */
    protected function getCourseRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:Course');
    }

        /**
     * Retorna o repositório de Inscription.
     * @return \AppBundle\Repository\InscriptionRepository
     */
    protected function getCourseAccessControlRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:CourseAccessControl');
    }

    protected function getCourses()
    {
        return $this->getCourseRepository()->findAll();
    }

    /**
     * Enviar email de cancelamento
     * @param String $email
     * @param String $subject
     * @param String $message
     */
    public function notificationUserEmail($email, $subject, $message)
    {
        $mailMessage = \Swift_Message::newInstance()
              ->setSubject($subject)
              ->setFrom("no-reply@lmssambatech.com.br")
              ->setTo($email)
              ->setContentType("text/html")
              ->setBody($message);

        $this->getContainer()->get('mailer')->send($mailMessage);
    }

    public function transformGroupUser($group)
    {
        $func = function ($item) {
            return strtoupper(trim($item));
        };

        $groupDataList = explode(",", $group);
        $result = array_map($func, $groupDataList);

        return $result;
    }
}
