<?php

namespace AppBundle\Command;

use AppBundle\Entity\InscriptionStatus;
use AppBundle\Entity\PaymentStatus;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

/**
 * Command responsável pela verificação dos status dos pedidos que precisam ser cancelados.
 */
class CheckRegistersCommand extends ContainerAwareCommand
{

    /**
     * Configuração do command.
     */
    protected function configure()
    {
        $this->setName('unimed:check:registers')
             ->setDescription('');
    }

    /**
     * Executa o command.
     * @param \Symfony\Component\Console\Input\InputInterface $input
     * @param \Symfony\Component\Console\Output\OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        // Finaliza lotes que já ultrapassaram a data
        $this->checkRegisters($output);
    }

    /**
     * Verifica inscriptions que precisam ser cancelados.
     * @param \Symfony\Component\Console\Output\OutputInterface $output
     */
    private function checkRegisters(OutputInterface $output)
    {
        // $output->writeln(sprintf('<comment>[%s]</comment> Canceling inscriptions that has overpassed <info>15 minutes</info>.', date('H:i:s')));

        $em = $this->getContainer()->get('doctrine')->getManager();
        $inscriptionLessonRepository = $this->getInscriptionLessonRepository();
        $inscriptionLessons = $inscriptionLessonRepository->getManipulatedRegisters();
        $count = 0;
        $output->writeln('Buscando registros possivelmente manipulados');
        $itens = "";
        foreach($inscriptionLessons as $inscriptionLesson){
            $itens .= "ID: ".$inscriptionLesson->getId()."<br>";
            // $output->writeln($inscriptionLesson->getId());
            $count++;
        }
        if($count > 0){
            // Notificar por email da inscricao feita
            $message = "Os seguintes registros estão com dados que podem ter sidos manipulados: <br>";
            $message .= $itens;
            $message .= "Total de registros ". $count;

            $this->notificationUserEmail("joaozica@gmail.com", "[Unimed] Verificação de registros", $message);
            $this->notificationUserEmail("ramon.msilva@unimedbh.com.br", "[Unimed] Verificação de registros", $message);
        }
        $output->writeln(sprintf('<comment>%s</comment> total de registros.', $count));
    }

    /**
     * Retorna o repositório de Inscription.
     * @return \AppBundle\Repository\InscriptionRepository
     */
    protected function getInscriptionLessonRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:InscriptionLesson');
    }

    /**
     * Enviar email de cancelamento
     * @param String $email
     * @param String $subject
     * @param String $message
     */
    public function notificationUserEmail($email, $subject, $message)
    {
        $mailMessage = \Swift_Message::newInstance()
              ->setSubject("[Unimed] - ".$subject)
              ->setFrom("no-reply@lmssambatech.com.br")
              ->setTo($email)
              ->setContentType("text/html")
              ->setBody($message);

        $this->getContainer()->get('mailer')->send($mailMessage);
    }
}
