<?php

namespace AppBundle\Command;

use AppBundle\Entity\CourseClassStatus;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Command responsável pela verificação da integrações pendentes.
 *
 * @author João Zica <joaozica@gmail.com>
 */
class CourseClassFinalizationCommand extends ContainerAwareCommand
{

    /**
     * Configuração do command.
     */
    protected function configure()
    {
        $this
            ->setName('unimed:course-class:check')
            ->setDescription('Job responsible for check course class.')
        ;
    }

    /**
     * Executa o command.
     * @param \Symfony\Component\Console\Input\InputInterface $input
     * @param \Symfony\Component\Console\Output\OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        // Finaliza lotes que já ultrapassaram a data
        $this->checkCourseClass($output);
    }

    /**
     * Verifica inscriptions que precisam ser cancelados.
     * @param \Symfony\Component\Console\Output\OutputInterface $output
     */
    private function checkCourseClass(OutputInterface $output)
    {
        $output->writeln(sprintf('<comment>[%s]</comment> Finishing courses classes that has overpassed <info>end date</info>.', date('H:i:s')));

        $em = $this->getContainer()->get('doctrine')->getManager();
        $courseClassRepository = $this->getCourseClassRepository();
        $courseClassToFinish = $courseClassRepository->findAll();

        $courseClassStatus = $em->getReference('AppBundle:CourseClassStatus', CourseClassStatus::FECHADO);

        $count = 0;
        foreach ($courseClassToFinish as $courseClass) {
            $toFinish = true;
            foreach ($courseClass->getInscriptionsClass() as $inscriptionsClass) {
                if(!$inscriptionsClass->getInscriptionClassStatus()){
                    $toFinish = false;
                }
            }
            if($toFinish){
                $courseClass->setCourseClassStatus($courseClassStatus);
                $em->persist($courseClass);
                $count++;
            }
        }
        $output->writeln(sprintf('<comment>%s</comment> Courses classes finished.', $count));
        $em->flush();
    }

    /**
     * Retorna o repositório de Inscription.
     * @return \AppBundle\Repository\InscriptionRepository
     */
    protected function getCourseClassRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:CourseClass');
    }
}
