<?php

namespace AppBundle\Command;

use AppBundle\Entity\InscriptionStatus;
use AppBundle\Entity\PaymentStatus;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

/**
 * Command responsável pela verificação dos status dos pedidos que precisam ser cancelados.
 */
class FixCourseCommand extends ContainerAwareCommand
{

    /**
     * Configuração do command.
     */
    protected function configure()
    {
        $this->setName('unimed:courses:fix-user-evaluation')
             ->setDescription('');
    }

    /**
     * Executa o command.
     * @param \Symfony\Component\Console\Input\InputInterface $input
     * @param \Symfony\Component\Console\Output\OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        // Finaliza lotes que já ultrapassaram a data
        $this->fixUserEvaluation($output);
    }

    /**
     * Verifica inscriptions que precisam ser cancelados.
     * @param \Symfony\Component\Console\Output\OutputInterface $output
     */
    private function fixUserEvaluation(OutputInterface $output)
    {
        // $output->writeln(sprintf('<comment>[%s]</comment> Canceling inscriptions that has overpassed <info>15 minutes</info>.', date('H:i:s')));

        $em = $this->getContainer()->get('doctrine')->getManager();
        $inscriptionRepository = $this->getInscriptionRepository();
        $courseRepository = $this->getCourseRepository();
        $courses = $courseRepository->findAll();
        $count = 0;
        $output->writeln('Curso sem avaliação; Numero de matriculados; Total a ser corrigido;');
        foreach ($courses as $course) {
            $countRegistros = 0;
            $countInscriptionsToFix = 0;
            $totalLessons = $course->getTotalLessons();
            if($course->getTotalEvaluations() == 0){
                // $count++;
                $countInscriptionsTotal = $inscriptionRepository->getCountInscriptions($course);
                // $countInscriptionsToFix = $inscriptionRepository->getCountInscriptionsFix($course);
                $inscriptions = $inscriptionRepository->findForFixUserEvaluation($course);
                foreach($inscriptions as $inscription){
                    $totalLessonsWatched = $inscription->getTotalLessonsWatched();
                    // $output->writeln('Percorrendo as inscriptions');
                    // $output->writeln($totalLessons);
                    // $output->writeln($totalLessonsWatched);
                    if($totalLessons <= $totalLessonsWatched){
                        $userEvaluation = $this->getUserEvaluationRepository()->findOneBy(array('user' => $inscription->getUser(), 'course' => $inscription->getCourse()));
                        if($userEvaluation == null){
                            // $output->writeln("Não possui evaluation");
                            $countInscriptionsToFix++;
                            //$userEvaluation = new UserEvaluation();
                            // $userEvaluation->setUser($user);
                            // $userEvaluation->setCourse($course);
                            // $userEvaluation->setGrade(100);
                            // $em->persist($userEvaluation);
                        }
                    }
                }
                // $output->writeln('Curso sem avaliação '.$course->getId());
                // $output->writeln('Numero de matriculados '.$countInscriptionsTotal);
                // $output->writeln('Total a ser corrigido '.$countInscriptionsToFix);
                $output->writeln($course->getId()." - ".$course->getTitle().";". $countInscriptionsTotal.";".$countInscriptionsToFix.";");
                // $output->writeln('Registros que devem ser visualizados '.$countRegistros);
            }
            // $output->writeln('Numero de Cursos Presenciais '.count($courses));
        }
        $output->writeln('Total de Cursos '.$count);

        $em->flush();
    }

    /**
     * Retorna o repositório de Inscription.
     * @return \AppBundle\Repository\InscriptionRepository
     */
    protected function getInscriptionRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:Inscription');
    }

    /**
     * Retorna o repositório de Inscription.
     * @return \AppBundle\Repository\InscriptionRepository
     */
    protected function getCourseRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:Course');
    }

     /**
     * Retorna o repositório de Inscription.
     * @return \AppBundle\Repository\InscriptionRepository
     */
    protected function getUserEvaluationRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:UserEvaluation');
    }
}
