<?php

namespace AppBundle\Command;

use AppBundle\Entity\InscriptionStatus;
use AppBundle\Entity\PaymentStatus;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Command responsável pela verificação da integração de participação pontuada pendente.
 *
 * @author João Zica <joaozica@gmail.com>
 */
class IntegracaoParticipacaoPontuadaPendenteCommand extends ContainerAwareCommand
{

    /**
     * Configuração do command.
     */
    protected function configure()
    {
        $this
            ->setName('unimed:integration:participacao-pontuada')
            ->setDescription('Job responsible for check integracao_participacaopontuada pendente and send data api ParticipacaoPontuada.')
        ;
    }

    /**
     * Executa o command.
     * @param \Symfony\Component\Console\Input\InputInterface $input
     * @param \Symfony\Component\Console\Output\OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $em = $this->getContainer()->get('doctrine')->getManager();

        $listParticipacaoPontuadaPendente = $this->getParticipacaoPontuadaStatusPendente();

        $output->writeln('Quant. IntegracaoParticipacaoPontuada pendente');
        $output->writeln(count($listParticipacaoPontuadaPendente));
        // $notificate = false;
        // $errorArray = array();
        // if (count($listParticipacaoPontuadaPendente) > 0) {
        //     $apiUnimedService = $this->getContainer()->get('apiunimed.service');

        //     foreach ($listParticipacaoPontuadaPendente as $participacaoPontuadaPendente) {
        //         $participacaoPontuada = $this->getIntegracaoParticipacaoPontuadaRepository()->find($participacaoPontuadaPendente->getId());

        //         $body['crmCooperado'] = $participacaoPontuada->getCrmCooperado();
        //         $body['codigoChaveRegra'] = $participacaoPontuada->getCodigoChaveRegra();
        //         $body['codigoOrigem'] = $participacaoPontuada->getCodigoOrigem();
        //         $body['dataReferencia'] = $participacaoPontuada->getDataReferencia()->format('Y-m-d');
        //         $body['indicadorControleTransacao'] = $participacaoPontuada->getIndicadorControleTransacao();

        //         $output->writeln(json_encode($body));

        //         try {
        //             $resParticipacaoPontuada = $apiUnimedService->requestApiGerarPontuacao($body);
        //             $resParticipacaoPontuada = json_decode($resParticipacaoPontuada, true);
    
        //             if (!$resParticipacaoPontuada) {
        //                 $participacaoPontuada->setMsgRetorno("Error API Treinamento Concluido");
        //                 throw new \Exception('Error API Treinamento Concluido');
        //             }
        //             $output->writeln('Request - Parametros recebidos pela API treinamentoConcluido');
        //             $output->writeln(json_encode($resParticipacaoPontuada));

        //             if (isset($resParticipacaoPontuada['descricaoErro'])) {
        //                 $participacaoPontuada->setMsgRetorno($resParticipacaoPontuada['descricaoErro']);
        //             }

        //             if (!empty($body)) {
        //                 $participacaoPontuada->setParameterSent(json_encode($body));
        //             }
        //             if (isset($resParticipacaoPontuada['codigoErro']) && $resParticipacaoPontuada['codigoErro'] != 0) {
        //                 $participacaoPontuada->setCodErro($resParticipacaoPontuada['codigoErro']);
        //                 $participacaoPontuada->setMsgRetorno($resParticipacaoPontuada['descricaoErro']);
        //                 $participacaoPontuada->setStatus('E');

        //                 // Notificar por email da inscricao feita
        //                 // $message = $participacaoPontuada->getMsgRetorno();

        //                 $notificate = true;

        //                 array_push($errorArray, $participacaoPontuada->getParameterSent()."<br>Erro: ".$participacaoPontuada->getMsgRetorno()."<hr>");

        //                 // $this->notificationUserEmail("alexandre.marques@unimedbh.com.br", "[LMS] Erro API Participação Pontuada", $message);
        //                 // $this->notificationUserEmail("ramon.msilva@unimedbh.com.br", "[LMS] Erro API Participação Pontuada", $message);
        //                 $participacaoPontuadaCopy = $apiUnimedService->createClonePendente($participacaoPontuada);
        //                 $em->persist($participacaoPontuadaCopy);
        //             } elseif (!isset($resParticipacaoPontuada['codigoErro']) || $resParticipacaoPontuada['codigoErro'] == 0) {
        //                 $participacaoPontuada->setStatus('I');
        //             }

        //             $em->persist($participacaoPontuada);
        //         } catch (\Exception $e) {
        //             // $integrationReturn->setCodErro(-1);
        //             $participacaoPontuada->setStatus('E');
        //             $participacaoPontuada->setMsgRetorno("Error API Treinamento Concluido");
        //             $notificate = true;
        //             array_push($errorArray, $participacaoPontuada->getParameterSent()."<br>Erro: ".$participacaoPontuada->getMsgRetorno()."<hr>");
        //             $participacaoPontuadaCopy = $apiUnimedService->createClonePendente($participacaoPontuada);
        //             $participacaoPontuada->setParameterSent(json_encode($body));
        //             $em->persist($participacaoPontuada);
        //             $em->persist($participacaoPontuadaCopy);                
        //         }
        //     }

        //     if($notificate){
        //         $this->notificationErrorEmail(["alexandre.marques@unimedbh.com.br", "ramon.msilva@unimedbh.com.br"], "[LMS] Erro API Participação Pontuada", $errorArray);
        //         // $this->notificationErrorEmail(["alexandre.marques@unimedbh.com.br", "ramon.msilva@unimedbh.com.br"], "[LMS] Erro API Participação Pontuada", $errorArray);
        //         // $this->notificationErrorEmail(["joaopaulo.zica@verticis.com.br"], "[LMS] Erro API Participação Pontuada", $errorArray);
        //     }

        //     $output->writeln('GerarPontuacao finalizado com sucesso!');
        //     $em->flush();
        // }
    }

    /**
     * Retorna o repositório de Inscription.
     * @return \AppBundle\Repository\IntegracaoParticipacaoPontuadaRepository
     */
    protected function getIntegracaoParticipacaoPontuadaRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:IntegracaoParticipacaoPontuada');
    }

    protected function getParticipacaoPontuadaStatusPendente()
    {
        // return $this->getIntegrationReturnRepository()->findByStatus('P');
        return $this->getIntegracaoParticipacaoPontuadaRepository()->findPendenteIntegrations();
    }

    /**
     * Enviar email de cancelamento
     * @param String $email
     * @param String $subject
     * @param String $message
     */
    public function notificationUserEmail($email, $subject, $message)
    {
        $mailMessage = \Swift_Message::newInstance()
              ->setSubject($subject)
              ->setFrom("no-reply@lmssambatech.com.br")
              ->setTo($email)
              ->setContentType("text/html")
              ->setBody($message);

        $this->getContainer()->get('mailer')->send($mailMessage);
    }

    /**
     * Enviar email de cancelamento
     * @param String $email
     * @param String $subject
     * @param String $message
     */
    public function notificationErrorEmail($email, $subject, $errorArray)
    {
        $message = "";
        foreach ($errorArray as $value) {
            $message.=$value;
        }
        $mailMessage = \Swift_Message::newInstance()
              ->setSubject($subject)
              ->setFrom("no-reply@lmssambatech.com.br")
              ->setTo($email)
              ->setContentType("text/html")
              ->setBody($message);

        $this->getContainer()->get('mailer')->send($mailMessage);
    }
}
