<?php

namespace AppBundle\Command;

use AppBundle\Entity\InscriptionStatus;
use AppBundle\Entity\PaymentStatus;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Command responsável pela verificação dos status dos pedidos que precisam ser cancelados.
 *
 * @author João Zica <joaozica@gmail.com>
 */
class IntegrationReturnPendenteCommand extends ContainerAwareCommand
{

    /**
     * Configuração do command.
     */
    protected function configure()
    {
        $this
            ->setName('unimed:integration:pendente')
            ->setDescription('Job responsible for check integration return pendente and send data api GerarPontuacao.')
        ;
    }

    /**
     * Executa o command.
     * @param \Symfony\Component\Console\Input\InputInterface $input
     * @param \Symfony\Component\Console\Output\OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $em = $this->getContainer()->get('doctrine')->getManager();

        $integrationsReturnPendente = $this->getIntegrationReturnStatusPendente();

        $output->writeln('Quant. IntegrationReturn pendente');
        $output->writeln(count($integrationsReturnPendente));
        $notificate = false;
        $errorArray = array();

        if (count($integrationsReturnPendente) > 0) {
            $mainService = $this->getContainer()->get('main.service');

            // get token
            $responseToken = $mainService->requestApiExtranetGetToken();
            $responseToken = json_decode($responseToken, true);
    
            if (!isset($responseToken['tokenId'])) {
                throw \Exception('Error ao pegar o token API Informar Treinamento Concluido.');
            }

            $token = $responseToken['tokenId'];

            // $output->writeln($token);

            foreach ($integrationsReturnPendente as $integrationReturnPendente) {
                $integrationReturn = $this->getIntegrationReturnRepository()->find($integrationReturnPendente->getId());
                $user = $integrationReturn->getUser();
                $course = $integrationReturn->getCourse();

                $body['LoginUsuario'] = $user->getCpf();
                // $body['LoginUsuario'] = $user->getLogin();
                $body['CodigoTreinamento'] = $course->getId();
                $body['NomeTreinamento'] = $course->getTitle();

                $userEvaluations = $user->getUserEvaluations()->filter(function ($entry) use ($course) {
                    return $entry->getCourse()->getId() == $course->getId();
                });
            
                $userEvaluation = count($userEvaluations) > 0 ? $userEvaluations->last() : null;
                $dataCourseEnd = $userEvaluation ? $userEvaluation->getDtCreation()->format('Y-m-d\TH:i:s.u\Z') : null;
                $body['DataConclusao'] = $dataCourseEnd;

                $output->writeln(json_encode($body));

                try {
                    $resTreinamentoConcluido = $mainService->requestApiTreinamentoConcluido($token, json_encode($body));
                    $resTreinamentoConcluido = json_decode($resTreinamentoConcluido, true);
    
                    if (!$resTreinamentoConcluido) {
                        $integrationReturn->setMsgReturn("Error API Treinamento Concluido");
                        throw new \Exception('Error API Treinamento Concluido');
                    }
                    $output->writeln('Request - Parametros recebidos pela API treinamentoConcluido');
                    $output->writeln(json_encode($resTreinamentoConcluido));

                    if (isset($resTreinamentoConcluido['Mensagem'])) {
                        $integrationReturn->setMsgReturn($resTreinamentoConcluido['Mensagem']);
                    }

                    if (!empty($body)) {
                        $integrationReturn->setParameterSent(json_encode($body));
                    }

                    if (isset($resTreinamentoConcluido['OcorreuErro']) && $resTreinamentoConcluido['OcorreuErro'] != 0) {
                        $integrationReturn->setCodErro($resTreinamentoConcluido['OcorreuErro']);
                        $integrationReturn->setStatus('E');

                        // // Notificar por email da inscricao feita
                        // $message = $integrationReturn->getMsgReturn();
                        $notificate = true;

                        array_push($errorArray, $integrationReturn->getParameterSent()."<br>Erro: ".$integrationReturn->getMsgReturn()."<hr>");

                        // $this->notificationUserEmail("alexandre.marques@unimedbh.com.br", "[LMS] Erro API Treinamento Concluido", $message);
                        // $this->notificationUserEmail("ramon.msilva@unimedbh.com.br", "[LMS] Erro API Treinamento Concluido", $message);

                        $parameterSent = $integrationReturn->getParameterSent();
                        $dateConclusion = $integrationReturn->getDateConclusion();
                        $integrationReturnPendente = $mainService->createCloneIntegrationReturnPendente($user, $course, $dateConclusion, $parameterSent);
                        $em->persist($integrationReturnPendente);
                    } elseif (!isset($resTreinamentoConcluido['OcorreuErro']) || $resTreinamentoConcluido['OcorreuErro'] == 0) {
                        $integrationReturn->setStatus('I');
                    }

                    $em->persist($integrationReturn);
                } catch (\Exception $e) {
                    // $integrationReturn->setCodErro(-1);
                    $integrationReturn->setStatus('E');
                    $integrationReturn->setParameterSent(json_encode($body));
    
                    $parameterSent = $integrationReturn->getParameterSent();
                    $dateConclusion = $integrationReturn->getDateConclusion();
                    $integrationReturnPendente = $mainService->createCloneIntegrationReturnPendente($user, $course, $dateConclusion, $parameterSent);
                    $em->persist($integrationReturn);
                    $em->persist($integrationReturnPendente);
                    $notificate = true;
                    array_push($errorArray, $integrationReturn->getParameterSent()."<br>Erro: Exceção no retorno da api<hr>");
                }
            }

            if($notificate){
                // $this->notificationErrorEmail(["alexandre.marques@unimedbh.com.br", "ramon.msilva@unimedbh.com.br", "joaozica@gmail.com"], "[LMS] Erro API Treinamento Concluido", $errorArray);
                // $this->notificationErrorEmail(["alexandre.marques@unimedbh.com.br", "ramon.msilva@unimedbh.com.br"], "[LMS] Erro API Participação Pontuada", $errorArray);
                // $this->notificationErrorEmail(["joaopaulo.zica@verticis.com.br"], "[LMS] Erro API Participação Pontuada", $errorArray);
            }

            $output->writeln('GerarPontuacao secretária finalizado com sucesso!');
            $em->flush();
        }
    }

    /**
     * Retorna o repositório de Inscription.
     * @return \AppBundle\Repository\InscriptionRepository
     */
    protected function getIntegrationReturnRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:IntegrationReturn');
    }

    /**
     * Retorna o repositório de Inscription.
     * @return \AppBundle\Repository\InscriptionRepository
     */
    protected function getClientRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:Client');
    }

    protected function getIntegrationReturnStatusPendente()
    {
        // return $this->getIntegrationReturnRepository()->findByStatus('P');
        return $this->getIntegrationReturnRepository()->findPendenteIntegrations();
    }

    /**
     * Enviar email de cancelamento
     * @param String $email
     * @param String $subject
     * @param String $message
     */
    public function notificationUserEmail($email, $subject, $message)
    {
        $mailMessage = \Swift_Message::newInstance()
              ->setSubject($subject)
              ->setFrom("no-reply@lmssambatech.com.br")
              ->setTo($email)
              ->setContentType("text/html")
              ->setBody($message);

        $this->getContainer()->get('mailer')->send($mailMessage);
    }

    /**
     * Enviar email de cancelamento
     * @param String $email
     * @param String $subject
     * @param String $message
     */
    public function notificationErrorEmail($email, $subject, $errorArray)
    {
        $message = "";
        foreach ($errorArray as $value) {
            $message.=$value;
        }
        $mailMessage = \Swift_Message::newInstance()
              ->setSubject($subject)
              ->setFrom("no-reply@lmssambatech.com.br")
              ->setTo($email)
              ->setContentType("text/html")
              ->setBody($message);

        $this->getContainer()->get('mailer')->send($mailMessage);
    }
}
