<?php

namespace AppBundle\Command;

use AppBundle\Entity\InscriptionStatus;
use AppBundle\Entity\PaymentStatus;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Command responsável pela verificação dos status dos pedidos que precisam ser cancelados.
 *
 * @author João Zica <joaozica@gmail.com>
 */
class SendQueueMailsCommand extends ContainerAwareCommand
{

    /**
     * Configuração do command.
     */
    protected function configure()
    {
        $this
            ->setName('unimed:jobs:send-queue-mails')
        ;
    }

    /**
     * Executa o command.
     * @param \Symfony\Component\Console\Input\InputInterface $input
     * @param \Symfony\Component\Console\Output\OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $em = $this->getContainer()->get('doctrine')->getManager();

        $registers = $this->getRegisters();

        $output->writeln('Quant. Registers');
        $output->writeln(count($registers));

        if (count($registers) > 0) {
            
            foreach ($registers as $register) {

                if($register->getErrorExecution()){
                    $message = "<p>O relatório não foi gerado corretamente. Segue o erro abaixo</p> ". $register->getObservation();
                    $this->notificationErrorEmail($register->getEmail(), 'Erro ao gerar relatório - ' . $register->getReport(), $message);
                }else{
                    if($register->getPathFile()){
                        $message = '<p>O relatório já pode ser baixado pelo link abaixo</p>
                         <a href="https://lmssambatech.com.br' . $register->getPathFile() . '">Baixar arquivo</a>';
                        $this->notificationUserEmail($register->getEmail(), 'Relatório gerado com sucesso - ' . $register->getReport(), $message);
                    }else{
                        $message = "<p>O relatório foi gerado, porém nenhuma informação foi encontrada com o script informado.</p>";
                        $this->notificationUserEmail($register->getEmail(), 'Relatório Vazio - ' . $register->getReport(), $message);
                    }
                }
                // $output->writeln($register->getId());
                $register->setSended(true);
                $em->persist($register);
                
            }
            $em->flush();
        }
    }


    protected function getRegisters()
    {
        return $this->getQueueJobMailRepository()->findBy(array(
            'sended' => false
        ));
    }

    protected function getQueueJobMailRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:QueueJobMail');
    }

    /**
     * Enviar email de cancelamento
     * @param String $email
     * @param String $subject
     * @param String $message
     */
    public function notificationUserEmail($email, $subject, $message)
    {
        $mailMessage = \Swift_Message::newInstance()
              ->setSubject($subject)
              ->setFrom("no-reply@lmssambatech.com.br")
              ->setTo($email)
              ->setContentType("text/html")
              ->setBody($message);

        $this->getContainer()->get('mailer')->send($mailMessage);
    }

    /**
     * Enviar email de cancelamento
     * @param String $email
     * @param String $subject
     * @param String $message
     */
    public function notificationErrorEmail($email, $subject, $message)
    {
        $mailMessage = \Swift_Message::newInstance()
              ->setSubject($subject)
              ->setFrom("no-reply@lmssambatech.com.br")
              ->setTo($email)
              ->setContentType("text/html")
              ->setBody($message);

        $this->getContainer()->get('mailer')->send($mailMessage);
    }

}