<?php

namespace AppBundle\Command;

use AppBundle\Entity\InscriptionStatus;
use AppBundle\Entity\PaymentStatus;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Command responsável pela verificação dos status dos pedidos que precisam ser cancelados.
 *
 * @author João Zica <joaozica@gmail.com>
 */
class UpdateSurveyAnswersCommand extends ContainerAwareCommand
{

    /**
     * Configuração do command.
     */
    protected function configure()
    {
        $this
            ->setName('unimed:update:survey-answers')
        ;
    }

    /**
     * Executa o command.
     * @param \Symfony\Component\Console\Input\InputInterface $input
     * @param \Symfony\Component\Console\Output\OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $em = $this->getContainer()->get('doctrine')->getManager();

        $answers = $this->getAnswers();

        $output->writeln('Quant. Answers');
        $output->writeln(count($answers));
        $i = 0;
        foreach ($answers as $answer) {
            $i++;
            $answer->setIdTeste($i);
            $em->persist($answer);
            $output->writeln("Registro ".$i);
        }
        $em->flush();
    }

    /**
     * Retorna o repositório de Inscription.
     * @return \AppBundle\Repository\InscriptionRepository
     */
    protected function getSurveyAnswerRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:SurveyAnswer');
    }

    protected function getAnswers()
    {
        return $this->getSurveyAnswerRepository()->findAll();
    }
}
