<?php

namespace AppBundle\Command;

use AppBundle\Entity\InscriptionStatus;
use AppBundle\Entity\PaymentStatus;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Command responsável pela verificação dos status dos pedidos que precisam ser cancelados.
 *
 * @author João Zica <joaozica@gmail.com>
 */
class UpdateUserEvaluationCourseCommand extends ContainerAwareCommand
{

    /**
     * Configuração do command.
     */
    protected function configure()
    {
        $this
            ->setName('unimed:update:user_evaluation_course')
        ;
    }

    /**
     * Executa o command.
     * @param \Symfony\Component\Console\Input\InputInterface $input
     * @param \Symfony\Component\Console\Output\OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $em = $this->getContainer()->get('doctrine')->getManager();

        $courses = $this->getCourses();

        $output->writeln('Quant. Courses');
        $output->writeln(count($courses));

        if (count($courses) > 0) {
            
            foreach ($courses as $course) {
                $output->writeln("update user_evaluation set approved = 1 where course_id = ". $course->getId().";");
            }
        }
    }

    protected function getCourseRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:Course');
    }

    protected function getCourses()
    {
        $courses = array();
        $list = $this->getCourseRepository()->findAll();
        foreach ($list as $item) {
            if($item->getTotalEvaluations()==0){
                array_push($courses, $item);
            }
        }
        return $courses;
    }

    protected function getUserEvaluationRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:UserEvaluation');
    }

}