<?php

namespace AppBundle\Command;

use AppBundle\Entity\InscriptionStatus;
use AppBundle\Entity\PaymentStatus;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Command responsável pela verificação dos status dos pedidos que precisam ser cancelados.
 *
 * @author João Zica <joaozica@gmail.com>
 */
class UpdateUsersCommand extends ContainerAwareCommand
{

    /**
     * Configuração do command.
     */
    protected function configure()
    {
        $this
            ->setName('unimed:update:users')
        ;
    }

    /**
     * Executa o command.
     * @param \Symfony\Component\Console\Input\InputInterface $input
     * @param \Symfony\Component\Console\Output\OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $em = $this->getContainer()->get('doctrine')->getManager();

        $clients = $this->getClients();

        $output->writeln('Quant. Clients');
        $output->writeln(count($clients));

        if (count($clients) > 0) {
            
            foreach ($clients as $client) {
                $groupUser = $this->transformGroupUser($client->getGroup());
                if($client->getNumEnterprise()==2){
                    $output->writeln('Terceiro');
                    $client->setUsergroup($em->getReference('AppBundle:UserGroup', 3));
                }else if($client->getNumEnterprise()==3){
                    $output->writeln('Cooperado');
                    $client->setUsergroup($em->getReference('AppBundle:UserGroup', 1));
                }else if($client->getNumEnterprise()==3000){
                    $output->writeln('Colaborador');
                    $client->setUsergroup($em->getReference('AppBundle:UserGroup', 2));
                }else if($client->getNumEnterprise()==1 && $client->getTipColaborador() == 1){
                    $output->writeln('Colaborador');
                    $client->setUsergroup($em->getReference('AppBundle:UserGroup', 2));
                }else if($client->getNumEnterprise()==3 && $client->getTipColaborador() == 1){
                    $output->writeln('Cooperado');
                    $client->setUsergroup($em->getReference('AppBundle:UserGroup', 1));
                }else if($client->getNumEnterprise()==1 && $client->getTipColaborador() == 2){
                    $output->writeln('Terceiro');
                    $client->setUsergroup($em->getReference('AppBundle:UserGroup', 3));
                }else if(in_array("CLAUSU.PERFIL_SECRETARIA_MEDICO", $groupUser)
                && in_array("OUTSYS_PORTALATENDENTE.PERFIL_COMUM", $groupUser)){
                    $client->setUsergroup($em->getReference('AppBundle:UserGroup', 4));
                    $output->writeln('Secretária');
                }
                $em->persist($client);
            }

            $output->writeln('Update finalizado com sucesso!');
            $em->flush();
        }
    }

    /**
     * Retorna o repositório de Inscription.
     * @return \AppBundle\Repository\InscriptionRepository
     */
    protected function getIntegrationReturnRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:IntegrationReturn');
    }

    /**
     * Retorna o repositório de Inscription.
     * @return \AppBundle\Repository\InscriptionRepository
     */
    protected function getClientRepository()
    {
        return $this->getContainer()->get('doctrine')->getRepository('AppBundle:Client');
    }

    protected function getClients()
    {
        return $this->getClientRepository()->findAll();
    }

    /**
     * Enviar email de cancelamento
     * @param String $email
     * @param String $subject
     * @param String $message
     */
    public function notificationUserEmail($email, $subject, $message)
    {
        $mailMessage = \Swift_Message::newInstance()
              ->setSubject($subject)
              ->setFrom("no-reply@lmssambatech.com.br")
              ->setTo($email)
              ->setContentType("text/html")
              ->setBody($message);

        $this->getContainer()->get('mailer')->send($mailMessage);
    }

    public function transformGroupUser($group)
    {
        $func = function ($item) {
            return strtoupper(trim($item));
        };

        $groupDataList = explode(",", $group);
        $result = array_map($func, $groupDataList);

        return $result;
    }
}
