<?php

namespace AppBundle\Controller\Backend;

use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use AppBundle\Entity\Banner;
use AppBundle\Entity\BannerFilter;
use AppBundle\Form\BannerType;

/**
 * Banner controller.
 *
 * @Route("/backend/banner")
 */
class BannerController extends BaseController
{
    /**
     * @Route("/" , name="backend_banner")
     * @Template("AppBundle:Backend\Banner:index.html.twig")
     */
    public function indexAction()
    {
        $this->verificationUserAccessControl('index_banner');
        
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('AppBundle:Banner')->findAll();

        return array(
            'entities' => $entities,
        );
    }

    /**
     * Creates a new Banner entity.
     *
     * @Route("/create", name="backend_banner_create")
     * @Method("POST")
     * @Template("AppBundle:Backend\Banner:new.html.twig")
     */
    public function createAction(Request $request)
    {
        $this->verificationUserAccessControl('new_banner');

        $banner = new Banner();
        $form = $this->createCreateForm($banner);

        $dataRequest = $request->request->all();

        $form->handleRequest($request);
        if ($form->isValid()) {
            try {
                $em = $this->getDoctrine()->getManager();

                $this->handleBannerFilterCustom($banner, $dataRequest);

                $em->persist($banner);
                $em->flush();

                $this->successMessage($request, 'Registro criado com sucesso!');

                return $this->redirect($this->generateUrl('backend_banner', array('id' => $banner->getId())));
            } catch (\Exception $e) {
                $this->log($e);
                $this->errorMessage($request, 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $banner,
            'form' => $form->createView(),
        );
    }

    /**
     * Creates a form to create a Banner entity.
     *
     * @param Banner $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Banner $entity)
    {
        $form = $this->createForm(new BannerType(), $entity, array(
            'action' => $this->generateUrl('backend_banner_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
     * Displays a form to create a new Category entity.
     *
     * @Route("/new", name="backend_banner_new")
     * @Method("GET")
     * @Template()
     */
    public function newAction()
    {
        $this->verificationUserAccessControl('new_banner');

        $banner = new Banner();
        $form = $this->createCreateForm($banner);

        $em = $this->getDoctrine()->getManager();
        $bannerFilter = $em->getRepository('AppBundle:BannerFilter')->findOneByBanner($banner);

        return array(
            'entity' => $banner,
            'form' => $form->createView(),
            'banner_filter' => $bannerFilter
        );
    }

    /**
     * Displays a form to edit an existing Category entity.
     *
     * @Route("/{id}/edit", name="backend_banner_edit")
     * @Method("GET")
     * @Template()
     */
    public function editAction($id)
    {
        $this->verificationUserAccessControl('edit_banner');

        $em = $this->getDoctrine()->getManager();

        $banner = $em->getRepository('AppBundle:Banner')->find($id);

        if (!$banner) {
            throw $this->createNotFoundException('Unable to find Banner entity.');
        }

        $bannerFilter = $em->getRepository('AppBundle:BannerFilter')->findOneByBanner($banner);

        $editForm = $this->createEditForm($banner);
        return array(
            'entity' => $banner,
            'edit_form' => $editForm->createView(),
            'banner_filter' => $bannerFilter
        );
    }

    /**
    * Creates a form to edit a Banner entity.
    *
    * @param Banner $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditForm(Banner $entity)
    {
        $form = $this->createForm(new BannerType(), $entity, array(
            'action' => $this->generateUrl('backend_banner_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }
    /**
     * Edits an existing Category entity.
     *
     * @Route("/{id}", name="backend_banner_update")
     * @Method("PUT")
     * @Template("AppBundle:Backend\Banner:edit.html.twig")
     */
    public function updateAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('edit_banner');

        $em = $this->getDoctrine()->getManager();

        $banner = $em->getRepository('AppBundle:Banner')->find($id);

        if (!$banner) {
            throw $this->createNotFoundException('Unable to find Banner entity.');
        }

        $dataRequest = $request->request->all();

        $editForm = $this->createEditForm($banner);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            try {
                $this->handleBannerFilterCustom($banner, $dataRequest);

                $this->successMessage($request, 'Registro criado com sucesso!');

                $em->flush();

                return $this->redirect($this->generateUrl('backend_banner', array('id' => $id)));
            } catch (\Exception $e) {
                $this->log($e);
                $this->errorMessage($request, 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $banner,
            'edit_form' => $editForm->createView(),
        );
    }
    /**
     * Deletes a Banner entity.
     *
     * @Route("/{id}/delete", name="backend_banner_delete")
     *
     */
    public function deleteAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('remove_banner');

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('AppBundle:Banner')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Banner entity.');
        }

        $em->remove($entity);
        $em->flush();

        $this->successMessage($request, 'Registro excluído com sucesso!');

        return $this->redirect($this->generateUrl('backend_banner'));
    }

    public function handleBannerFilterCustom($banner, $dataRequest)
    {
        try {
            $sectors = $dataRequest['sector'] ? explode('||', $dataRequest['sector']) : null;
            $jobRoles = $dataRequest['job_role'] ? explode('||', $dataRequest['job_role']) : null;
            $managements = $dataRequest['management'] ? explode('||', $dataRequest['management']) : null;

            $em = $this->getDoctrine()->getManager();
            $bannerFilter = $em->getRepository('AppBundle:BannerFilter')->findOneByBanner($banner);

            if (!$bannerFilter) {
                $bannerFilter = new BannerFilter();
                $bannerFilter->setBanner($banner);
            }

            // De vês em enquando dá um erro que não grava os campos sector, job_roles e management
            // Por último falta fazer a verificação la no HomeController

            $bannerFilter->setSectors(json_encode($sectors));
            $bannerFilter->setJobRoles(json_encode($jobRoles));
            $bannerFilter->setManagements(json_encode($managements));

            $em->persist($bannerFilter);
        } catch (Exception $e) {
            $this->log($e);
        }
    }
}
