<?php

namespace AppBundle\Controller\Backend;

use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use AppBundle\Entity\Client;
use AppBundle\Form\ClientBackendType;

/**
 * ClientBackend controller.
 *
 */
class ClientBackendController extends BaseController
{
    /**
     * @Route("/privado/client/{company_id}" , name="backend_clientresponsible")
     * @Template("AppBundle:Backend\Client:index.responsible.html.twig")
     */
    public function indexAction($company_id)
    {
        if ($this->get('security.authorization_checker')->isGranted('ROLE_SUPER_ADMIN')) {
            return $this->redirect($this->generateUrl('backend_client'));
        } else {
            $this->verifyAdminOrResponsabile();

            $company = $this->getCompanyRepository()->find($company_id);
            if ($company == null) {
                throw $this->createNotFoundException('Empresa não encontrada');
            }

            $em = $this->getDoctrine()->getManager();

            $entities = $em->getRepository('AppBundle:Client')->findByCompany($company);

            return array(
              'entities' => $entities,
          );
        }
    }

    /**
    * Atualiza o Status do Usuários para ATIVO
    *
    * @Route("/?id={id}", name="backend_clientresponsible_status")
    */
    public function activateStatusAction($id)
    {
        $this->verifyAdminOrResponsabile();
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:Client')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Client entity.');
        }

        $condicao = $entity->getStatus();
        if ($condicao == "Habilitado") {
            $entity->setEnabled(false);
        } else {
            $entity->setEnabled(true);
        }

        $em->persist($entity);
        $em->flush();

        if ($this->get('security.authorization_checker')->isGranted('ROLE_SUPER_ADMIN')) {
            return $this->redirect($this->generateUrl('backend_client'));
        } else {
            $company = $this->getUser()->getCompany();
            return $this->redirect($this->generateUrl('backend_clientresponsible', array('company_id' => $company->getId())));
        }
    }
}
