<?php

namespace AppBundle\Controller\Backend;

use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Entity\Client;
use AppBundle\Form\ClientBackendType;
use AppBundle\Form\ClientBackendLearningTrailType;

/**
 * Client controller.
 *
 * @Route("/backend/funcionario")
 */
class ClientController extends BaseController
{
    protected $jobRoleDefault = "Nao informado";
    protected $sectorDefault = "Nao informado";
    protected $userStatusDefault = "Outros";

    /**
     * @Route("/search-funcionarios" , name="backend_client_ajax", options={"expose"=true})
     */
    public function clientAjaxAction(Request $request)
    {
        $get = $request->query->all();

        //obtem as empresas da qual o usuário tem acesso
        $enterprises = $this->getEnterpriseAccessControl();

        $em = $this->getDoctrine()->getManager();
        $columns = array( 'client.id', 'CONCAT(client.first_name,client.last_name)', 'sector.name', "jobRole.name", "userStatus.name", "client.mat_colaborador", "client.email", 'client.first_name', 'client.last_name', 'client.cpf');
        $get['columns'] = &$columns;

        $em = $this->getDoctrine()->getEntityManager();
        // $rResult = $em->getRepository('AppBundle:Client')->ajaxTable($get, true)->getArrayResult();
        $rResult = $em->getRepository('AppBundle:Client')->ajaxTable($get, false, false, $enterprises);
        $iFilteredTotal = $em->getRepository('AppBundle:Client')->ajaxTable($get, false, true, $enterprises);

        /* Data set length after filtering */
        // $iFilteredTotal = count($rResult);

        /*
         * Output
         */
        $output = array(
          "sEcho" => intval($get['sEcho']),
          "iTotalRecords" => $em->getRepository('AppBundle:Client')->getCount($enterprises),
        //   "iTotalDisplayRecords" => $em->getRepository('AppBundle:Client')->getCount(),
          "iTotalDisplayRecords" => $iFilteredTotal,
          "aaData" => array()
        );

        foreach ($rResult as $aRow) {
            $row = array();
            //   for ( $i=0 ; $i<count($columns) ; $i++ ){
            //     if ( $columns[$i] == "version" ){
            //       /* Special output formatting for 'version' column */
            //       $row[] = ($aRow[ $columns[$i] ]=="0") ? '-' : $aRow[ $columns[$i] ];
            //     }elseif ( $columns[$i] != ' ' ){
            //       /* General output */
            //       $row[] = $aRow[ $columns[$i] ];
            //     }
            //   }
            //Nome completo
            $client = $em->getRepository('AppBundle:Client')->find($aRow->getId());
            if ($client) {
                $row[0] = $client->getFullName();
                //Nome do setor
                $row[1] = $client->getSector() ? $client->getSector()->getName() : "" ;
                //Nome do cargo
                $row[2] = $client->getJobRole() ? $client->getJobRole()->getName() : "";
                //Nome do status
                $row[3] = $client->getUserStatus() ? $client->getUserStatus()->getName() : "";
                //Matrícula
                $row[4] = $client->getMatColaborador() ? $client->getMatColaborador() : "";
                //CPF
                $row[5] = $client->getCpf() ? $client->getCpf() : "";
    
                //Acoes
                $editButton ="";
                $accessButton ="";
                $enableButton ="";
                $trailButton ="";
                
                if ($this->verificationUserAccessControl('edit_client', $viewTemplate = true)) {
                    // - Editar
                    $editUrl = $this->generateUrl('backend_client_edit', array('id' => $aRow->getId()));
                    $editButton = '<a href="'.$editUrl.'" class="btn btn-primary" title="Editar"><i class="fa fa-pencil-square-o"></i></a>';
                }
                    
                // - Acesso com determinado Usuário
                if ($this->verificationUserAccessControl('show_in_client', $viewTemplate = true)) {
                    $accessUrl = $this->generateUrl('homepage', array('_switch_user' => $aRow->getUsername()));
                    $accessButton = '<a href="'.$accessUrl.'" class="btn btn-info" title="Acessar como usuário"><i class="fa fa-eye" aria-hidden="true"></i></a>';
                }

                // - Habilitar/Desabilitar
                $enableUrl = $this->generateUrl('backend_client_status', array('id' => $aRow->getId()));

                if ($aRow->getStatus() == "Habilitado") {
                    if ($this->verificationUserAccessControl('disable_client', $viewTemplate = true)) {
                        $enableButton = '<a href="' . $enableUrl . '" class="btn btn-warning" title="Desabilitar"><i class="fa fa-times" aria-hidden="true"></i></a>';
                    }
                } else {
                    if ($this->verificationUserAccessControl('disable_client', $viewTemplate = true)) {
                        $enableButton = '<a href="'.$enableUrl.'" class="btn btn-success" title="Habilitar"><i class="fa fa-check" aria-hidden="true"></i></a>';
                    }
                }

    
                if ($this->verificationUserAccessControl('add_trail_client', $viewTemplate = true)) {
                    // - Trilha do funcionario
                    $trailUrl = $this->generateUrl('backend_client_trilha', array('clientId' => $aRow->getId()));
                    $trailButton = '<a href="'.$trailUrl.'" class="btn btn-other" title="Trilha de Aprendizado"><i class="fa fa-sort-amount-asc"></i></a>';
                }
    
                // $row[5] = $editButton."&nbsp;".$enableButton."&nbsp;".$trailButton;
                $row[6] = $editButton."&nbsp;".$accessButton."&nbsp;".$enableButton."&nbsp;".$trailButton;
                $output['aaData'][] = $row;
            }
        }
        unset($rResult);
        return new Response(
            json_encode($output)
        );
    }
    /**
     * @Route("/" , name="backend_client")
     * @Template("AppBundle:Backend\Client:index.html.twig")
     */
    public function indexAction()
    {
        $this->verificationUserAccessControl('index_client');
        $em = $this->getDoctrine()->getManager();

        // $entities = $em->getRepository('AppBundle:Client')->findAll();
        //
        // $paginator = $this->get('knp_paginator');
        // $pagination = $paginator->paginate(
        //     $entities, $this->get('request')->query->get('page', 1), 12
        // );

        $entities = array();

        return array(
            'entities' => $entities,
        );
    }

    /**
     * Creates a new Client entity.
     *
     * @Route("/create", name="backend_client_create")
     * @Method("POST")
     * @Template("AppBundle:Backend\Client:new.html.twig")
     */
    public function createAction(Request $request)
    {
        $this->verificationUserAccessControl('new_client');

        $entity = new Client();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);
        if ($form->isValid()) {
            $entity->setCpf($entity->getCpfOnlyNumbers());
            if (!$this->validCPF($entity)) {
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'CPF já cadastrado, tente novamente!');
                return array(
                    'entity' => $entity,
                    'form' => $form->createView(),
                );
            }

            if ($this->validUsernameEmail($entity)) {
                try {
                    $em = $this->getDoctrine()->getManager();

                    $email = $form->get('email')->getData();

                    // Set entity fields custom
                    $this->requestCustomForm($request, $entity);

                    $entity->setUsername($email);
                    $entity->setEnabled(true);
                    $entity->setRoles(array("ROLE_USER"));

                    $em->persist($entity);
                    $em->flush();

                    $request->getSession()
                        ->getFlashBag()
                        ->add('success', 'Registro criado com sucesso!');

                    return $this->redirect($this->generateUrl('backend_client', array('id' => $entity->getId())));
                } catch (\Exception $e) {
                    $this->log($e);
                    $request->getSession()
                        ->getFlashBag()
                        ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
                }
            } else {
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Email já cadastrado, tente novamente!');
            }
        }

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Creates a form to create a Client entity.
     *
     * @param Client $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Client $entity)
    {
        $form = $this->createForm(new ClientBackendType(), $entity, array(
            'action' => $this->generateUrl('backend_client_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
     * Creates a form to create a Client entity.
     *
     * @param Client $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateLearningTrailForm(Client $entity)
    {
        $form = $this->createForm(new ClientBackendLearningTrailType(), $entity, array(
            'action' => $this->generateUrl('backend_client_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
     * Displays a form to create a new Client entity.
     *
     * @Route("/new", name="backend_client_new")
     * @Method("GET")
     * @Template()
     */
    public function newAction()
    {
        $this->verificationUserAccessControl('new_client');
        $em = $this->getDoctrine()->getManager();
        $entity = new Client();
        $sector = $em->getRepository('AppBundle:Sector')->findOneByName($this->sectorDefault);
        $entity->setSector($sector);
        $jobRole = $em->getRepository('AppBundle:JobRole')->findOneByName($this->jobRoleDefault);
        $entity->setJobRole($jobRole);
        $userStatus = $em->getRepository('AppBundle:UserStatus')->findOneByName($this->userStatusDefault);
        $entity->setUserStatus($userStatus);
        $form = $this->createCreateForm($entity);

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Displays a form to edit an existing Client entity.
     *
     * @Route("/{id}/edit", name="backend_client_edit")
     * @Method("GET")
     * @Template()
     */
    public function editAction($id)
    {
        $this->verificationUserAccessControl('edit_client');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:Client')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Client entity.');
        }

        if(!$entity->getSector()){
            $sector = $em->getRepository('AppBundle:Sector')->findOneByName($this->sectorDefault);
            $entity->setSector($sector);
        }
        if(!$entity->getJobRole()){
            $jobRole = $em->getRepository('AppBundle:JobRole')->findOneByName($this->jobRoleDefault);
            $entity->setJobRole($jobRole);
        }
        if(!$entity->getUserStatus()){
            $userStatus = $em->getRepository('AppBundle:UserStatus')->findOneByName($this->userStatusDefault);
            $entity->setUserStatus($userStatus);
        }

        $editForm = $this->createEditForm($entity);
        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }

    /**
    * Creates a form to edit a Client entity.
    *
    * @param Client $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditForm(Client $entity)
    {
        $form = $this->createForm(new ClientBackendType(), $entity, array(
            'action' => $this->generateUrl('backend_client_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }
    /**
     * Edits an existing Client entity.
     *
     * @Route("/{id}", name="backend_client_update")
     * @Method("PUT")
     * @Template("AppBundle:Backend\Client:edit.html.twig")
     */
    public function updateAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('edit_client');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:Client')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Client entity.');
        }

        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $entity->setCpf($entity->getCpfOnlyNumbers());
            if (!$this->validCPF($entity)) {
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'CPF já cadastrado, tente novamente!');
                return array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                );
            }
            if ($this->validUsernameEmail($entity)) {
                try {
                    // Set entity fields custom
                    $this->requestCustomForm($request, $entity);
                    $entity->setRoles(array("ROLE_USER"));
                    $entity->setUsername($entity->getEmail());
                    $em->flush();

                    $request->getSession()
                        ->getFlashBag()
                        ->add('success', 'Registro atualizado com sucesso!');

                    return $this->redirect($this->generateUrl('backend_client', array('id' => $id)));
                } catch (\Exception $e) {
                    $this->log($e);
                    $request->getSession()
                        ->getFlashBag()
                        ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
                }
            } else {
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Email já cadastrado, tente novamente!');
            }
        }

        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }
    /**
     * Deletes a Client entity.
     *
     * @Route("/{id}/delete", name="backend_client_delete")
     *
     */
    public function deleteAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('remove_client');

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('AppBundle:Client')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Client entity.');
        }

        $em->remove($entity);
        $em->flush();

        return $this->redirect($this->generateUrl('backend_client'));
    }

    /**
    * Atualiza o Status do Usuários para ATIVO
    *
    * @Route("/?id={id}", name="backend_client_status")
    */
    public function activateStatusAction($id)
    {
        if ($this->get('security.authorization_checker')->isGranted('ROLE_SUPER_ADMIN')) {
            $em = $this->getDoctrine()->getManager();

            $entity = $em->getRepository('AppBundle:Client')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Client entity.');
            }

            $condicao = $entity->getStatus();
            if ($condicao == "Habilitado") {
                $entity->setEnabled(false);
            } else {
                $entity->setEnabled(true);
            }

            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('backend_client', array('id' => $id)));
        } else {
            throw $this->createNotFoundException('Você não tem permissão para acessar esta tela.');
        }
    }

    /**
     * Set entity fields custom
     * @param Request $request
     * @param Entity $entity
     */
    public function requestCustomForm($request, $entity)
    {
        $em = $this->getDoctrine()->getManager();
        $clientCustomArray = $request->request->get('client_custom');

        if (!empty($clientCustomArray['plainPassword'])) {
            $encoder = $this->container->get('security.encoder_factory')->getEncoder($entity);
            $new_pwd_encoded = $encoder->encodePassword($clientCustomArray['plainPassword'], $entity->getSalt());
            $entity->setPassword($new_pwd_encoded);
        }
    }

    /**
     * Displays a form to create a new Client entity.
     *
     * @Route("/trilha-aprendizado/associar/{clientId}", name="backend_client_trilha")
     * @Method({"GET", "POST"})
     * @Template("AppBundle:Backend\Client:trilha.client.html.twig")
     */
    public function clientTrilhaAction(Request $request, $clientId)
    {
        $this->verificationUserAccessControl('add_trail_client');
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('AppBundle:Client')->find($clientId);
        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Client entity.');
        }
        $form = $this->createCreateLearningTrailForm($entity);

        if ($request->isMethod('POST')) {
            $form->handleRequest($request);
            $em->flush();

            $request->getSession()
                 ->getFlashBag()
                 ->add('success', 'Registro atualizado com sucesso!');
            return $this->redirect($this->generateUrl('backend_client'));
        }

        return array(
            'entity' => $entity,
            'form'   => $form->createView(),
        );
    }
}
