<?php

namespace AppBundle\Controller\Backend;

use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use AppBundle\Entity\Client;
use AppBundle\Form\ClientBackendType;
use AppBundle\Form\ClientBackendLearningTrailType;

/**
 * Comment controller.
 *
 * @Route("/backend/comentarios")
 */
class CommentController extends BaseController
{
    /**
     * @Route("/" , name="backend_comment")
     * @Template("AppBundle:Backend\Comment:index.html.twig")
     */
    public function indexAction()
    {
        $this->verificationUserAccessControl('index_comment_course');
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('AppBundle:CommentCourse')->findAll();

        return array(
            'entities' => $entities,
        );
    }

    /**
     * Displays a form to edit an existing CommentCourse entity.
     *
     * @Route("/{id}/edit", name="backend_comment_edit")
     * @Method("GET")
     * @Template()
     */
    public function commentAction($id)
    {
        // $this->verificationUserAccessControl('edit_comment_course');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:CommentCourse')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find CommentCourse entity.');
        }

        $editForm = $this->createEditForm($entity);
        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }

    /**
    * Creates a form to edit a CommentCourse entity.
    *
    * @param CommentCourse $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditForm(CommentCourse $entity)
    {
        $form = $this->createForm(new CommentCourseBackendType(), $entity, array(
            'action' => $this->generateUrl('backend_comment_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }
    /**
     * Edits an existing CommentCouse entity.
     *
     * @Route("/{id}", name="backend_comment_update")
     * @Method("PUT")
     * @Template("AppBundle:Backend\CommentCourse:edit.html.twig")
     */
    public function updateAction(Request $request, $id)
    {
        // $this->verificationUserAccessControl('edit_comment_course');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:CommentCourse')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find CommentCourse entity.');
        }

        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            try {
                // Set entity fields custom
                $this->requestCustomForm($request, $entity);
                $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro atualizado com sucesso!');

                return $this->redirect($this->generateUrl('backend_comment', array('id' => $id)));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }
    /**
     * Deletes a CommentCourse entity.
     *
     * @Route("/{id}/delete", name="backend_comment_delete")
     *
     */
    public function deleteAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('remove_comment_course');

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('AppBundle:CommentCourse')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find CommentCourse entity.');
        }

        $em->remove($entity);
        $em->flush();

        return $this->redirect($this->generateUrl('backend_comment'));
    }

    /**
    * Atualiza o Status do Usuários para ATIVO
    *
    * @Route("/{id}", name="backend_comment_active")
    */
    public function activateStatusAction($id)
    {
        $this->verificationUserAccessControl('disable_comment_course');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:CommentCourse')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find CommentCourse entity.');
        }

        if ($entity->getActive()) {
            $entity->setActive(false);
        } else {
            $entity->setActive(true);
        }

        $em->persist($entity);
        $em->flush();

        return $this->redirect($this->generateUrl('backend_comment', array('id' => $id)));
    }
}
