<?php

namespace AppBundle\Controller\Backend;

use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use AppBundle\Entity\Configuration;
use AppBundle\Form\ConfigurationType;

/**
 * Configuration controller.
 *
 * @Route("/backend/configuration")
 */
class ConfigurationController extends BaseController
{


    /**
     * Displays a form to edit an existing Category entity.
     *
     * @Route("/{id}/edit", name="backend_configuration_edit")
     * @Method("GET")
     * @Template()
     */
    public function editAction($id)
    {
        $this->verificationUserAccessControl('edit_configuration');

        $em = $this->getDoctrine()->getManager();

        $configuration = $em->getRepository('AppBundle:Configuration')->find($id);

        if (!$configuration) {
            throw $this->createNotFoundException('Unable to find Configuration entity.');
        }

        $editForm = $this->createEditForm($configuration);
        return array(
            'entity' => $configuration,
            'edit_form' => $editForm->createView(),
        );
    }

    /**
    * Creates a form to edit a Configuration entity.
    *
    * @param Configuration $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditForm(Configuration $entity)
    {
        $form = $this->createForm(new ConfigurationType(), $entity, array(
            'action' => $this->generateUrl('backend_configuration_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }
    
    /**
     * Edits an existing Configuration entity.
     *
     * @Route("/{id}", name="backend_configuration_update")
     * @Method("PUT")
     * @Template("AppBundle:Backend\Configuration:edit.html.twig")
     */
    public function updateAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('edit_configuration');

        $em = $this->getDoctrine()->getManager();

        $configuration = $em->getRepository('AppBundle:Configuration')->find($id);

        if (!$configuration) {
            throw $this->createNotFoundException('Unable to find Configuration entity.');
        }

        $dataRequest = $request->request->all();

        $editForm = $this->createEditForm($configuration);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            try {

                $this->successMessage($request, 'Registro editado com sucesso!');

                $em->flush();

                return $this->redirect($this->generateUrl('backend_configuration_edit', array('id' => $id)));
            } catch (\Exception $e) {
                $this->log($e);
                $this->errorMessage($request, 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $configuration,
            'edit_form' => $editForm->createView(),
        );
    }
    
}
