<?php

namespace AppBundle\Controller\Backend;

use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Client controller.
 *
 * @Route("/backend/inscription-class/matriculas")
 */
class InscriptionClassController extends BaseController
{

    /**
     * @Route("/search/{courseClassId}" , name="backend_inscription_course_class_ajax", options={"expose"=true})
     */
    public function clientCourseAjaxAction(Request $request, $courseClassId)
    {
        $get = $request->query->all();

        $em = $this->getDoctrine()->getManager();
        $courseClass = $em->getRepository('AppBundle:CourseClass')->find($courseClassId);
        $columns = array( 'id', 'user.first_name', 'client.cpf','user.last_name', 'client.mat_colaborador', 'course.name', "dtCreation");
        $get['columns'] = &$columns;

        $rResult = $em->getRepository('AppBundle:InscriptionClass')->ajaxTable($get, $courseClass);

        /* Data set length after filtering */
        $iFilteredTotal = count($rResult);

        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($get['sEcho']),
            "iTotalRecords" => $em->getRepository('AppBundle:InscriptionClass')->getCount($courseClass),
            "iTotalDisplayRecords" => $em->getRepository('AppBundle:InscriptionClass')->getCount($courseClass),
            //"iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($rResult as $indexRow => $aRow) {
            $row = array();
            //   for ( $i=0 ; $i<count($columns) ; $i++ ){
            //     if ( $columns[$i] == "version" ){
            //       /* Special output formatting for 'version' column */
            //       $row[] = ($aRow[ $columns[$i] ]=="0") ? '-' : $aRow[ $columns[$i] ];
            //     }elseif ( $columns[$i] != ' ' ){
            //       /* General output */
            //       $row[] = $aRow[ $columns[$i] ];
            //     }
            //   }
            
            $client = $em->getRepository('AppBundle:Client')->find($aRow->getUser()->getId());
            //Nome completo
            $row[0] = $aRow->getUser()->getFullName();
            // // CPF
            // $row[1] = $aRow->getUser()->getCpf();
            //Matrícula
            if ($client) {
                // CPF
                $row[1] = $aRow->getUser()->getCpf();
                $row[2] = $client->getMatColaborador();
            } else {
                // CPF
                $row[1] = "";
                $row[2] = " - ";
            }
            
            //Data de Matrícula
            $row[3] = $aRow->getDtCreation()? $aRow->getDtCreation()->format("d/m/Y") : "";

            $userId = $aRow->getUser()->getId();
            $actions = "";
            // if(!$courseClass->isEventOpened()){
                $actions .= '<a onclick="cancelInscription('.$userId.', '.$courseClassId.', '. $indexRow .')" class="btn btn-danger cancelRow'.$indexRow.'">Cancelar</a>';
            // }

            //Ações
            $row[4] = $actions;

            $output['aaData'][] = $row;
        }
        unset($rResult);

        return new Response(
            json_encode($output)
        );
    }

    /**
     * @Route("/" , name="backend_inscription")
     * @Template("AppBundle:Backend\Inscription:index.html.twig")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $entities = array();

        return array(
            'entities' => $entities,
        );
    }
}
