<?php

namespace AppBundle\Controller\Backend;

use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Client controller.
 *
 * @Route("/backend/matriculas")
 */
class InscriptionController extends BaseController
{
    /**
     * @Route("/search-presencial" , name="backend_inscription_ajax", options={"expose"=true})
     */
    public function clientAjaxAction(Request $request)
    {
        $get = $request->query->all();

        $em = $this->getDoctrine()->getManager();
        $columns = array( 'user.first_name', 'user.last_name', 'email', 'course.name');
        $get['columns'] = &$columns;

        $em = $this->getDoctrine()->getEntityManager();
        $rResult = $em->getRepository('AppBundle:Inscription')->ajaxTable($get, null, true);
        /* Data set length after filtering */
        $iFilteredTotal = count($rResult);

        /*
         * Output
         */
        $output = array(
          "sEcho" => intval($get['sEcho']),
          "iTotalRecords" => $em->getRepository('AppBundle:Inscription')->getCount(null, true),
        //   "iTotalDisplayRecords" => $em->getRepository('AppBundle:Inscription')->getCount(),
          "iTotalDisplayRecords" => $iFilteredTotal,
          "aaData" => array()
        );

        foreach ($rResult as $aRow) {
            $row = array();
            //   for ( $i=0 ; $i<count($columns) ; $i++ ){
            //     if ( $columns[$i] == "version" ){
            //       /* Special output formatting for 'version' column */
            //       $row[] = ($aRow[ $columns[$i] ]=="0") ? '-' : $aRow[ $columns[$i] ];
            //     }elseif ( $columns[$i] != ' ' ){
            //       /* General output */
            //       $row[] = $aRow[ $columns[$i] ];
            //     }
            //   }
            //Nome completo
            $row[0] = $aRow->getUser()->getFullName();
            //Email
            $row[1] = $aRow->getEmail()?$aRow->getEmail():$aRow->getUser()->getEmail();
            //Nome do Curso
            $row[2] = $aRow->getCourse()->getName();
            //Data de Matrícula
            $row[3] = $aRow->getDtCreation()? $aRow->getDtCreation()->format("d/m/Y"):"";
            //Data de Início
            // $row[3] = $aRow->getDtBegin()?$aRow->getDtBegin()->format("d/m/Y"):"";
            //Disponível até
            // $row[4] = $aRow->getDtEnd()?$aRow->getDtEnd()->format("d/m/Y"):"";
            //Tentativas
            // $row[5] = $aRow->getAttempts();
            $output['aaData'][] = $row;
        }
        unset($rResult);

        return new Response(
            json_encode($output)
        );
    }

    /**
     * @Route("/search/{courseId}" , name="backend_inscription_course_ajax", options={"expose"=true})
     */
    public function clientCourseAjaxAction(Request $request, $courseId)
    {
        $get = $request->query->all();

        $em = $this->getDoctrine()->getManager();
        $course = $em->getRepository('AppBundle:Course')->find($courseId);
        $columns = array( 'id', 'user.first_name', 'client.cpf','user.last_name', 'client.mat_colaborador', 'course.name', "dtCreation", "dtBegin", "dtEnd", "attempts");
        $get['columns'] = &$columns;

        // $rResult = $em->getRepository('AppBundle:Client')->ajaxTable($get, true)->getArrayResult();
        $rResult = $em->getRepository('AppBundle:Inscription')->ajaxTable($get, $course);

        /* Data set length after filtering */
        $iFilteredTotal = count($rResult);

        /*
         * Output
         */
        $output = array(
            "sEcho" => intval($get['sEcho']),
            "iTotalRecords" => $em->getRepository('AppBundle:Inscription')->getCount($course),
            "iTotalDisplayRecords" => $em->getRepository('AppBundle:Inscription')->getCount($course),
            //"iTotalDisplayRecords" => $iFilteredTotal,
            "aaData" => array()
        );

        foreach ($rResult as $indexRow => $aRow) {
            $row = array();
            //   for ( $i=0 ; $i<count($columns) ; $i++ ){
            //     if ( $columns[$i] == "version" ){
            //       /* Special output formatting for 'version' column */
            //       $row[] = ($aRow[ $columns[$i] ]=="0") ? '-' : $aRow[ $columns[$i] ];
            //     }elseif ( $columns[$i] != ' ' ){
            //       /* General output */
            //       $row[] = $aRow[ $columns[$i] ];
            //     }
            //   }
            
            $client = $em->getRepository('AppBundle:Client')->find($aRow->getUser()->getId());
            //Nome completo
            $row[0] = $aRow->getUser()->getFullName();
            // // CPF
            // $row[1] = $aRow->getUser()->getCpf();
            //Matrícula
            if ($client) {
                // CPF
                $row[1] = $aRow->getUser()->getCpf();
                $row[2] = $client->getMatColaborador();
            } else {
                // CPF
                $row[1] = "";
                $row[2] = " - ";
            }
            
            //Data de Matrícula
            $row[3] = $aRow->getDtCreation()? $aRow->getDtCreation()->format("d/m/Y") : "";
            //Data de Início
            $row[4] = $aRow->getDtBegin()? $aRow->getDtBegin()->format("d/m/Y") : "";
            //Disponível até
            $row[5] = $aRow->getDtEnd()? $aRow->getDtEnd()->format("d/m/Y") : "";
            //Tentativas
            $row[6] = $aRow->getAttempts();

            $statusInscription = $aRow->getInscriptionStatus() ? $aRow->getInscriptionStatus()->getName() : '' ;
            $userId = $aRow->getUser()->getId();

            $attempts = '<a onclick="alterAttempts('.$aRow->getId().',\'all\');" class="btn btn-success alter_quant">Tentativas para prova</a>';
            if ($statusInscription and $statusInscription == 'Aprovado') {
                $attempts .= '<a onclick="cancelInscription('.$userId.', '.$courseId.', '. $indexRow .')" class="btn btn-danger cancelRow'.$indexRow.'">Cancelar e Rematricular</a>';
            }

            /**
             * Não mudar o indíce do row[6] Status
             * Caso deseja acrescentar item, acrescente depois do índice 6
            */
            if ($statusInscription) {
                // Status
                $row[7] = $statusInscription == 'Aprovado' ? 'Ativo' : 'Cancelado';
            } else {
                // Status
                $row[7] = '';
            }


            //Ações
            $row[8] = $attempts;

            $output['aaData'][] = $row;
        }
        unset($rResult);

        return new Response(
            json_encode($output)
        );
    }

    /**
     * @Route("/" , name="backend_inscription")
     * @Template("AppBundle:Backend\Inscription:index.html.twig")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $entities = array();

        return array(
            'entities' => $entities,
        );
    }
}
