<?php

namespace AppBundle\Controller\Backend;

use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use AppBundle\Entity\IqaCicle;
use AppBundle\Entity\IqaMidia;
use AppBundle\Form\IqaCicleType;

/**
 * Iqa Cicle controller.
 *
 * @Route("/backend/iqa-cicle")
 */
class IqaCicleController extends BaseController
{
    /**
     * @Route("/" , name="backend_iqa_cicle")
     * @Template("AppBundle:Backend\IqaCicle:index.html.twig")
     */
    public function indexAction()
    {
        $this->verificationUserAccessControl('index_iqa_cicle');
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('AppBundle:IqaCicle')->findAll();

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $entities,
            $this->get('request')->query->get('page', 1),
            12
        );

        return array(
            'entities' => $entities,
        );
    }

    /**
     * Creates a new IqaCicle entity.
     *
     * @Route("/create", name="backend_iqa_cicle_create")
     * @Method("POST")
     * @Template("AppBundle:Backend\IqaCicle:new.html.twig")
     */
    public function createAction(Request $request)
    {
        $this->verificationUserAccessControl('new_iqa_cicle');

        $entity = new IqaCicle();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        $dataRequest = $request->request->all();
        if ($form->isValid()) {
            try {
                $em = $this->getDoctrine()->getManager();

                foreach ($entity->getIqamidias() as $iqaMidia) {
                    $this->log("!!!");
                    $this->log($iqaMidia->getMidiaTypeTemp());
                    $this->log(json_encode($iqaMidia));
                    if($iqaMidia->getMidiaTypeTemp()=="Curso"){
                        $course = $em->getRepository('AppBundle:Course')->find($iqaMidia->getMidiaIdTemp());
                        $iqaMidia->setMediaName( ($course->getTitle()? $course->getTitle() : $course->getName() ) );
                        $iqaMidia->setMediaType($em->getReference('AppBundle:MediaType', 1));
                        $iqaMidia->setCourseId($course->getId());
                        $iqaMidia->setPlataform('LMS');
                    }else{
                        $svMedia = $this->getIqaCicleMediacenterRepository()->getMediaFromMediaCenter($iqaMidia->getMidiaIdTemp());
                        if ($svMedia) {
                            $mediaType = $svMedia['type'] == "VIDEO" ? $em->getReference('AppBundle:MediaType', 2) : $em->getReference('AppBundle:MediaType', 3);
                            $iqaMidia->setMediaName($svMedia['title']);
                            $iqaMidia->setMediaType($mediaType);
                            $iqaMidia->setMediaId($iqaMidia->getMidiaIdTemp());
                            $iqaMidia->setPlataform('Media Center');
                        }
                    }
                }

                $em->persist($entity);
                $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro criado com sucesso!');

                return $this->redirect($this->generateUrl('backend_iqa_cicle', array('id' => $entity->getId())));
            } catch (\Exception $e) {
                $this->log("IQA CICLE - CREATE");
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        $courses = $em->getRepository('AppBundle:Course')->getActives(true);
        $svMedias = $this->getIqaCicleMediacenterRepository()->findAvailableFromMediaCenter();

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
            'courses' => $courses,
            'svMedias' => $svMedias,
            'selected_ids_lms' => $selected_ids_lms,
            'selected_ids_mediacenter' => $selected_ids_mediacenter
        );
    }

    /**
     * Creates a form to create a IqaCicle entity.
     *
     * @param IqaCicle $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(IqaCicle $entity)
    {
        $form = $this->createForm(new IqaCicleType(), $entity, array(
            'action' => $this->generateUrl('backend_iqa_cicle_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
     * Displays a form to create a new IqaCicle entity.
     *
     * @Route("/new", name="backend_iqa_cicle_new")
     * @Method("GET")
     * @Template()
     */
    public function newAction()
    {
        $this->verificationUserAccessControl('new_iqa_cicle');
        $em = $this->getDoctrine()->getManager();

        $entity = new IqaCicle();
        $form = $this->createCreateForm($entity);
        
        $courses = $em->getRepository('AppBundle:Course')->getActives(true);
        $svMedias = $this->getIqaCicleMediacenterRepository()->findAvailableFromMediaCenter();

        return array(
            'entity' => $entity,
            'courses' => $courses,
            'svMedias' => $svMedias,
            'form' => $form->createView(),
        );
    }

    /**
     * Displays a form to edit an existing IqaCicle entity.
     *
     * @Route("/{id}/edit", name="backend_iqa_cicle_edit")
     * @Method("GET")
     * @Template()
     */
    public function editAction($id)
    {
        $this->verificationUserAccessControl('edit_iqa_cicle');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:IqaCicle')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find IqaCicle entity.');
        }

        $courses = $em->getRepository('AppBundle:Course')->getActives(true);
        $svMedias = $this->getIqaCicleMediacenterRepository()->findAvailableFromMediaCenter();
        foreach ($entity->getIqamidias() as $iqamidia) {
            $iqamidia->setMidiaIdTemp($iqamidia->getCourseId() ? $iqamidia->getCourseId() : $iqamidia->getMediaId() );
            $iqamidia->setMidiaTypeTemp($iqamidia->getMediaType()->getName());
        }
        $editForm = $this->createEditForm($entity);
        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
            'courses' => $courses,
            'svMedias' => $svMedias,

        );
    }

    /**
    * Creates a form to edit a IqaCicle entity.
    *
    * @param IqaCicle $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditForm(IqaCicle $entity)
    {
        $form = $this->createForm(new IqaCicleType(), $entity, array(
            'action' => $this->generateUrl('backend_iqa_cicle_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }
    /**
     * Edits an existing IqaCicle entity.
     *
     * @Route("/{id}", name="backend_iqa_cicle_update")
     * @Method("PUT")
     * @Template("AppBundle:Backend\IqaCicle:edit.html.twig")
     */
    public function updateAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('edit_iqa_cicle');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:IqaCicle')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find IqaCicle entity.');
        }

        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        $dataRequest = $request->request->all();

        if ($editForm->isValid()) {
            try {

                foreach ($entity->getIqamidias() as $iqaMidia) {
                    if($iqaMidia->getMidiaTypeTemp()=="Curso"){
                        $course = $em->getRepository('AppBundle:Course')->find($iqaMidia->getMidiaIdTemp());
                        $iqaMidia->setMediaName( ($course->getTitle()? $course->getTitle() : $course->getName() ) );
                        $iqaMidia->setMediaType($em->getReference('AppBundle:MediaType', 1));
                        $iqaMidia->setCourseId($course->getId());
                        $iqaMidia->setPlataform('LMS');
                    }else{
                        $svMedia = $this->getIqaCicleMediacenterRepository()->getMediaFromMediaCenter($iqaMidia->getMidiaIdTemp());
                        if ($svMedia) {
                            $mediaType = $svMedia['type'] == "VIDEO" ? $em->getReference('AppBundle:MediaType', 2) : $em->getReference('AppBundle:MediaType', 3);
                            $iqaMidia->setMediaName($svMedia['title']);
                            $iqaMidia->setMediaType($mediaType);
                            $iqaMidia->setMediaId($iqaMidia->getMidiaIdTemp());
                            $iqaMidia->setPlataform('Media Center');
                        }
                    }
                }
                
                $em->flush();

                // $iqaMidias = $em->getRepository('AppBundle:IqaMidia')->findBy(array(
                //     'iqaCicle' => $id,
                // ));

                // foreach ($iqaMidias as $item) {
                //     $em->remove($item);
                // }

                // if (array_key_exists("lms_ids", $dataRequest)) {
                //     foreach($dataRequest['lms_ids'] as $id){
                //         $course = $em->getRepository('AppBundle:Course')->find($id);
                //         $iqaMidia = new IqaMidia();
                //         $iqaMidia->setIqaCicle($entity);
                //         $iqaMidia->setMediaName( ($course->getTitle()? $course->getTitle() : $course->getName() ) );
                //         $iqaMidia->setMediaType($em->getReference('AppBundle:MediaType', 1));
                //         $iqaMidia->setCourseId($course->getId());
                //         $iqaMidia->setPlataform('LMS');
                //         $em->persist($iqaMidia);
                //     }
                // }

                // if (array_key_exists("mediacenter_ids", $dataRequest)) { 
                //     foreach($dataRequest['mediacenter_ids'] as $id){
                //         $svMedia = $this->getIqaCicleMediacenterRepository()->getMediaFromMediaCenter($id);
                //         if ($svMedia) {
                //             $mediaType = $svMedia['type'] == "VIDEO" ? $em->getReference('AppBundle:MediaType', 2) : $em->getReference('AppBundle:MediaType', 3);
                //             $iqaMidia = new IqaMidia();
                //             $iqaMidia->setIqaCicle($entity);
                //             $iqaMidia->setMediaName($svMedia['title']);
                //             $iqaMidia->setMediaType($mediaType);
                //             $iqaMidia->setMediaId($id);
                //             $iqaMidia->setPlataform('Media Center');
                //             $em->persist($iqaMidia);
                //         }
                //     }
                // }
                // $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro atualizado com sucesso!');

                return $this->redirect($this->generateUrl('backend_iqa_cicle', array('id' => $id)));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        $courses = $em->getRepository('AppBundle:Course')->getActives(true);
        $svMedias = $this->getIqaCicleMediacenterRepository()->findAvailableFromMediaCenter();

        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
            'courses' => $courses,
            'svMedias' => $svMedias,
        );
    }
    /**
     * Deletes a IqaCicle entity.
     *
     * @Route("/{id}/delete", name="backend_iqa_cicle_delete")
     */
    public function deleteAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('remove_iqa_cicle');

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('AppBundle:IqaCicle')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find IqaCicle entity.');
        }

        $em->remove($entity);
        $em->flush();
        $request->getSession()
            ->getFlashBag()
            ->add('success', 'Registro excluído com sucesso!');
        return $this->redirect($this->generateUrl('backend_iqa_cicle'));
    }

    /**
     * Find IqaCicle (Ajax)
     * @Route("/iqa-cicle/find" , name="backend_iqa_cicle_find", options={"expose"=true})
     */
    public function iqaCicleFindAction(Request $request)
    {
        $dataRequest = $this->getParametersRequestAjax($request);
        $result = $this->getIqaCicleRepository()->findForSearch($dataRequest['find'], true);

        return new JsonResponse($result);
    }
}
