<?php

namespace AppBundle\Controller\Backend;

use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use AppBundle\Entity\LearningTrail;
use AppBundle\Entity\LearningTrailFilter;
use AppBundle\Form\LearningTrailType;

/**
 * LearningTrail controller.
 *
 * @Route("/backend/learning-trail")
 */
class LearningTrailController extends BaseController
{
    /**
     * @Route("/" , name="backend_learningtrail")
     * @Template("AppBundle:Backend\LearningTrail:index.html.twig")
     */
    public function indexAction()
    {
        $this->verificationUserAccessControl('index_learning_trail');
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('AppBundle:LearningTrail')->findAll();

        return array(
            'entities' => $entities,
        );
    }

    /**
     * Creates a new LearningTrail entity.
     *
     * @Route("/create", name="backend_learningtrail_create")
     * @Method("POST")
     * @Template("AppBundle:Backend\LearningTrail:new.html.twig")
     */
    public function createAction(Request $request)
    {
        $this->verificationUserAccessControl('new_learning_trail');

        $entity = new LearningTrail();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        $dataRequest = $request->request->all();
        if ($form->isValid()) {
            try {
                $em = $this->getDoctrine()->getManager();

                $this->handleFilterCustom($entity, $dataRequest);

                $em->persist($entity);
                $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro criado com sucesso!');

                return $this->redirect($this->generateUrl('backend_learningtrail', array('id' => $entity->getId())));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Creates a form to create a LearningTrail entity.
     *
     * @param LearningTrail $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(LearningTrail $entity)
    {
        $form = $this->createForm(new LearningTrailType(), $entity, array(
            'action' => $this->generateUrl('backend_learningtrail_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
     * Displays a form to create a new LearningTrail entity.
     *
     * @Route("/new", name="backend_learningtrail_new")
     * @Method("GET")
     * @Template()
     */
    public function newAction()
    {
        $this->verificationUserAccessControl('new_learning_trail');

        $em = $this->getDoctrine()->getManager();
        $learningTrail = new LearningTrail();
        $form = $this->createCreateForm($learningTrail);

        $learningTrailFilter = $em->getRepository('AppBundle:LearningTrailFilter')->findOneByLearningTrail($learningTrail);

        return array(
            'entity' => $learningTrail,
            'form' => $form->createView(),
            'learning_trail_filter' => $learningTrailFilter
        );
    }

    /**
     * Displays a form to edit an existing LearningTrail entity.
     *
     * @Route("/{id}/edit", name="backend_learningtrail_edit")
     * @Method("GET")
     * @Template()
     */
    public function editAction($id)
    {
        $this->verificationUserAccessControl('edit_learning_trail');

        $em = $this->getDoctrine()->getManager();

        $learningTrailEntity = $em->getRepository('AppBundle:LearningTrail')->find($id);

        if (!$learningTrailEntity) {
            throw $this->createNotFoundException('Unable to find LearningTrail entity.');
        }

        $learningTrailFilter = $em->getRepository('AppBundle:LearningTrailFilter')->findOneByLearningTrail($learningTrailEntity);

        $dataCoursesEntity = $this->getDataCoursesEntity($learningTrailEntity);

        $editForm = $this->createEditForm($learningTrailEntity);
        return array(
            'entity' => $learningTrailEntity,
            'edit_form' => $editForm->createView(),
            'data_courses_entity' => $dataCoursesEntity,
            'learning_trail_filter' => $learningTrailFilter
        );
    }

    private function getCourseDataEntity($id)
    {
        $em = $this->getDoctrine()->getManager();
        $courseEntity = $em->getRepository('AppBundle:Course')->find($id);
        $dataCourse = array(
            'id' => $courseEntity->getId(),
            'name' => $courseEntity->getName(),
        );

        return $dataCourse;
    }

    private function fethChildrenData($dataFech)
    {
        $result = array();
        foreach ($dataFech as $data) {
            $dataCourse = $this->getCourseDataEntity($data['id']);
            if (is_array($data) && array_key_exists('children', $data)) {
                $dataCourse['children'] = $this->fethChildrenData($data['children']);
            }
            array_push($result, $dataCourse);
        }

        return $result;
    }

    private function getDataCoursesEntity($learningTrail)
    {
        $dataCoursesEntity = array();
        $coursesId = json_decode($learningTrail->getCourses(), true);

        foreach ($coursesId as $courseData) {
            $courseId = (is_array($courseData)) ? $courseData['id'] : $courseData;
            $dataCourse = $this->getCourseDataEntity($courseId);

            if (is_array($courseData) && array_key_exists('children', $courseData)) {
                $dataCourse['children'] = $this->fethChildrenData($courseData['children']);
            }
            array_push($dataCoursesEntity, $dataCourse);
        }

        return $dataCoursesEntity;
    }

    private function output($menu)
    {
        //Store all of the ID's in an array
        $ids = array();
        //Start the loop through the menu array
        foreach ($menu as $parentHolder) {
            foreach ($parentHolder as $parentKey => $parent) {
                //Checks to see when this jumps into the children array
                if (!is_array($parent)) {
                    //Only run on the content key
                    if ($parentKey == "id") {
                        if ($parent) {
                            $ids[] = $parent;
                        } //Only to array if not empty
                    } //end check for content as key for the parents
                } else {
                    //This is an array, which means this parent has children
                    $this->output($parent);
                } //Check if key is = content
            } //end Parent loop
        } //end the main loop
        //Store all of the ID's in an array
        return $ids;
    }

    /**
    * Creates a form to edit a LearningTrail entity.
    *
    * @param LearningTrail $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditForm(LearningTrail $entity)
    {
        $form = $this->createForm(new LearningTrailType(), $entity, array(
            'action' => $this->generateUrl('backend_learningtrail_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }
    /**
     * Edits an existing LearningTrail entity.
     *
     * @Route("/{id}", name="backend_learningtrail_update")
     * @Method("PUT")
     * @Template("AppBundle:Backend\LearningTrail:edit.html.twig")
     */
    public function updateAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('edit_learning_trail');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:LearningTrail')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find LearningTrail entity.');
        }

        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        $dataRequest = $request->request->all();

        if ($editForm->isValid()) {
            try {
                $this->handleFilterCustom($entity, $dataRequest);
                $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro atualizado com sucesso!');

                return $this->redirect($this->generateUrl('backend_learningtrail', array('id' => $id)));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }
    /**
     * Deletes a LearningTrail entity.
     *
     * @Route("/{id}/delete", name="backend_learningtrail_delete")
     *
     */
    public function deleteAction(Request $request, $id)
    {
        try {
            $this->verificationUserAccessControl('remove_learning_trail');

            $em = $this->getDoctrine()->getManager();
            $entity = $em->getRepository('AppBundle:LearningTrail')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find LearningTrail entity.');
            }

            $em->remove($entity);
            $em->flush();

            $this->successMessage($request, 'Registro excluído com sucesso!');

            return $this->redirect($this->generateUrl('backend_learningtrail'));
        } catch (Exception $e) {
            $this->log($e);
            $this->errorMessage($request, 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
        }
    }

    public function handleFilterCustom($learningTrail, $dataRequest)
    {
        try {
            $sectors = $dataRequest['sector'] ? explode('||', $dataRequest['sector']) : null;
            $jobRoles = $dataRequest['job_role'] ? explode('||', $dataRequest['job_role']) : null;
            $managements = $dataRequest['management'] ? explode('||', $dataRequest['management']) : null;

            $em = $this->getDoctrine()->getManager();
            $learningTrailFilter = $em->getRepository('AppBundle:LearningTrailFilter')->findOneByLearningTrail($learningTrail);

            if (!$learningTrailFilter) {
                $learningTrailFilter = new LearningTrailFilter();
                $learningTrailFilter->setLearningTrail($learningTrail);
            }

            // De vês em enquando dá um erro que não grava os campos sector, job_roles e management
            // Por último falta fazer a verificação la no HomeController

            $learningTrailFilter->setSectors(json_encode($sectors));
            $learningTrailFilter->setJobRoles(json_encode($jobRoles));
            $learningTrailFilter->setManagements(json_encode($managements));

            $em->persist($learningTrailFilter);
        } catch (Exception $e) {
            $this->log($e);
        }
    }
}
