<?php

namespace  AppBundle\Controller\Backend;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use AppBundle\Entity\LessonFiles;
use AppBundle\Form\LessonFilesType;
use AppBundle\Controller\BaseController;

/**
 * LessonFiles controller.
 *
 * @Route("/backend/lessonfiles")
 */
class LessonFilesController extends BaseController
{
    /**
     * Lists all LessonFiles entities.
     *
     * @Route("/{lesson}", name="backend_lessonfiles_index")
     * @Method("GET")
     */
    public function indexAction($lesson)
    {
        $this->verificationUserAccessControl("index_lessonfiles");

        $em = $this->getDoctrine()->getManager();
        $lesson = $em->getRepository('AppBundle:Lesson')->find($lesson);

        $lessonFiles = $em->getRepository("AppBundle:LessonFiles")->findBy(['lesson' => $lesson], ['dtCreate' => 'ASC']);

        return $this->render('AppBundle:Backend\LessonFiles:index.html.twig', array(
            'lessonFiles' => $lessonFiles,
            'lesson' => $lesson
        ));
    }

    /**
     * Creates a new LessonFiles entity.
     *
     * @Route("/new/{lesson}", name="backend_lessonfiles_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request, $lesson)
    {
        $this->verificationUserAccessControl("new_lessonfiles");

        $lessonFile = new LessonFiles();
        $form = $this->createForm('AppBundle\Form\LessonFilesType', $lessonFile);
        $form->handleRequest($request);
        $em = $this->getDoctrine()->getManager();

        $lesson = $em->getRepository('AppBundle:Lesson')->find($lesson);

        if ($form->isSubmitted() && $form->isValid()) {
            $lessonFile->setLesson($lesson);
            $em->persist($lessonFile);
            $em->flush();

            $request->getSession()
                 ->getFlashBag()
                 ->add('success', 'Registro atualizado com sucesso!');

            return $this->redirectToRoute('backend_lessonfiles_index', array('lesson' => $lesson->getId()));
        }

        return $this->render('AppBundle:Backend\LessonFiles:new.html.twig', array(
            'lessonFile' => $lessonFile,
            'lesson' => $lesson,
            'form' => $form->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing LessonFiles entity.
     *
     * @Route("/{id}/edit", name="backend_lessonfiles_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, LessonFiles $lessonFile)
    {
        $this->verificationUserAccessControl("edit_lessonfiles");

        $deleteForm = $this->createDeleteForm($lessonFile);
        $editForm = $this->createForm('AppBundle\Form\LessonFilesType', $lessonFile);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($lessonFile);
            $em->flush();

            return $this->redirectToRoute('backend_lessonfiles_edit', array('id' => $lessonFile->getId()));
        }

        return $this->render('AppBundle:Backend\LessonFiles:edit.html.twig', array(
            'lessonFile' => $lessonFile,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a LessonFiles entity.
     *
     * @Route("/{id}/delete", name="backend_lessonfiles_delete")
     */
    public function deleteAction(Request $request, $id)
    {
        $this->verificationUserAccessControl("remove_lessonfiles");

        $em = $this->getDoctrine()->getManager();
        $lessonFile = $em->getRepository('AppBundle:LessonFiles')->find($id);

        if (!$lessonFile) {
            throw $this->createNotFoundException('Arquivo inválido.');
        }

        $lesson = $lessonFile->getLesson();

        try{
          $em->remove($lessonFile);
          $lessonFile->unlinkImages();
          $em->flush();
          $request->getSession()
               ->getFlashBag()
               ->add('success', 'Registro excluído com sucesso!');
        }catch(\Exception $e){
            $this->log($e);
            $request->getSession()
            ->getFlashBag()
            ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
        }

        return $this->redirect($this->generateUrl('backend_lessonfiles_index', array('lesson' => $lesson->getId())));
    }

    /**
     * Creates a form to delete a LessonFiles entity.
     *
     * @param LessonFiles $lessonFile The LessonFiles entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(LessonFiles $lessonFile)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('backend_lessonfiles_delete', array('id' => $lessonFile->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
