<?php

namespace AppBundle\Controller\Backend;

use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use AppBundle\Entity\Management;
use AppBundle\Form\ManagementType;

/**
 * Management controller.
 *
 * @Route("/backend/management")
 */
class ManagementController extends BaseController
{
    /**
     * @Route("/" , name="backend_management")
     * @Template("AppBundle:Backend\Management:index.html.twig")
     */
    public function indexAction()
    {
        $this->verificationUserAccessControl('index_management');
        $em = $this->getDoctrine()->getManager();
        

        $entities = $em->getRepository('AppBundle:Management')->findAll();

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $entities,
            $this->get('request')->query->get('page', 1),
            12
        );

        return array(
            'entities' => $entities,
        );
    }

    /**
     * Creates a new Management entity.
     *
     * @Route("/create", name="backend_management_create")
     * @Method("POST")
     * @Template("AppBundle:Backend\Management:new.html.twig")
     */
    public function createAction(Request $request)
    {
        $this->verificationUserAccessControl('new_management');

        $entity = new Management();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);
        if ($form->isValid()) {
            try {
                $em = $this->getDoctrine()->getManager();

                $em->persist($entity);
                $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro criado com sucesso!');

                return $this->redirect($this->generateUrl('backend_management', array('id' => $entity->getId())));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Creates a form to create a Management entity.
     *
     * @param Management $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Management $entity)
    {
        $form = $this->createForm(new ManagementType(), $entity, array(
            'action' => $this->generateUrl('backend_management_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
     * Displays a form to create a new Management entity.
     *
     * @Route("/new", name="backend_management_new")
     * @Method("GET")
     * @Template()
     */
    public function newAction()
    {
        $this->verificationUserAccessControl('new_management');

        $entity = new Management();
        $form = $this->createCreateForm($entity);

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Displays a form to edit an existing Management entity.
     *
     * @Route("/{id}/edit", name="backend_management_edit")
     * @Method("GET")
     * @Template()
     */
    public function editAction($id)
    {
        $this->verificationUserAccessControl('edit_management');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:Management')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Management entity.');
        }

        $editForm = $this->createEditForm($entity);
        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }

    /**
    * Creates a form to edit a Management entity.
    *
    * @param Management $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditForm(Management $entity)
    {
        $form = $this->createForm(new ManagementType(), $entity, array(
            'action' => $this->generateUrl('backend_management_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }
    /**
     * Edits an existing Management entity.
     *
     * @Route("/{id}", name="backend_management_update")
     * @Method("PUT")
     * @Template("AppBundle:Backend\Management:edit.html.twig")
     */
    public function updateAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('edit_management');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:Management')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Management entity.');
        }

        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            try {
                $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro atualizado com sucesso!');

                return $this->redirect($this->generateUrl('backend_management', array('id' => $id)));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }
    /**
     * Deletes a Management entity.
     *
     * @Route("/{id}/delete", name="backend_management_delete")
     *
     */
    public function deleteAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('remove_management');

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('AppBundle:Management')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Management entity.');
        }

        $em->remove($entity);
        $em->flush();

        $request->getSession()
            ->getFlashBag()
            ->add('success', 'Registro excluído com sucesso!');

        return $this->redirect($this->generateUrl('backend_management'));
    }

    /**
     * Find Management (Ajax)
     * @Route("/management/find" , name="backend_management_find", options={"expose"=true})
     */
    public function managementFindAction(Request $request)
    {
        $dataRequest = $this->getParametersRequestAjax($request);
        $result = $this->getManagementRepository()->findForSearch($dataRequest['find'], true);

        return new JsonResponse($result);
    }
}
