<?php

namespace AppBundle\Controller\Backend;

use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Entity\ParticipantStatus;

/**
 * Client controller.
 *
 * @Route("/backend/participantes")
 */
class ParticipantController extends BaseController
{
    /**
     * @Route("/search-presencial", name="backend_participant_ajax", options={"expose"=true})
     */
    public function clientAjaxAction(Request $request)
    {
        $get = $request->query->all();

        $em = $this->getDoctrine()->getManager();
        $columns = array( 'user.first_name', 'user.last_name', 'client.mat_colaborador', 'client.num_enterprise','email', 'course.name', 'participant_status.name');
        $get['columns'] = &$columns;

        $em = $this->getDoctrine()->getEntityManager();
        $rResult = $em->getRepository('AppBundle:Participant')->ajaxTable($get, null, true);
        $countResults = $em->getRepository('AppBundle:Participant')->ajaxTable($get, null, true, true);
        /* Data set length after filtering */
        $iFilteredTotal = count($countResults);

        /*
         * Output
         */
        $output = array(
          "sEcho" => intval($get['sEcho']),
          "iTotalRecords" => $em->getRepository('AppBundle:Participant')->getCount(null, true),
        //   "iTotalDisplayRecords" => $em->getRepository('AppBundle:Inscription')->getCount(),
          "iTotalDisplayRecords" => $iFilteredTotal,
          "aaData" => array()
        );

        foreach ($rResult as $aRow) {
            $row = array();
            //   for ( $i=0 ; $i<count($columns) ; $i++ ){
            //     if ( $columns[$i] == "version" ){
            //       /* Special output formatting for 'version' column */
            //       $row[] = ($aRow[ $columns[$i] ]=="0") ? '-' : $aRow[ $columns[$i] ];
            //     }elseif ( $columns[$i] != ' ' ){
            //       /* General output */
            //       $row[] = $aRow[ $columns[$i] ];
            //     }
            //   }
            $client = $em->getReference('AppBundle:Client', $aRow->getUser()->getId());
            //Nome completo
            $row[0] = $aRow->getUser()->getFullName();
            //Matrícula
            $row[1] = $client ? $client->getMatColaborador():"";
            //Empresa
            $row[2] = $client ? $client->getNumEnterprise():"";
            //Email
            $row[3] = $aRow->getEmail()?$aRow->getEmail():$aRow->getUser()->getEmail();
            //Nome do Curso
            $row[4] = $aRow->getCourse()->getName();
            //Data de Matrícula
            $row[5] = $aRow->getDtCreation()? $aRow->getDtCreation()->format("d/m/Y"):"";
            //Status
            $row[6] = $aRow->getParticipantStatus()? $aRow->getParticipantStatus()->getName():"";
            //Acoes
            $row[7] = "";
            if ($aRow->getParticipantStatus()->getId() == ParticipantStatus::INSCRITO) {
                $row[5] = "<a href='javascript:confirmParticipant(".$aRow->getId().");' class='confirm-participant' data-participantid='".$aRow->getId()."'>Matricular</a>";
            }

            $output['aaData'][] = $row;
        }
        unset($rResult);

        return new Response(
            json_encode($output)
        );
    }

    /**
     * @Route("/confirm-participant" , name="backend_participant_confirm_ajax", options={"expose"=true})
     */
    public function participantConfirmAction()
    {
        try {
            $em = $this->getDoctrine()->getManager();
            $request = Request::createFromGlobals();
            $participant_id = $request->query->get('participant_id');
            $user = $this->getUser();
            $participant = $this->getParticipantRepository()->find($participant_id);

            if (!$participant) {
                $return = array("responseCode" => 400);
                return $this->returnJson($return);
            }
            $participantStatusMatriculado = $em->getReference('AppBundle:ParticipantStatus', ParticipantStatus::MATRICULADO);
            $participant->setParticipantStatus($participantStatusMatriculado);
            $em->persist($participant);
            $em->flush();
            $return = array("responseCode" => 200);
            return $this->returnJson($return);
        } catch (Exception $e) {
            $return = array("responseCode" => 400);
            return $this->returnJson($return);
        }
    }

    /**
     * @Route("/" , name="backend_participant")
     * @Template("AppBundle:Backend\Participant:index.html.twig")
     */
    public function indexAction()
    {
        $this->verificationUserAccessControl('index_participante');
        $em = $this->getDoctrine()->getManager();

        $entities = array();

        return array(
            'entities' => $entities,
        );
    }
}
