<?php

namespace AppBundle\Controller\Backend;

use Symfony\Component\HttpFoundation\Request;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\RedirectResponse;
use AppBundle\Form\PostType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use AppBundle\Entity\Post;
use AppBundle\Entity\LikePost;
use AppBundle\Entity\CommentPost;
use AppBundle\Form\CommentPostType;

/**
 * @Route("backend/noticias")
 */
class PostController extends BaseController
{

    /**
     * @Route("/" , name="backend_post")
     * @Template("AppBundle:Backend\Post:index.html.twig")
     */
    public function indexAction()
    {
        $this->verificationUserAccessControl('index_post');
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('AppBundle:Post')->findAll();

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $entities,
            $this->get('request')->query->get('page', 1),
            12
        );

        return array(
            'entities' => $entities,
        );
    }

    /**
     * Creates a new Post entity.
     *
     * @Route("/create", name="backend_post_create")
     * @Method("POST")
     * @Template("AppBundle:Backend\Post:new.html.twig")
     */
    public function createAction(Request $request)
    {
        $this->verificationUserAccessControl('new_post');

        $entity = new Post();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);
        if ($form->isValid()) {


            try {
                $em = $this->getDoctrine()->getManager();

                $em->persist($entity);
                $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro criado com sucesso!');

                return $this->redirect($this->generateUrl('backend_post', array('id' => $entity->getId())));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Creates a form to create a Post entity.
     *
     * @param Post $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Post $entity)
    {
        $form = $this->createForm(new PostType(), $entity, array(
            'action' => $this->generateUrl('backend_post_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
     * Displays a form to create a new Post entity.
     *
     * @Route("/new", name="backend_post_new")
     * @Method("GET")
     * @Template()
     */
    public function newAction()
    {
        $this->verificationUserAccessControl('new_post');

        $entity = new Post();
        $form = $this->createCreateForm($entity);

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Displays a form to edit an existing Post entity.
     *
     * @Route("/{id}/edit", name="backend_post_edit")
     * @Method("GET")
     * @Template()
     */
    public function editAction($id)
    {
        $this->verificationUserAccessControl('edit_post');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:Post')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Post entity.');
        }

        $editForm = $this->createEditForm($entity);
        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }

    /**
    * Creates a form to edit a Post entity.
    *
    * @param Post $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditForm(Post $entity)
    {
        $form = $this->createForm(new PostType(), $entity, array(
            'action' => $this->generateUrl('backend_post_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }
    /**
     * Edits an existing Post entity.
     *
     * @Route("/{id}", name="backend_post_update")
     * @Method("PUT")
     * @Template("AppBundle:Backend\Post:edit.html.twig")
     */
    public function updateAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('edit_post');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:Post')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Post entity.');
        }

        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            try {
                $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro atualizado com sucesso!');

                return $this->redirect($this->generateUrl('backend_post', array('id' => $id)));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }
    /**
     * Deletes a Post entity.
     *
     * @Route("/{id}/delete", name="backend_post_delete")
     *
     */
    public function deleteAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('remove_post');

        if ($this->get('security.authorization_checker')->isGranted('ROLE_SUPER_ADMIN')) {
            $this->verificationUserAccessControl('remove_post');
            $em = $this->getDoctrine()->getManager();
            $entity = $em->getRepository('AppBundle:Post')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Post entity.');
            }

            $em->remove($entity);
            $em->flush();

            $request->getSession()
             ->getFlashBag()
             ->add('success', 'Registro excluído com sucesso!');

            return $this->redirect($this->generateUrl('backend_post'));
        } else {
            throw $this->createNotFoundException('Você não tem permissão para acessar esta tela.');
        }
    }

    /**
     * Deletes a Post entity.
     *
     * @Route("/{id}/active", name="backend_post_active")
     *
     */
    public function activeAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('remove_post');

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('AppBundle:Post')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Banner entity.');
        }

        if ($entity->getActive() == true) {
            $entity->setActive(false);
        } else {
            $entity->setActive(true);
        }
        $em->flush();

        return $this->redirect($this->generateUrl('backend_post_index'));
    }
}
