<?php

namespace AppBundle\Controller\Backend;

use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use AppBundle\Controller\BaseController;
use AppBundle\Entity\SearchReport;
use AppBundle\Form\SearchReportType;

/**
 * Report controller.
 *
 * @Route("/backend/report")
 */
class ReportController extends BaseController
{

   /**
    * @Route("/inscriptions" , name="backend_report_inscriptions")
    */
    public function inscriptionsAction(Request $request)
    {
        $searchReport = new SearchReport();
        $form = $this->createForm(new SearchReportType(), $searchReport);
        $form->handleRequest($request);

        if ($request->getMethod() == 'POST') {
            $inscriptions = $this->getInscriptionRepository()->findForReport($searchReport);
        } else {
            $inscriptions = array();
        }

        return $this->render('AppBundle:Backend\Report:inscriptions.html.twig', array(
            'inscriptions' => $inscriptions,
            'form'=> $form->createView()
        ));
    }

    /**
     * @Route("/payments" , name="backend_report_payments")
     */
    public function paymentsAction(Request $request)
    {
        $searchReport = new SearchReport();
        $form = $this->createForm(new SearchReportType(), $searchReport);
        $form->handleRequest($request);

        if ($request->getMethod() == 'POST') {
            $payments = $this->getPaymentRepository()->findForReport($searchReport);
        } else {
            $payments = array();
        }

        return $this->render('AppBundle:Backend\Report:payments.html.twig', array(
        'payments' => $payments,
        'form'=> $form->createView()
      ));
    }
}
