<?php

namespace AppBundle\Controller\Backend;

use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use AppBundle\Entity\Sector;
use AppBundle\Form\SectorType;

/**
 * Sector controller.
 *
 * @Route("/backend/sector")
 */
class SectorController extends BaseController
{
    /**
     * @Route("/" , name="backend_sector")
     * @Template("AppBundle:Backend\Sector:index.html.twig")
     */
    public function indexAction()
    {
        $this->verificationUserAccessControl('index_sector');
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('AppBundle:Sector')->findAll();

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $entities,
            $this->get('request')->query->get('page', 1),
            12
        );

        return array(
            'entities' => $entities,
        );
    }

    /**
     * Creates a new Sector entity.
     *
     * @Route("/create", name="backend_sector_create")
     * @Method("POST")
     * @Template("AppBundle:Backend\Sector:new.html.twig")
     */
    public function createAction(Request $request)
    {
        $this->verificationUserAccessControl('new_sector');

        $entity = new Sector();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);
        if ($form->isValid()) {
            try {
                $em = $this->getDoctrine()->getManager();

                $em->persist($entity);
                $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro criado com sucesso!');

                return $this->redirect($this->generateUrl('backend_sector', array('id' => $entity->getId())));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Creates a form to create a Sector entity.
     *
     * @param Sector $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Sector $entity)
    {
        $form = $this->createForm(new SectorType(), $entity, array(
            'action' => $this->generateUrl('backend_sector_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
     * Displays a form to create a new Sector entity.
     *
     * @Route("/new", name="backend_sector_new")
     * @Method("GET")
     * @Template()
     */
    public function newAction()
    {
        $this->verificationUserAccessControl('new_sector');

        $entity = new Sector();
        $form = $this->createCreateForm($entity);

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Displays a form to edit an existing Sector entity.
     *
     * @Route("/{id}/edit", name="backend_sector_edit")
     * @Method("GET")
     * @Template()
     */
    public function editAction($id)
    {
        $this->verificationUserAccessControl('edit_sector');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:Sector')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Sector entity.');
        }

        $editForm = $this->createEditForm($entity);
        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }

    /**
    * Creates a form to edit a Sector entity.
    *
    * @param Sector $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditForm(Sector $entity)
    {
        $form = $this->createForm(new SectorType(), $entity, array(
            'action' => $this->generateUrl('backend_sector_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }
    /**
     * Edits an existing Sector entity.
     *
     * @Route("/{id}", name="backend_sector_update")
     * @Method("PUT")
     * @Template("AppBundle:Backend\Sector:edit.html.twig")
     */
    public function updateAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('edit_sector');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:Sector')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Sector entity.');
        }

        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            try {
                $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro atualizado com sucesso!');

                return $this->redirect($this->generateUrl('backend_sector', array('id' => $id)));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }
    /**
     * Deletes a Sector entity.
     *
     * @Route("/{id}/delete", name="backend_sector_delete")
     */
    public function deleteAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('remove_sector');

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('AppBundle:Sector')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Sector entity.');
        }

        $em->remove($entity);
        $em->flush();
        $request->getSession()
            ->getFlashBag()
            ->add('success', 'Registro excluído com sucesso!');
        return $this->redirect($this->generateUrl('backend_sector'));
    }

    /**
     * Find Sector (Ajax)
     * @Route("/sector/find" , name="backend_sector_find", options={"expose"=true})
     */
    public function sectorFindAction(Request $request)
    {
        $dataRequest = $this->getParametersRequestAjax($request);
        $result = $this->getSectorRepository()->findForSearch($dataRequest['find'], true);

        return new JsonResponse($result);
    }
}
