<?php

namespace AppBundle\Controller\Backend;

use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use AppBundle\Entity\Survey;
use AppBundle\Form\SurveyType;

/**
 * Survey controller.
 *
 * @Route("/backend/survey")
 */
class SurveyController extends BaseController
{
    /**
     * @Route("/" , name="backend_survey")
     * @Template("AppBundle:Backend\Survey:index.html.twig")
     */
    public function indexAction()
    {
        $this->verificationUserAccessControl('index_survey');

        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('AppBundle:Survey')->findAll();

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $entities,
            $this->get('request')->query->get('page', 1),
            12
        );

        return array(
            'entities' => $entities,
        );
    }

    /**
     * Creates a new Survey entity.
     *
     * @Route("/create", name="backend_survey_create")
     * @Method("POST")
     * @Template("AppBundle:Backend\Survey:new.html.twig")
     */
    public function createAction(Request $request)
    {
        $this->verificationUserAccessControl('new_survey');

        $entity = new Survey();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);
        if ($form->isValid()) {
            try {
                $em = $this->getDoctrine()->getManager();

                $em->persist($entity);
                $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro criado com sucesso!');

                return $this->redirect($this->generateUrl('backend_survey', array('id' => $entity->getId())));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Creates a form to create a Survey entity.
     *
     * @param Survey $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Survey $entity)
    {
        $form = $this->createForm(new SurveyType(), $entity, array(
            'action' => $this->generateUrl('backend_survey_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
     * Displays a form to create a new Survey entity.
     *
     * @Route("/new", name="backend_survey_new")
     * @Method("GET")
     * @Template()
     */
    public function newAction()
    {
        $this->verificationUserAccessControl('new_survey');

        $entity = new Survey();
        $form = $this->createCreateForm($entity);

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Displays a form to edit an existing Survey entity.
     *
     * @Route("/{id}/edit", name="backend_survey_edit")
     * @Method("GET")
     * @Template()
     */
    public function editAction($id)
    {
        $this->verificationUserAccessControl('edit_survey');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:Survey')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Survey entity.');
        }

        $editForm = $this->createEditForm($entity);
        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }

    /**
    * Creates a form to edit a Survey entity.
    *
    * @param Survey $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditForm(Survey $entity)
    {
        $form = $this->createForm(new SurveyType(), $entity, array(
            'action' => $this->generateUrl('backend_survey_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }
    /**
     * Edits an existing Survey entity.
     *
     * @Route("/{id}", name="backend_survey_update")
     * @Method("PUT")
     * @Template("AppBundle:Backend\Survey:edit.html.twig")
     */
    public function updateAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('edit_survey');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:Survey')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Survey entity.');
        }

        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            try {
                $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro atualizado com sucesso!');

                return $this->redirect($this->generateUrl('backend_survey', array('id' => $id)));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }
    /**
     * Deletes a Survey entity.
     *
     * @Route("/{id}/delete", name="backend_survey_delete")
     *
     */
    public function deleteAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('remove_survey');

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('AppBundle:Survey')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Survey entity.');
        }

        $em->remove($entity);
        $em->flush();

        $request->getSession()
            ->getFlashBag()
            ->add('success', 'Registro excluído com sucesso!');

        return $this->redirect($this->generateUrl('backend_survey'));
    }
}
