<?php

namespace AppBundle\Controller\Backend;

use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use AppBundle\Entity\Testimonial;
use AppBundle\Form\TestimonialType;

/**
 * Testimonial controller.
 *
 * @Route("/backend/testimonial")
 */
class TestimonialController extends BaseController
{
    /**
     * @Route("/" , name="backend_testimonial")
     * @Template("AppBundle:Backend\Testimonial:index.html.twig")
     */
    public function indexAction()
    {
        $this->verificationUserAccessControl('index_testimonial');

        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('AppBundle:Testimonial')->findAll();

        return array(
            'entities' => $entities,
        );
    }

    /**
     * Creates a new Testimonial entity.
     *
     * @Route("/create", name="backend_testimonial_create")
     * @Method("POST")
     * @Template("AppBundle:Backend\Testimonial:new.html.twig")
     */
    public function createAction(Request $request)
    {
        $this->verificationUserAccessControl('new_testimonial');

        $entity = new Testimonial();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);
        if ($form->isValid()) {
            try {
                $em = $this->getDoctrine()->getManager();

                $em->persist($entity);
                $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro criado com sucesso!');

                return $this->redirect($this->generateUrl('backend_testimonial', array('id' => $entity->getId())));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Creates a form to create a Testimonial entity.
     *
     * @param Testimonial $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Testimonial $entity)
    {
        $form = $this->createForm(new TestimonialType(), $entity, array(
            'action' => $this->generateUrl('backend_testimonial_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
     * Displays a form to create a new Testimonial entity.
     *
     * @Route("/new", name="backend_testimonial_new")
     * @Method("GET")
     * @Template()
     */
    public function newAction()
    {
        $this->verificationUserAccessControl('new_testimonial');

        $entity = new Testimonial();
        $form = $this->createCreateForm($entity);

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Displays a form to edit an existing Testimonial entity.
     *
     * @Route("/{id}/edit", name="backend_testimonial_edit")
     * @Method("GET")
     * @Template()
     */
    public function editAction($id)
    {
        $this->verificationUserAccessControl('edit_testimonial');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:Testimonial')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Testimonial entity.');
        }

        $editForm = $this->createEditForm($entity);
        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }

    /**
    * Creates a form to edit a Testimonial entity.
    *
    * @param Testimonial $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditForm(Testimonial $entity)
    {
        $form = $this->createForm(new TestimonialType(), $entity, array(
            'action' => $this->generateUrl('backend_testimonial_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }
    /**
     * Edits an existing Testimonial entity.
     *
     * @Route("/{id}", name="backend_testimonial_update")
     * @Method("PUT")
     * @Template("AppBundle:Backend\Testimonial:edit.html.twig")
     */
    public function updateAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('edit_testimonial');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:Testimonial')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Testimonial entity.');
        }

        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            try {
                $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro atualizado com sucesso!');

                return $this->redirect($this->generateUrl('backend_testimonial', array('id' => $id)));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }
    /**
     * Deletes a Testimonial entity.
     *
     * @Route("/{id}/delete", name="backend_testimonial_delete")
     *
     */
    public function deleteAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('remove_testimonial');

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('AppBundle:Testimonial')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Testimonial entity.');
        }

        $em->remove($entity);
        $em->flush();
        $request->getSession()
            ->getFlashBag()
            ->add('success', 'Registro excluído com sucesso!');
        return $this->redirect($this->generateUrl('backend_testimonial'));
    }
}
