<?php

namespace AppBundle\Controller\Backend;

use AppBundle\Controller\BaseController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use AppBundle\Entity\Theme;
use AppBundle\Form\ThemeType;

/**
 * Message controller.
 *
 * @Route("/backend/theme")
 */
class ThemeController extends BaseController
{
    /**
     * @Route("/" , name="backend_theme")
     * @Template("AppBundle:Backend\Theme:index.html.twig")
     */
    public function indexAction()
    {
        $this->verificationUserAccessControl('index_theme');
        
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('AppBundle:Theme')->findAll();

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $entities,
            $this->get('request')->query->get('page', 1),
            12
        );

        return array(
            'entities' => $entities,
        );
    }

    /**
     * @Route("/new" , name="backend_theme_new")
     * @Template("AppBundle:Backend\Theme:new.html.twig")
     */
    public function newAction(Request $request)
    {
        $this->verificationUserAccessControl('new_theme');
        $entity = new Theme();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($request->isMethod('POST')) {
            $em = $this->getDoctrine()->getManager();

            $em->persist($entity);
            $em->flush();

            $this->successMessage($request);

            return $this->redirect($this->generateUrl('backend_theme'));
        }

        return array(
            'entity' => $entity,
            'form'   => $form->createView(),
        );
    }

    /**
     * @Route("/{id}/edit", name="backend_theme_edit")
     * @Template("AppBundle:Backend\Theme:edit.html.twig")
     */
    public function editAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('edit_theme');
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('AppBundle:Theme')->find($id);

        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($request->isMethod('POST') || $request->isMethod('PUT')) {
            $em = $this->getDoctrine()->getManager();

            $em->persist($entity);
            $em->flush();

            $this->successMessage($request);

            return $this->redirect($this->generateUrl('backend_theme'));
        }

        $editForm = $this->createEditForm($entity);

        return array(
            'entity'      => $entity,
            'edit_form'   => $editForm->createView(),
        );
    }

    /**
     * @Route("/{id}/delete", name="backend_theme_delete")
     * @Template()
     */
    public function deleteAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('remove_theme');
        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('AppBundle:Theme')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Theme entity.');
        }

        $em->remove($entity);
        $em->flush();

        $this->successRemoveMessage($request);

        return $this->redirect($this->generateUrl('backend_theme'));
    }

    /**
     * Creates a form to create a Theme entity.
     *
     * @param Theme $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Theme $entity)
    {
        $form = $this->createForm(new ThemeType(), $entity, array(
            'action' => $this->generateUrl('backend_theme_new'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
    * Creates a form to edit a Theme entity.
    *
    * @param Theme $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditForm(Theme $entity)
    {
        $form = $this->createForm(new ThemeType(), $entity, array(
            'action' => $this->generateUrl('backend_theme_edit', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }
}
