<?php

namespace AppBundle\Controller\Backend;

use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpFoundation\Request;
use AppBundle\Entity\UserStatus;
use AppBundle\Form\UserStatusType;

/**
 * UserStatus controller.
 *
 * @Route("/backend/userStatus")
 */
class UserStatusController extends BaseController
{
    /**
     * @Route("/" , name="backend_userStatus")
     * @Template("AppBundle:Backend\UserStatus:index.html.twig")
     */
    public function indexAction()
    {
        $this->verificationUserAccessControl('index_user_status');

        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('AppBundle:UserStatus')->findAll();

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $entities,
            $this->get('request')->query->get('page', 1),
            12
        );

        return array(
            'entities' => $entities,
        );
    }

    /**
     * Creates a new UserStatus entity.
     *
     * @Route("/create", name="backend_userStatus_create")
     * @Method("POST")
     * @Template("AppBundle:Backend\UserStatus:new.html.twig")
     */
    public function createAction(Request $request)
    {
        $this->verificationUserAccessControl('new_user_status');

        $entity = new UserStatus();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);
        if ($form->isValid()) {
            try {
                $em = $this->getDoctrine()->getManager();

                $em->persist($entity);
                $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro criado com sucesso!');

                return $this->redirect($this->generateUrl('backend_userStatus', array('id' => $entity->getId())));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Creates a form to create a UserStatus entity.
     *
     * @param UserStatus $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(UserStatus $entity)
    {
        $form = $this->createForm(new UserStatusType(), $entity, array(
            'action' => $this->generateUrl('backend_userStatus_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
     * Displays a form to create a new UserStatus entity.
     *
     * @Route("/new", name="backend_userStatus_new")
     * @Method("GET")
     * @Template()
     */
    public function newAction()
    {
        $this->verificationUserAccessControl('new_user_status');

        $entity = new UserStatus();
        $form = $this->createCreateForm($entity);

        return array(
            'entity' => $entity,
            'form' => $form->createView(),
        );
    }

    /**
     * Displays a form to edit an existing UserStatus entity.
     *
     * @Route("/{id}/edit", name="backend_userStatus_edit")
     * @Method("GET")
     * @Template()
     */
    public function editAction($id)
    {
        $this->verificationUserAccessControl('edit_user_status');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:UserStatus')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find UserStatus entity.');
        }

        $editForm = $this->createEditForm($entity);
        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }

    /**
    * Creates a form to edit a UserStatus entity.
    *
    * @param UserStatus $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditForm(UserStatus $entity)
    {
        $form = $this->createForm(new UserStatusType(), $entity, array(
            'action' => $this->generateUrl('backend_userStatus_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }
    /**
     * Edits an existing UserStatus entity.
     *
     * @Route("/{id}", name="backend_userStatus_update")
     * @Method("PUT")
     * @Template("AppBundle:Backend\UserStatus:edit.html.twig")
     */
    public function updateAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('edit_user_status');

        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('AppBundle:UserStatus')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find UserStatus entity.');
        }

        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            try {
                $em->flush();

                $request->getSession()
                    ->getFlashBag()
                    ->add('success', 'Registro atualizado com sucesso!');

                return $this->redirect($this->generateUrl('backend_userStatus', array('id' => $id)));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                    ->getFlashBag()
                    ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
            'entity' => $entity,
            'edit_form' => $editForm->createView(),
        );
    }
    /**
     * Deletes a UserStatus entity.
     *
     * @Route("/{id}/delete", name="backend_userStatus_delete")
     *
     */
    public function deleteAction(Request $request, $id)
    {
        $this->verificationUserAccessControl('remove_user_status');

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('AppBundle:UserStatus')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find UserStatus entity.');
        }

        $em->remove($entity);
        $em->flush();

        $request->getSession()
            ->getFlashBag()
            ->add('success', 'Registro excluído com sucesso!');

        return $this->redirect($this->generateUrl('backend_userStatus'));
    }
}
