<?php

namespace AppBundle\Controller;

use JMS\Serializer\SerializerBuilder;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use AppBundle\Entity\Client;
use AppBundle\Entity\JobRole;
use AppBundle\Entity\UserStatus;
use AppBundle\Entity\Sector;
use AppBundle\Entity\LastAccess;
use AppBundle\Entity\IqaCicleConcluded;
use AppBundle\Entity\IqaLog;
use UserBundle\Entity\User;

class BaseController extends Controller
{
    
    /**
     * Função que retorna o json para a requisição
     * @param array $return Array de retorno
     * @return Response
     */
    public function returnJson($return)
    {
        /*$serializer = SerializerBuilder::create()->build();
        $return = $serializer->serialize($return, 'json');*/
        $serializer = SerializerBuilder::create()->build();
        $return = $serializer->serialize($return, 'json');
        return new Response($return, 200, array('Content-Type' => 'application/json'));
    }

    /**
     * Retorna o service "logger".
     * @return \Monolog\Logger
     */
    protected function getLogger()
    {
        return $this->get("logger");
    }

    /**
     * Login do usuário
     */
    protected function validUser($data = null)
    {
        if ($this->getUser()==null) {

            $goto = $this->container->get("request")->getUri();
            if ($data == null) {
                // header("Location: /simplesaml/module.php/core/authenticate.php?as=lmssambatech&goto=http://hml.lmssambatech.com.br/curso/cursos");
                header("Location: /simplesaml/module.php/core/authenticate.php?as=lmssambatech&goto=".$goto);
                die();
            }
            $data = urldecode($data);
            $data = json_decode($data, true);

            $user = $this->convertDataUserInArray($data);
            $repositoryClient = $this->getDoctrine()->getRepository("AppBundle:Client");
            $userRow = null;
            if (array_key_exists('Grupo', $user)) {
                $userRow = $this->findUser($user);
            } else {
                if (array_key_exists("Matricula", $user) && array_key_exists("NumeroEmpresa", $user)) {
                    $userRow = $repositoryClient->findOneBy(array('mat_colaborador' => $user['Matricula'], 'num_enterprise' => $user['NumeroEmpresa'], 'tip_colaborador' => $user['TipoEmpregado']));
                }
            }
            
            if ($userRow != null) {
                $this->registerLastAccess($userRow);
            }

            //Validate if user has access granted
            if($userRow && $userRow->getAccessGranted()){
                session_start();
                $_SESSION['SHOW_IQA_CICLE_MODAL'] = 1;
                return $userRow;
            }else{
                return null;
            }
        } else {
            return $this->getUser();
        }
    }

    protected function findUser($simpleSamlUser)
    {
        return $this->findByUserGroup($simpleSamlUser);
    }

    protected function findByUserGroup($simpleSamlUser)
    {
        $controlUserGroup = null;
        $repositoryUserGroup = $this->getDoctrine()->getRepository("AppBundle:UserGroup");
        $userGroups = $repositoryUserGroup->findAll();
        $user = null;
        foreach ($userGroups as $userGroup) {
            $grupo = strpos($userGroup->getItemGroup(), ',') ? explode(",",$userGroup->getItemGroup()) : strtoupper(trim($userGroup->getItemGroup()));
            if (is_array($grupo)) {
                $match = 0;
                foreach($grupo as $item) {
                    $grupoString = strtoupper(trim($item));                   
                    if (is_array($simpleSamlUser['Grupo'])) {
                        $search_array = array_map('strtoupper', $simpleSamlUser['Grupo']);
                        if (in_array($grupoString, $search_array)) {
                            $match++;
                        } 
                    }else{
                        if($grupoString == $simpleSamlUser['Grupo']){
                            $match++;
                        }
                    }
                }
                if($match == count($grupo)){
                    $controlUserGroup = $userGroup;
                }
            }else{
                if (is_array($simpleSamlUser['Grupo'])) {
                    if (in_array($grupo, $simpleSamlUser['Grupo'])) {
                        $controlUserGroup = $userGroup;
                    }
                }else{
                    if($grupo == $simpleSamlUser['Grupo']){
                        $controlUserGroup = $userGroup;
                    }
                }
            }
            $this->log("controlUserGroup");
            $this->log($controlUserGroup);
            if($controlUserGroup){
                $searchedUser = $this->searchUserByUserGroup($controlUserGroup, $simpleSamlUser);
                $user = (($searchedUser!=null)? $searchedUser: $user);
                if($searchedUser!=null){
                    return $searchedUser;
                }
            }
        }
        return $user;
    }

    protected function searchUserByUserGroup($userGroup, $simpleSamlUser){
        $search = $this->prepareArrayToSearch($userGroup, $simpleSamlUser);
        $this->log("search");
        $this->log($search);
        $repositoryClient = $this->getDoctrine()->getRepository("AppBundle:Client");
        if(empty($search)){
            return null;
        }
        return $repositoryClient->findOneBy($search);
    }

    protected function prepareArrayToSearch($userGroup, $simpleSamlUser)
    {
        $repositorySimplesamlDictionary = $this->getDoctrine()->getRepository("AppBundle:SimplesamlDictionary");
        $itemKeys = explode(",",$userGroup->getItemKeys());
        $searchArray = array();
        foreach ($itemKeys as $itemKey) {
            $itemDictionary = $repositorySimplesamlDictionary->findOneByChave($itemKey);
            if($itemDictionary){
                $indexLms = $itemDictionary->getChaveLms();
                $indexSimplesaml = $itemDictionary->getChaveSimplesaml();
                $searchArray[$indexLms] = $simpleSamlUser[$indexSimplesaml];
            }
        }
        $searchArray["usergroup"] = $userGroup->getId();
        return $searchArray;
    }
    protected function searchUserByUserGroupForImport($row){
        $repositoryUserGroup = $this->getDoctrine()->getRepository("AppBundle:UserGroup");
        $userGroup = $repositoryUserGroup->findOneByDescription($row[0]);
        if(!$userGroup)
            return null;
        $search = $this->prepareArrayToSearchForImport($userGroup, $row);
        // $this->log("search");
        // $this->log($search);
        $repositoryClient = $this->getDoctrine()->getRepository("AppBundle:Client");
        if(empty($search)){
            return null;
        }
        return $repositoryClient->findOneBy($search);
    }

    protected function prepareArrayToSearchForImport($userGroup, $row)
    {
        $repositoryImportDictionary = $this->getDoctrine()->getRepository("AppBundle:ImportDictionary");
        $itemKeys = explode(",",$userGroup->getItemKeys());
        $searchArray = array();
        foreach ($itemKeys as $itemKey) {
            $itemDictionary = $repositoryImportDictionary->findOneByChave($itemKey);
            if($itemDictionary){
                $indexLms = $itemDictionary->getChaveLms();
                $indexSheet = $itemDictionary->getIndexSheet();
                $searchArray[$indexLms] = $row[$indexSheet];
            }
        }
        $searchArray["usergroup"] = $userGroup->getId();
        return $searchArray;
    }



    public function transformGroupUser($group)
    {
        $func = function ($item) {
            return strtoupper(trim($item));
        };

        $groupDataList = explode(",", $group);
        $result = array_map($func, $groupDataList);

        return $result;
    }

    public function showIqaCicleConclusion(){
        $this->log("!!!!");
        $this->log("BASECONTROLLER: showIqaCicleConclusion");
        $em = $this->getDoctrine()->getManager();
        $showPopup = 0;
        if($this->getUser()->getUsergroup() && $this->getUser()->getUsergroup()->getCooperated()){
            $iqaCicle = $em->getRepository('AppBundle:IqaCicle')->getActiveIqaCicle();
            if($iqaCicle){
                $this->log("has iqacicle");
                $client = $em->getRepository('AppBundle:Client')->find($this->getUser()->getId());
                $iqaCicleConcluded = $em->getRepository('AppBundle:IqaCicleConcluded')->findBy(array(
                    'iqaCicle' => $iqaCicle,
                    'uid' => $client->getCrmForMediacenter(),
                ));
                if($iqaCicleConcluded){
                    return $showPopup = 0;
                }
                $obrigatorioAssistido = 0;
                $percentage = 0;
                $iqaCicle = $em->getRepository('AppBundle:IqaCicle')->getActiveIqaCicle();
                if($iqaCicle){
                    $totalObrigatorio = count($em->getRepository('AppBundle:IqaMidia')->findBy(array(
                        'iqaCicle' => $iqaCicle->getId(),
                        'mandatory' => '1',
                    )));
                    $iqaMidiasMediaCenter = $em->getRepository('AppBundle:IqaMidia')->findBy(array(
                        'iqaCicle' => $iqaCicle->getId(),
                        'plataform' => 'Media Center',
                    ));
                    foreach ($iqaMidiasMediaCenter as $item) {
                        //Carrega o objeto svmedia
                        $svMedia = $this->getIqaCicleMediacenterRepository()->getMediaFromMediaCenter($item->getMediaId());
                        if($svMedia){
                            $userHasSvMedia = $this->getIqaCicleMediacenterRepository()->getUserHasSvMedia($client->getCrmForMediacenter(), $svMedia['mid']);
                            if($userHasSvMedia){
                                $percentage += $item->getPercentage();
                                if($item->getMandatory()){
                                    $obrigatorioAssistido++;
                                }
                            }
                        }
                    }

                    $iqaMidiasLMS = $em->getRepository('AppBundle:IqaMidia')->findBy(array(
                        'iqaCicle' => $iqaCicle->getId(),
                        'plataform' => 'LMS',
                    ));
                    foreach ($iqaMidiasLMS as $item) {
                        $userEvaluation = $em->getRepository('AppBundle:UserEvaluation')->getApprovedByCrm($client, $em->getReference('AppBundle:Course', $item->getCourseId()));
                        if($userEvaluation){
                            $percentage += $item->getPercentage();
                            if($item->getMandatory()){
                                $obrigatorioAssistido++;
                            }
                        }
                    }

                    $this->log("percentage ".$percentage);
                    $this->log("obrigatorioAssistido ".$obrigatorioAssistido);
                    $this->log("totalObrigatorio ".$totalObrigatorio);
                    if($percentage >= 100 && ($obrigatorioAssistido>=$totalObrigatorio)){
                        //Todo: salvar iqa cicle concluido para usuário
                        $iqaCicleConcluded = new IqaCicleConcluded();
                        $iqaCicleConcluded->setIqaCicle($iqaCicle);
                        $iqaCicleConcluded->setUid($client->getCrmForMediacenter());
                        //TODO - IQA: SAVE USER ID
                        $iqaCicleConcluded->setUser($this->getUser());
                        $em->persist($iqaCicleConcluded);
                        $em->flush();
                        $showPopup = 1;

                        if($showPopup){
                            //TODO - IQA: MENSAGEM SUCESSO
                            $iqaLog = new IqaLog();
                            $iqaLog->setIqaCicle($iqaCicle);
                            $iqaLog->setUser($this->getUser());
                            $iqaLog->setMessage("Você já concluiu 100% dos conteúdos válidos para o ciclo atual do IQA, garantindo sua remuneração. PARABÉNS!");
                            $iqaLog->setPorcentagem($percentage);
                            $em->persist($iqaLog);
                            $em->flush();
                        }
                    }
                }
            }
        }
        return $showPopup;
    }

    /**
     * Método para retornar o objeto User.
     * @return CoreBundle\Entity\User
     */
    public function getUser()
    {
        return parent::getUser();
    }

    /**
     * Método para retornar o objeto Client.
     */
    public function getClient($user)
    {
        return $this->getDoctrine()->getRepository('AppBundle:Client')->find($user);
    }

    /**
     * Retorna o repositório de inscription.
     * @return AppBundle\Repository\InscriptionRepository
     */
    protected function getInscriptionRepository()
    {
        return $this->getDoctrine()->getRepository('AppBundle:Inscription');
    }

    /**
     * Retorna o repositório de evaluation.
     * @return AppBundle\Repository\EvaluationRepository
     */
    protected function getEvaluationRepository()
    {
        return $this->getDoctrine()->getRepository('AppBundle:Evaluation');
    }

    /**
     * Retorna o repositório de user.
     * @return AppBundle\Repository\UserRepository
     */
    protected function getUserRepository()
    {
        return $this->getDoctrine()->getRepository('UserBundle:User');
    }

    protected function getCommentRepository()
    {
        return $this->getDoctrine()->getRepository('AppBundle:Comment');
    }

    protected function getCompanyRepository()
    {
        return $this->getDoctrine()->getRepository('AppBundle:Company');
    }

    protected function getIqaCicleMediacenterRepository()
    {
        return $this->getDoctrine()->getRepository('MediaCenterBundle:IqaCicle', 'mediacenter');
    }

    public function getIdCollectionItens($collectionItens)
    {
        $itens = array();
        if ($collectionItens) {
            foreach ($collectionItens as $item) {
                $item = json_decode($item, true);
                array_push($itens, $item['id']);
            }
        }

        return (count($itens) > 0) ? $itens : false;
    }

    /**
     * Get method repository
     * @param string $entityName, nome da entity que deseja buscar
     * @return object repository
     */
    protected function getRepositoryFromBase($entityName, $bundle='AppBundle')
    {
        return $this->getDoctrine()->getRepository($bundle.':'.ucfirst($entityName));
    }

    /**
     * Método para verificar acesso para cursos (super usuário ou cliente responsável por alguma empresa.
     * @return createNotFoundException
     */
    public function verifyAdminOrResponsabile()
    {
        $admin_company = $this->findCompanyClientResponsible($this->getUser());
        if (!$this->get('security.authorization_checker')->isGranted('ROLE_SUPER_ADMIN') && empty($admin_company)) {
            throw $this->createNotFoundException('Você não tem permissão para acessar esta tela.');
        }
    }
    /**
     * Retorna empresa que o cliente é responsável
     * */
    public function findCompanyClientResponsible($user)
    {
        if ($this->getUser() instanceof Client) {
            $id = $user->getId();
            $company = $this->getDoctrine()->getRepository('AppBundle:Company')->findBy(array('responsible' => $id));
            return $company;
        } else {
            return null;
        }
    }
    /**
     * Verifica se usuário é um cliente com uma empresa relacionada,
     * caso seja, retorna os cursos da empresa
     * @return Course/Boolean
     **/
    public function getCourseClientCompany($user)
    {
        if ($this->getUser() instanceof Client) {
            $company = $user->getCompany();
            if ($company) {
                return $company->getCourses();
            }
        }
        return false;
    }

    /**
     * Método para verificar acesso.
     * @return createNotFoundException
     */
    public function verifyAdmin()
    {
        if (!$this->get('security.authorization_checker')->isGranted('ROLE_SUPER_ADMIN')) {
            throw $this->createNotFoundException('Você não tem permissão para acessar esta tela.');
        }
    }

    /**
     * Valida se o username e email são válidos
     * @param User $entity
     * @return boolean $flag
     */
    public function validUsernameEmail($entity)
    {
        $repository = $this->getUserRepository();
        $flag = $repository->getUserByNameAndUsername($entity);

        return $flag;
    }

    /**
     * Valida se o cpf é válido
     * @param User $entity
     * @return boolean $flag
     */
    public function validCPF($entity)
    {
        $repository = $this->getClientRepository();
        if($entity->getCpf()){
            $flag = $repository->getClientByCPF($entity);
        }else{
            return true;
        }

        return $flag;
    }

    /**
     * Set entity fields custom
     * @param Request $request
     * @param Entity $entity
     */
    public function requestSambaVideosForm($request, $entity)
    {
        $svVideosArray = $request->request->get('sv_videos');
        $entity->setSvVideo($svVideosArray[0]);
    }

    /**
     * Atalho para geração de logs no sistema.
     * @param string $message Mensagem a ser incluida no log.
     * @param string $level Level do log. Default: error.
     */
    protected function log($message, $level = "error")
    {
        if (is_array($message)) {
            $message = print_r($message, true);
        }
        $this->get('logger')->log($level, '[unimed] ' . $message);
        // $this->get('logger')->log($level, $message);
    }

    /**
     * Throws a NotFoundHttpException
     * @param  String $message Message
     * @throws NotFoundHttpException
     */
    protected function throwNotFound($message)
    {
        throw new NotFoundHttpException($message);
    }

    /**
     * Throws a BadRequestHttpException
     * @param  String $message Message
     * @throws BadRequestHttpException
     */
    protected function throwBadRequest($message)
    {
        throw new BadRequestHttpException($message);
    }

    /**
    * Adds support for magic finders for repositories.
    *
    * @param string $method
    * @param array  $arguments
    *
    * @return object The found repository.
    * @throws \BadMethodCallException If the method called is an invalid find* method
    *                                 or no find* method at all and therefore an invalid
    *                                 method call.
    */
    public function __call($method, $arguments)
    {
        if (preg_match('/^get(\w+)Repository$/', $method, $matches)) {
            return $this->getDoctrine()->getRepository('AppBundle:' . $matches[1]);
        } elseif (preg_match('/^get(\w+)Reference$/', $method, $matches)) {
            return $this->getDoctrine()->getManager()->getReference('AppBundle:' . $matches[1], $arguments[0]);
        } else {
            throw new \BadMethodCallException("Undefined method '$method'. Provide a valid repository name!");
        }
    }

    public function getDataPorExtenso()
    {
        setlocale(LC_ALL, 'pt_BR', 'pt_BR.utf-8', 'pt_BR.utf-8', 'portuguese');
        date_default_timezone_set('America/Sao_Paulo');
        return strftime('%d de %B de %Y', strtotime('today'));
    }

    /**************************************************************/
    /*              Functions support validUser                   */
    /**************************************************************/

    /**
     * Convert data user(requested) in array
     *
     * @param [array] $dataUser
     * @return array
     */
    private function convertDataUserInArray($dataUser = null)
    {
        $response = array();
        if ($dataUser && count($dataUser) > 0) {
            foreach ($dataUser as $index => $value) {
                if (is_array($value) && count($value) == 1) {
                    $response[$index] = $value[0];
                } else {
                    $response[$index] = $value;
                }
            }
        }

        return $response;
    }

    /**
     * Undocumented function
     *
     * @param [array] $user
     * @return userStatus
     */
    private function checkAndGetUserStatus($user)
    {
        $userStatus = '';
        if (!empty($user['Status'])) {
            // Verifica se a funÃ§Ã£o existe existe, se nÃ£o, cadastra
            $repository = $this->getDoctrine()->getRepository("AppBundle:UserStatus");
            $userStatus = $repository->findOneBy(array('name'=>$user['Status']));
            if (empty($userStatus)) {
                $userStatus = new UserStatus();
                $userStatus->setName($user['Status']);
                $em = $this->getDoctrine()->getManager();
                $em->persist($userStatus);
                $em->flush();
            }
        }

        return $userStatus;
    }

    /**
     * Undocumented function
     *
     * @param [type] $user
     * @return void
     */
    private function checkAndGetUserSector($user)
    {
        $sector = '';
        if (!empty($user['LocalTrabalho'])) {
            $repositorySector = $this->getDoctrine()->getRepository("AppBundle:Sector");
            $sector = $repositorySector->findOneBy(array('name'=>$user['LocalTrabalho']));
            if (empty($sector)) {
                $sector = new Sector();
                $sector->setName($user['LocalTrabalho']);
                $em = $this->getDoctrine()->getManager();
                $em->persist($sector);
                $em->flush();
            }
        }

        return $sector;
    }

    /**
     * Undocumented function
     *
     * @param [type] $user
     * @return void
     */
    private function checkAndGetUserSuperior($user)
    {
        $superior = '';
        if (!empty($user['MatriculaSUperior'])) {
            $repositoryUser = $this->getDoctrine()->getRepository("AppBundle:Client");
            $superior = $repositoryUser->findOneBy(array('mat_colaborador'=>$user['MatriculaSUperior']));
        }

        return $superior;
    }

    /**
     * Undocumented function
     *
     * @param [type] $user
     * @return void
     */
    private function checkAndGetUserRole($user)
    {
        $role = '';
        if (!empty($user['Cargo'])) {
            // Verifica se a funÃ§Ã£o existe existe, se nÃ£o, cadastra
            $repositoryRole = $this->getDoctrine()->getRepository("AppBundle:JobRole");
            $role = $repositoryRole->findOneBy(array('name'=>$user['Cargo']));
            if (empty($role)) {
                $jobRole = new JobRole();
                $jobRole->setName($user['Cargo']);
                // $jobRole->setType($user['type']);
                $em = $this->getDoctrine()->getManager();
                $em->persist($jobRole);
                $em->flush();
                $role = $jobRole;
            }
        }

        return $role;
    }

    /**
     * Undocumented function
     *
     * @param [type] $user
     * @return void
     */
    private function registerLastAccess($user)
    {
        $date = new \DateTime();
        $lastAccess = new LastAccess();
        $lastAccess->setUser($user);
        $lastAccess->setDate($date);
        $em = $this->getDoctrine()->getManager();
        $em->persist($lastAccess);
        $em->flush();
    }

    public function successCreateMessage($request)
    {
        $request->getSession()
                ->getFlashBag()
                ->add('success', 'Registro criado com sucesso!');
    }

    public function successMessage($request, $message = 'Registro atualizado com sucesso!')
    {
        $request->getSession()
                ->getFlashBag()
                ->add('success', $message);
    }

    public function warningMessage($request, $msg = '')
    {
        $msg = empty($msg) ? 'Atenção , não foi possível realizar a operação.' : $msg ;

        $request->getSession()
                ->getFlashBag()
                ->add('warning', $msg);
    }

    public function successRemoveMessage($request)
    {
        $request->getSession()
                ->getFlashBag()
                ->add('success', 'Registro removido com sucesso!');
    }

    public function errorMessage($request, $msg = '')
    {
        $msgError = empty($msg) ? 'Ocorreu algum erro inesperado. Tente novamente mais tarde!' : $msg;

        $request->getSession()
                ->getFlashBag()
                ->add('error', $msg);
    }

    public function getParametersRequestAjax($request)
    {
        $data = $request->getContent();
        $data = json_decode($data, true);

        return $data;
    }

    /**
     * Enviar email de cancelamento
     * @param String $email
     * @param String $subject
     * @param String $message
     */
    public function notificationUserEmail($email, $subject, $message)
    {
        $mailMessage = \Swift_Message::newInstance()
            ->setSubject("[Unimed] - " . $subject)
            ->setFrom("universidadecorporativa@unimedbh.com.br")
            ->setTo($email)
            ->setContentType("text/html")
            ->setBody($message);

        $this->container->get('mailer')->send($mailMessage);
    }

    public function verificationUserAccessControl($accessAction, $viewTemplate = false)
    {
        //Obtem as permissões salvas em sessão
        $user_access_permissions = $this->get('session')->get('user_access_permissions');

        //Verifica se existe a permissão fornecida
        if (!in_array($accessAction, array_column($user_access_permissions, 'guard'))
            && !in_array("all_permissions", array_column($user_access_permissions, 'guard'))) {
            if ($viewTemplate) {
                return false;
            }

            throw $this->createAccessDeniedException('Você não tem permissão para acessar essa página!');
        }

        return true;
    }

    public function getEnterpriseAccessControl()
    {
        //Obtem as empresas salvas em sessão
        $user_access_enterprises = $this->get('session')->get('user_access_enterprises');

        return !empty($user_access_enterprises) ? join(", ", $user_access_enterprises) : null;
    }
}