<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use AppBundle\Form\ProfileType;
use AppBundle\Entity\Client;

class ClientController extends BaseController
{

    /**
     * @Route("/dashboard/meu-perfil", name="client_edit")
    */
    public function editAction(Request $request)
    {
        //$entity = new Client();
        $this->validUser();
        $entity = $this->getUser();
        $form = $this->createForm(new ClientType($this->getDoctrine()->getManager(), null), $entity);
        $form->handleRequest($request);
        if ($request->getMethod() == 'POST') {
            if ($this->validUsernameEmail($entity)) {
                try {
                    $em = $this->getDoctrine()->getManager();

                    // Set entity fields custom
                    $this->requestCustomForm($request, $entity);

                    $em->persist($entity);
                    $em->flush();

                    $request->getSession()
              ->getFlashBag()
              ->add('success', "Seu registro foi atualizado com sucesso!");
                } catch (\Exception $e) {
                    $this->log($e);
                    $request->getSession()
              ->getFlashBag()
              ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
                }
            } else {
                $request->getSession()
            ->getFlashBag()
            ->add('error', 'Email já cadastrado, tente novamente!');
            }
        }

        return $this->render('AppBundle:Client:edit.html.twig', array(
          'entity' => $entity,
          'form'=> $form->createView()
        ));
    }

    /**
     * @Route("/perfil", name="client_profile")
     * @Template("AppBundle:Client:profile.html.twig")
     */
    public function profileAction(Request $request)
    {
        $this->validUser();
        $entity = $this->getUser();
        $form = $this->createForm(new ProfileType(), $entity);
        $form->handleRequest($request);
        if ($request->getMethod() == 'POST') {
            try {
                $em = $this->getDoctrine()->getManager();

                $em->persist($entity);
                $em->flush();

                $request->getSession()
                ->getFlashBag()
                ->add('success', "Seu registro foi atualizado com sucesso!");
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()
                ->getFlashBag()
                ->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
              'entity'      => $entity,
              'form'   => $form->createView(),
          );
    }

    /**
    * Creates a form to edit a Client entity.
    *
    * @param Client $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createProfileForm(Client $entity)
    {
        $form = $this->createForm(new ClientType(), $entity, array(
              'action' => $this->generateUrl('backend_client_update', array('id' => $entity->getId())),
              'method' => 'PUT',
          ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }

    /**
    * Set entity fields custom
    * @param Request $request
    * @param Entity $entity
    */
    public function requestCustomForm($request, $entity)
    {
        $em = $this->getDoctrine()->getManager();
        $clientCustomArray = $request->request->get('client_custom');

        if (!empty($clientCustomArray['plainPassword'])) {
            $encoder = $this->container->get('security.encoder_factory')->getEncoder($entity);
            $new_pwd_encoded = $encoder->encodePassword($clientCustomArray['plainPassword'], $entity->getSalt());
            $entity->setPassword($new_pwd_encoded);
        }
    }
}
