<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\RedirectResponse;
use AppBundle\Entity\Comment;

/**
 * @Route("/comments")
 */
class CommentController extends BaseController {

    /**
     * @Route("/listar/{lessonId}", name="comment_index", options={"expose"=true})
     */
    public function indexAction(Request $request, $lessonId) {
        $this->validUser();
        return $this->returnJson($this->getComments($lessonId));
    }

    /**
     * @Route("/salvar-comentario", name="comment_save", options={"expose"=true})
     */
    public function commentSaveAction(Request $request) {
        $this->validUser();
        $em = $this->getDoctrine()->getManager();
        $data = json_decode($request->getContent(), true);

        try {
            $comment = new Comment();
            $comment->setLesson(
                $this->getLessonRepository()->find($data['comment']['lesson'])
            );
            $comment->setMessage($data['comment']['message']);
            $comment->setUser($this->getUser());
            $comment->setDtCreation(new \DateTime());
            $comment->setDtUpdate(new \DateTime());
            $em->persist($comment);
            $em->flush();
        } catch (\Exception $e) {
            return $this->returnJson(array('responseCode' => 400, 'results' => 'Não foi possível enviar esta mensagem!'));
        }

        return $this->returnJson($this->getComments($data['comment']['lesson']));
    }

    private function getComments($lessonId)
    {
        $em = $this->getDoctrine()->getManager();

        try {
            $comments = $this->getCommentRepository()->findBy(array('lesson' => $lessonId), array('dtCreation' => 'DESC'));

            $return = array('responseCode' => 200, 'results' => $comments);
        } catch (\Exception $e) {
            $return = array('responseCode' => 400, 'results' => 'Não foi possível realizar esta operação!');
        }
        return $return;
    }
}
