<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use AppBundle\Form\ClientType;
use AppBundle\Entity\Client;

/**
 * @Route("/comentar")
 **/
class CommentCourseController extends BaseController
{

    /**
     * @Route("/{id}", name="comment_send")
     */
    public function sendCommentAction(Request $request, $id) {
        $this->validUser();
        $em = $this->getDoctrine()->getManager();

        $course = $this->getRepository('AppBundle:Course')->find($id);

        return $this->redirectToRoute('course_show', array(
                'slug' => $course->getSlug(),
            ));
    }

    /**
     *@Route("/{slug}/{prefixoUrl}", name="company_url_cadastro")
     **/
    public function urlCadastroAction(Request $request, $slug, $prefixoUrl)
    {
        $this->validUser();
        $em = $this->getDoctrine()->getManager();
        $company = $this->getCompanyRepository()->findOneBy(array('slug' => $slug, 'urlCompany' => $prefixoUrl));

        if(!$company){
          throw $this->createNotFoundException('Url invárlida.');
        }

        $company = $this->getCompanyRepository()->find($company->getId());
        $entity = new Client();
        $form = $this->createForm(new ClientType($this->getDoctrine()->getManager(), $company->getId()), $entity);
        $form->handleRequest($request);

        return $this->render('AppBundle:Client:new-company.html.twig', array(
          'entity' => $entity,
          'form'=> $form->createView(),
          'company' => $company
        ));

    }
}
