<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use AppBundle\Form\ClientType;
use AppBundle\Entity\Client;

/**
 * @Route("/empresa")
 **/
class CompanyController extends BaseController
{

    /**
     * @Route("/{slug}", name="company_show")
     */
    public function showCompanyAction(Request $request, $slug) {
        $this->validUser();
        $em = $this->getDoctrine()->getManager();

        $company = $this->getCompanyRepository()->findOneBySlug($slug);

        if(!$company){
          throw $this->createNotFoundException('Empresa não encontrada.');
        }

        /*if(!$this->get('security.authorization_checker')->isGranted('ROLE_SUPER_ADMIN')){
          if($this->getUser()->getCompany() == null ||
            $this->getUser()->getCompany()->getId() != $company->getId()){
              throw $this->createNotFoundException('Você não tem permissão para acessar esta tela.');
          }
        }*/

        return $this->render('AppBundle:Company:show.html.twig',
            array(
                'company' => $company,
                'data' => $this->getDataPorExtenso(),
            )
        );
    }

    /**
     *@Route("/{slug}/{prefixoUrl}", name="company_url_cadastro")
     **/
    public function urlCadastroAction(Request $request, $slug, $prefixoUrl)
    {
        $this->validUser();
        $em = $this->getDoctrine()->getManager();
        $company = $this->getCompanyRepository()->findOneBy(array('slug' => $slug, 'urlCompany' => $prefixoUrl));

        if(!$company){
          throw $this->createNotFoundException('Url invárlida.');
        }

        $company = $this->getCompanyRepository()->find($company->getId());
        $entity = new Client();
        $form = $this->createForm(new ClientType($this->getDoctrine()->getManager(), $company->getId()), $entity);
        $form->handleRequest($request);

        return $this->render('AppBundle:Client:new-company.html.twig', array(
          'entity' => $entity,
          'form'=> $form->createView(),
          'company' => $company
        ));

    }
}
