<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\RedirectResponse;
use AppBundle\Entity\Inscription;
use AppBundle\Entity\InscriptionStatus;
use AppBundle\Entity\Payment;
use AppBundle\Entity\PaymentStatus;
use AppBundle\Entity\LikeCourse;
use AppBundle\Entity\FavCourse;
use AppBundle\Entity\UserEvaluation;
use AppBundle\Entity\CommentCourse;
use AppBundle\Entity\CourseFeedback;
use AppBundle\Form\CommentCourseType;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Course controller.
 * @Route("/curso")
 */
class CourseController extends BaseController
{

    /**
     * @Route("/avaliable-courses-preview-typeahead", name="available_courses_preview_typeahead", options={"expose"=true})
     */
    public function showAvailableCoursePreviewTypeaheadAction()
    {
        try {
            $em = $this->getDoctrine()->getManager();
            $request = Request::createFromGlobals();
            $query = $request->query->get('q');
            $entities = $em->getRepository('AppBundle:Course')->findForTypeaheadSearch($query);
            return new JsonResponse($entities);
        } catch (\Exception $e) {
            $return = array("responseCode" => 400, 'errorMessage' => $e->getTraceAsString());
        }

        return $this->returnJson($return);
    }

    /**
     * Favoritar Curso
     * @Route("/ajax/{course_id}/favorite", name="course_favorite_ajax", options={"expose"=true})
     */
    public function favoriteCourseAjaxAction($course_id)
    {
        try {
            $em = $this->getDoctrine()->getManager();
            $user = $this->getUser();
            $course = $this->getCourseRepository()->find($course_id);

            if (!$course) {
                $return = array("responseCode" => 400);
                return $this->returnJson($return);
            }
            $favCourses = $this->getFavCourseRepository()->findBy(array(
                "user" => $user,
                "course" => $course
            ));
            if (count($favCourses)>0) {
                foreach ($favCourses as $favCourse) {
                    $em->remove($favCourse);
                }
                $fav = false;
            } else {
                $favCourse = new FavCourse();
                $favCourse->setUser($user);
                $favCourse->setCourse($course);

                $em->persist($favCourse);
                $fav = true;
            }
            $em->flush();
            $return = array("responseCode" => 200, "fav" =>$fav);
            return $this->returnJson($return);
        } catch (Exception $e) {
            $return = array("responseCode" => 400);
            return $this->returnJson($return);
        }
    }

    /**
     * Like do Curso
     * @Route("/ajax/{course_id}/like", name="course_like_ajax", options={"expose"=true})
     */
    public function likeCourseAjaxAction($course_id)
    {
        try {
            $em = $this->getDoctrine()->getManager();
            $user = $this->getUser();
            $course = $this->getCourseRepository()->find($course_id);

            if (!$course) {
                $return = array("responseCode" => 400);
                return $this->returnJson($return);
            }
            $likeCourses = $this->getLikeCourseRepository()->findBy(array(
                "user" => $user,
                "course" => $course
            ));
            if (count($likeCourses)>0) {
                foreach ($likeCourses as $likeCourse) {
                    $em->remove($likeCourse);
                }
            } else {
                $likeCourse = new LikeCourse();
                $likeCourse->setUser($user);
                $likeCourse->setCourse($course);

                $em->persist($likeCourse);
            }
            $em->flush();
            $likes = $this->getLikeCourseRepository()->findBy(array(
                "course" => $course
            ));
            $return = array("responseCode" => 200, "total_likes"=>count($likes));
            return $this->returnJson($return);
        } catch (Exception $e) {
            $return = array("responseCode" => 400);
            return $this->returnJson($return);
        }
    }

    /**
     * @Route("/{course_id}/info-user", name="course_info")
     */
    public function showCoursesInfoAction($course_id)
    {
        $em = $this->getDoctrine()->getManager();
        //Carrega o curso atual
        $course = $this->getCourseRepository()->find($course_id);
        //obtem a quantidade de aulas
        $totalLessons = 0;
        $percentualRealizado = 0;
        $totalEvaluations = 0;
        $totalEvaluationsGrade = 0;
        $totalAttempts = 0;
        $valid = false;
        $dtLastEvaluation = null;
        foreach ($course->getModules() as $module) {
            $totalLessons+=count($module->getLessons());
            
            if (count($module->getEvaluations())>0) {
                $totalEvaluations++;
                $evaluation = $module->getEvaluations()->get(0);
                //$user = $this->em->getRepository('UserBundle:User')->find($client->getId());
                if ($evaluation != null) {
                    $nota = $this->getUserEvaluationRepository()->getMelhoresNotas($this->getUser(), null, $evaluation);
                    $userEvaluations = $this->getUserEvaluationRepository()->findBy(array(
                        "user" => $this->getUser(),
                        "evaluation" => $evaluation,
                    ));
                    $totalAttempts +=count($userEvaluations);
                    foreach ($nota as $value) {
                        $totalEvaluationsGrade += $value["betterGrade"];
                        if ($value["betterGrade"] < $evaluation->getMinimumGrade()) {
                            $valid = false;
                        } else {
                            $valid = true;
                        }
                        $dtLastEvaluation = $value["lastEvaluation"];
                    }
                }
            }
        }

        $modules = $course->getModules();
        $lastModule = end($modules);
        $lastModuleEvaluation = $em->getRepository("AppBundle:Evaluation")->findByModule($lastModule);
        $lastModuleUserEvaluations = $em->getRepository("AppBundle:UserEvaluation")->findBy(array('evaluation' => $lastModuleEvaluation, 'user' => $this->getUser()));
        $dateFinished = '';
        foreach ($lastModuleUserEvaluations as $userEvaluation) {
            $dateFinished = $userEvaluation->getDtCreation();
        }

        //Faz a verficação se é == 0, pois não é possível realizar divisão por zero.
        if ($valid) {
            $percentual = $totalEvaluationsGrade/($totalEvaluations == 0?1:$totalEvaluations);
            $percentual = number_format($percentual);
        } else {
            $percentual = $totalEvaluationsGrade/($totalEvaluations == 0?1:$totalEvaluations);
            $percentual = number_format($percentual);
        }

        //Busca a última matrícula do usuário para o curso
        $inscription = $this->getInscriptionRepository()->getLastInscriptionByUser($this->getUser(), $course);
        //Busca as aulas assistidas pelo aluno
        $totalUserLessons = $this->getRepositoryFromBase('Course')->getTotalLessonUserCourse($this->getUser(), $course);
        // $course = $this->getRepositoryFromBase('Course')->getLessonsUserCourse($this->getUser(), $course);
        $inscriptionLessons = $this->getInscriptionLessonRepository()->findAllByInscription($inscription, true);
        $totalLessonsConcluded = count($inscriptionLessons);
        if ($totalLessons > 0) {
            $percentualRealizado = ($totalUserLessons*100)/$totalLessons;
        }

        //Obtem a última aula assistida
        $lastInscriptionLesson = end($inscriptionLessons);
        return $this->render('AppBundle:Course:show.info.html.twig', array(
            'percentualRealizado' => $percentualRealizado,
            'lastInscriptionLesson' => $lastInscriptionLesson,
            'percentualNota' => $percentual,
            'totalEvaluationsGrade' => $totalEvaluationsGrade,
            "totalAttempts" => $totalAttempts,
            "dateFinished" => $dtLastEvaluation,
            'totalEvaluations' => $totalEvaluations,
            'course' => $course
        ));
    }

    /**
     * @Route("/{course_id}/info-user-progress", name="course_info_progress")
     */
    public function showCoursesInfoProgressAction($course_id)
    {
        //Carrega o curso atual
        $course = $this->getCourseRepository()->find($course_id);
        //obtem a quantidade de aulas
        $totalLessons = 0;
        $percentualRealizado = 0;
        foreach ($course->getModules() as $module) {
            $totalLessons+=count($module->getLessons());
        }
        //Busca a última matrícula do usuário para o curso
        $inscription = $this->getInscriptionRepository()->getLastInscriptionByUser($this->getUser(), $course);
        //Busca as aulas assistidas pelo aluno
        $inscriptionLessons = $this->getInscriptionLessonRepository()->findAllByInscription($inscription, true);
        $totalLessonsConcluded = count($inscriptionLessons);
        if ($totalLessons > 0) {
            $percentualRealizado = ($totalLessonsConcluded*100)/$totalLessons;
        }
        //Obtem a última aula assistida
        return $this->render('AppBundle:Course:show.info_progress.html.twig', array(
            'percentualRealizado' => $percentualRealizado,
        ));
    }

    /**
     * @Route("/report-info-user/{inscription}", name="course_report_info")
     */
    public function showCoursesReportInfoAction($inscription)
    {
        //Carrega a matrícula
        $inscription = $this->getInscriptionRepository()->find($inscription);
        //Busca todas as aulas assistidas
        $listInscriptionLessons = $this->getInscriptionLessonRepository()->findBy(array("inscription"=>$inscription));
        //Obtem curso
        $course = $inscription->getCourse();
        //Obtem user
        $user = $inscription->getUser();
        //Variável de controle de aulas do curso
        $totalLessons = 0;
        //Variável de controle de avaliações do curso
        $totalEvaluation = 0;
        //Variável de controle de nota
        $nota = 0;
        //Nota mínima para ser aprovado no curso
        $minimumGrade = 0;
        //Percorre todos os módulos
        foreach ($course->getModules() as $module) {
            //Atualiza a varíavel de controle
            $totalLessons+=count($module->getLessons());
        }
        //Busca todas as aulas concluídas
        $listLessonsConcluded = $this->getInscriptionLessonRepository()->findAllByInscription($inscription, true);
        $totalLessonsConcluded = count($listLessonsConcluded);
        /*
        * Lista de status:
        * Não iniciou: nenhuma aula assistida
        * Em andamento: não completou todas as aulas
        * Concluído: completou todas as aulas
        */
        $status = "Não iniciou";
        //Verifica se todas as aulas foram concluídas
        if ($totalLessonsConcluded = $totalLessons) {
            //Percorre todos os módulos
            foreach ($course->getModules() as $module) {
                //Percorre todas as avaliações do módulo
                foreach ($module->getEvaluations() as $evaluation) {
                    //Atualiza a quantidade de avaliações
                    $totalEvaluation++;
                }
            }
        }
        
        //Busca as notas de teste
        $totalAluno = $this->getRepositoryFromBase('UserEvaluation')->getMelhoresNotas($user, $course);
        $countTotalAluno = count($totalAluno);
        $notaAluno = 0;
        if ($countTotalAluno > 0) {
            foreach ($totalAluno as $value) {
                $notaAluno+=$value["betterGrade"];
            }
            $nota = $notaAluno/$countTotalAluno;
        } else {
            $nota = 0;
        }
        
        $lastInscriptionLesson = null;
        //Tratamento para exibição de resultados
        if ($totalEvaluation == 0) {
            $nota = "-";
            if (count($listInscriptionLessons) > 0) {
                if ($totalLessonsConcluded = $totalLessons) {
                    $status = "Concluído";
                    //Obtem a última aula assistida
                    $lastInscriptionLesson = end($listInscriptionLessons);
                } else {
                    $status = "Em andamento";
                }
            }
        } elseif ($totalEvaluation > 0) {
            if ($nota == 0) {
                $nota = " - ";
                if (count($listInscriptionLessons) > 0) {
                    if ($totalLessonsConcluded = $totalLessons) {
                        $status = "Concluído";
                        $lastInscriptionLesson = end($listInscriptionLessons);
                    } else {
                        $status = "Em andamento";
                    }
                } else {
                    $status = "Incompleto";
                }
            } elseif ($nota > 0 && $nota < $minimumGrade) {
                $status = "Reprovado";
            } else {
                $status = "Aprovado";
                $lastInscriptionLesson = end($listInscriptionLessons);
            }
        }

        return $this->render('AppBundle:Course:show.report_info.html.twig', array(
            'status' => $status,
            'nota' => $nota,
            'lastInscriptionLesson' => $lastInscriptionLesson
        ));
    }

    /**
     * @Route("/get-course-by-id", name="get_course_by_id", options={"expose"=true})
     */
    public function getCourseByIdAction()
    {
        try {
            $em = $this->getDoctrine()->getManager();
            $request = Request::createFromGlobals();
            $courseId = $request->query->get('courseId');
            $entity = $em->getRepository('AppBundle:Course')->find($courseId);
            $return = array("responseCode" => 200, 'data' => $entity);
        } catch (\Exception $e) {
            $return = array("responseCode" => 400, 'errorMessage' => $e->getTraceAsString());
        }

        return $this->returnJson($return);
    }

    /**
     * @Route("/{course_id}/outros", name="course_showOthers")
     */
    public function showOtherCoursesAction($course_id)
    {
        $course = $this->getCourseRepository()->find($course_id);
        $courses = $this->getCourseRepository()->findOtherCourses($course);
        return $this->render('AppBundle:Course:show.other-courses.html.twig', array(
            'courses' => $courses,
        ));
    }

    /**
     * @Route("/certificados", name="home_certificate", options={"expose"=true})
     */
    public function certificateAction(Request $request, $concludedIqaCicle = null)
    {
        $user = $this->validUser();

        $client = $this->getClient($user);

        $dataRequest = $request->isMethod('POST') ? $request->request->all() : $request->query->all();
        $em = $this->getDoctrine()->getManager();
        $coursesList = $this->getRepositoryFromBase('Course')->getCoursesFinished($this->getUser());
        $courses = array();
        foreach ($coursesList as $course) {
            if($course->getCertificate()){
                $valid = true;
                //Tratamento para buscar a melhor nota nas avaliações de todos os cursos
                foreach ($course->getModules() as $module) {
                    if (count($module->getEvaluations())>0) {
                        $evaluation = $module->getEvaluations()->get(0);
                        $nota = $this->getRepositoryFromBase('UserEvaluation')->getMelhoresNotas($this->getUser(), null, $evaluation);
                        if (count($nota)>0) {
                            foreach ($nota as $value) {
                                if ($value["betterGrade"] < $evaluation->getMinimumGrade()) {
                                    $valid = false;
                                }
                            }
                        } else {
                            $valid = false;
                        }
                    }
                }
                $totalLessons = $this->getRepositoryFromBase('Course')->getTotalLessonCourse($course);
                $totalUserLessons = $this->getRepositoryFromBase('Course')->getTotalLessonUserCourse($this->getUser(), $course);
                if ($totalUserLessons >= $totalLessons && $valid) {
                    array_push($courses, $course);
                }
            }
        }
        //$courses = $this->getRepositoryFromBase('Course')->findAll();

        if (array_key_exists('finish', $dataRequest) && $dataRequest['finish'] == 'survey_answer') {
            $this->successMessage($request, 'Obrigado por responder nossa pesquisa de satisfação!');
            $course = $this->getRepositoryFromBase('Course')->find($dataRequest['courseId']);
            $conclusionLink = $course->getConclusionLink();
            if (!empty($conclusionLink)) {
                if (filter_var($conclusionLink, FILTER_VALIDATE_URL)) { 
                    return $this->redirect($conclusionLink);
                }else{
                    return $this->redirect("http://".$conclusionLink);
                }
            }
        }

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $courses,
            $this->get('request')->query->get('page', 1),
            20
        );

        return $this->render('AppBundle:Course:certificate.html.twig', array(
            'pagination' => $pagination,
            'client' => $client,
            'concludedIqaCicle' => array_key_exists('concludedIqaCicle', $dataRequest) ? $dataRequest['concludedIqaCicle'] : ""
        ));
    }

    /**
     * @Route("/cursos-em-andamento", name="course_opened")
     */
    public function coursesOpenedAction()
    {
        $user = $this->validUser();

        $client = $this->getClient($user);

        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('AppBundle:Course')->getCoursesNotFinished($this->getUser());

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $entities,
            $this->get('request')->query->get('page', 1),
            20
        );

        return $this->render('AppBundle:Course:opened-courses.html.twig', array(
            'pagination' => $pagination,
            'client' => $client
        ));
    }

    /**
     * @Route("/cursos-concluidos", name="course_closed")
     */
    public function coursesClosedOpenedAction()
    {
        $user = $this->validUser();

        $client = $this->getClient($user);
        $em = $this->getDoctrine()->getManager();
        $coursesList = $this->getRepositoryFromBase('Course')->getCoursesFinished($this->getUser());
        $courses = array();
        foreach ($coursesList as $course) {
            $totalLessons = $this->getRepositoryFromBase('Course')->getTotalLessonCourse($course);
            $totalUserLessons = $this->getRepositoryFromBase('Course')->getTotalLessonUserCourse($this->getUser(), $course);
            if ($totalUserLessons >= $totalLessons) {
                array_push($courses, $course);
            }
        }
        //$courses = $this->getRepositoryFromBase('Course')->findAll();

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $courses,
            $this->get('request')->query->get('page', 1),
            20
        );

        return $this->render('AppBundle:Course:closed-courses.html.twig', array(
            'pagination' => $pagination,
            'client' => $client
        ));
    }

    /**
     * @Route("/provas-em-aberto", name="course_opened_evaluations")
     */
    public function coursesOpenedEvaluationsAction()
    {
        $user = $this->validUser();

        $client = $this->getClient($user);
        $em = $this->getDoctrine()->getManager();
        $inscriptionStatusAprovado = $em->getReference('AppBundle:InscriptionStatus', InscriptionStatus::APROVADO);
        $coursesList = $this->getRepositoryFromBase('Course')->getInscritiptionCourse($this->getUser(), $inscriptionStatusAprovado, true);
        $courses = array();
        foreach ($coursesList as $course) {
            if($course->getModality() == 'EAD'){
                foreach ($course->getModules() as $module) {
                    if (count($module->getEvaluations())>0) {
                        $userEvaluation = $this->getRepositoryFromBase('UserEvaluation')->findBy(array(
                            "user" => $this->getUser(),
                            "evaluation" => $module->getEvaluations()->get(0),
                        ));
                        if ($userEvaluation == null) {
                            array_push($courses, $course);
                            break;
                        }
                    }
                }
            }
        }

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $courses,
            $this->get('request')->query->get('page', 1),
            20
        );

        return $this->render('AppBundle:Course:opened-evaluation-courses.html.twig', array(
            'pagination' => $pagination,
            'client' => $client
        ));
    }

    /**
     * @Route("/cursos", name="courses_index")
     */
    public function coursesAction(Request $request)
    {
        $user = $this->validUser();

        $client = $this->getClient($user);

        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('AppBundle:Course')->findAvailableCourses($user);

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $entities,
            $this->get('request')->query->get('page', 1),
            20
        );

        return $this->render('AppBundle:Course:all-courses.html.twig', array(
            'pagination' => $pagination,
            'client' => $client
        ));
    }

    /**
     * @Route("/favoritos", name="home_favorite")
     */
    public function favoriteAction(Request $request)
    {
        $user = $this->validUser();

        $client = $this->getClient($user);

        $em = $this->getDoctrine()->getManager();

        $coursesUserFavorited = $em->getRepository('AppBundle:FavCourse')->findBy(array(
            'user' => $user,
        ));

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $coursesUserFavorited,
            $this->get('request')->query->get('page', 1),
            20
        );

        //$entities = $em->getRepository('AppBundle:Course')->findAll();
        return $this->render('AppBundle:Course:favorite.html.twig', array(
            'pagination' => $pagination,
            'client' => $client
        ));
    }

    /**
     * @Route("/concluir-cursos/{courseId}", name="course_conclusion")
     */
    public function courseConclusionAction(Request $request, $courseId)
    {
        $user = $this->getUser();
        $course = $this->getCourseRepository()->find($courseId);
        if ($course == null) {
            throw $this->createNotFoundException('Curso não encontrado');
        }
        if (!$inscription = $this->getInscriptionRepository()->getLastInscriptionByUser($user, $course)) {
            // if($course->getAutoInscription()){
            //     return $this->redirectToRoute('course_company_subscribe', array("slug" => $course->getSlug()));
            // }else{
            throw $this->createNotFoundException('Usuário não matriculado.');
            // }
        }

        $concludedLessons = $inscriptionLessons = $this->getInscriptionLessonRepository()->findAllByInscription($inscription, true);

        if($course->getTotalLessons() == count($concludedLessons)){
            $userEvaluation = $this->getUserEvaluationRepository()->findOneBy(array('user' => $user, 'course' => $course));
            if (!$userEvaluation && $course->getTotalEvaluations() == 0) {
                $em = $this->getDoctrine()->getManager();
                $userEvaluation = new UserEvaluation();
                $userEvaluation->setUser($user);
                $userEvaluation->setCourse($course);
                $userEvaluation->setGrade(100);
                $userEvaluation->setApproved(true);
                $em->persist($userEvaluation);
                $em->flush();
            }
    
            if ($course->getSurvey()) {
                $survey = $course->getSurvey();
                $surveyAnswer = $this->getSurveyAnswerRepository()->findBy(array(
                    "user" => $user,
                    "course" => $course,
                    "survey" => $survey
                ));
    
                if (!$surveyAnswer) {
                    $showPopup = $this->showIqaCicleConclusion();
                    $this->successMessage($request, 'Você concluiu o curso '.$course->getTitle());
                    return $this->redirect($this->generateUrl('survey_show', array('course_id' => $course->getId(), 'concludedIqaCicle' => $showPopup)));
                }
            }
    
            return $this->redirectToRoute('course_finish', array(
                'courseId' => $course->getId()
            ));
        }else{
            return $this->redirectToRoute('course_start', array(
                'id' => $course->getId(),
            ));
        }
    }

    /**
     * @Route("/finalizar-curso/{courseId}", name="course_finish")
     */
    public function finishCourseAction($courseId)
    {
        $em = $this->getDoctrine()->getManager();
        try {
            // $em = $this->getDoctrine()->getManager();
            $user = $this->getUser();

            $courseService = $this->container->get('course.service');

            $courseService->createIntegrationFromFinishCourse($courseId, $user);
        } catch (\Exception $e) {
            $this->log($e);
        }
        $course = $this->getCourseRepository()->find($courseId);
        if ($course == null) {
            throw $this->createNotFoundException('Curso não encontrado');
        }
        
        $conclusionLink = $course->getConclusionLink();
        if (!empty($conclusionLink)) {
            if (filter_var($conclusionLink, FILTER_VALIDATE_URL)) { 
                return $this->redirect($conclusionLink);
            }else{
                return $this->redirect("http://".$conclusionLink);
            }
        }

        $showPopup = $this->showIqaCicleConclusion();
        
        return $this->redirectToRoute('home_certificate', array('concludedIqaCicle' => $showPopup));
    }

    /**
     * @Route("/{slug}", name="course_show")
     */
    public function showAction(Request $request, $slug)
    {
        $this->validUser();
        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();

        $entity = new CommentCourse();
        $form = $this->createCreateForm($entity, $slug);
        $form->handleRequest($request);

        $course = $this->getCourseRepository()->findOneBySlug($slug);
        if ($course == null) {
            throw $this->createNotFoundException('Curso não encontrado');
        }

        $inscription = null;
        if ($user != null) {
            $inscription = $this->getInscriptionRepository()->getLastInscriptionByUser($user, $course);
        }

        $idVideoDesgustacao = $course->getIdMediaDegustacao();
        $player = '';

        if (!empty($idVideoDesgustacao)) {
            $media = $this->get("samba.videos.videos")->getMedia($idVideoDesgustacao);
            $player = $this->get("samba.videos.videos")->getPlayer($media);
        }

        $aprovado = $em->getReference('AppBundle:InscriptionStatus', InscriptionStatus::APROVADO);

        $courseFavorited = $em->getRepository('AppBundle:FavCourse')->findBy(array(
            'user' => $user->getId(),
            'course' => $course->getId()
        ));

        $courseLiked = $em->getRepository('AppBundle:LikeCourse')->findBy(array(
            'user' => $user->getId(),
            'course' => $course->getId()
        ));

        $courseLikes = $em->getRepository('AppBundle:LikeCourse')->findBy(array(
            'course' => $course->getId()
        ));

        // $linkExternal = $course->getLinkTrailExternal();

        // if (!empty($linkExternal)) {
        //     header("Location: " + $linkExternal);
        //     exit();
        // }

        return $this->render('AppBundle:Course:show.html.twig', array(
            'course' => $course,
            'inscription' => $inscription,
            'player' => $player,
            'form' => $form->createView(),
            'totalMatriculados' => $this->getInscriptionRepository()->getCountInscriptions($course, $aprovado),
            'slug' => $slug,
            'courseFavorited' => $courseFavorited,
            'courseLiked' => $courseLiked,
            'courseLikes' => $courseLikes
        ));
    }

    /**
     * Favoritar Curso
     * @Route("/{slug}/{course_id}/favorite", name="course_favorite", options={"expose"=true})
     */
    public function favoriteCourseAction($slug, $course_id)
    {
        try {
            $em = $this->getDoctrine()->getManager();
            $user = $this->getUser();
            $course = $this->getCourseRepository()->find($course_id);

            if (!$course) {
                throw new \Exception('Curso não encontrado.');
            }

            $favCourse = new FavCourse();
            $favCourse->setUser($user);
            $favCourse->setCourse($course);

            $em->persist($favCourse);
            $em->flush();

            return $this->redirectToRoute('course_start', array(
                'id' => $course->getId(),
            ));
        } catch (Exception $e) {
            throw new \Exception('Houve um erro inesperado, tente novamente mais tarde.');
        }
    }

    /**
     * Like do Curso
     * @Route("/{slug}/{course_id}/like", name="course_like", options={"expose"=true})
     */
    public function likeCourseAction($slug, $course_id)
    {
        try {
            $em = $this->getDoctrine()->getManager();
            $user = $this->getUser();
            $course = $this->getCourseRepository()->find($course_id);

            if (!$course) {
                throw new \Exception('Curso não encontrado.');
            }

            $likeCourse = new LikeCourse();
            $likeCourse->setUser($user);
            $likeCourse->setCourse($course);

            $em->persist($likeCourse);
            $em->flush();

            return $this->redirectToRoute('course_start', array(
                'id' => $course->getId(),
            ));
        } catch (Exception $e) {
            throw new \Exception('Houve um erro inesperado, tente novamente mais tarde.');
        }
    }

    /**
     * Inicia o curso redirecionando para a primeira aula.
     * @Route("/{id}/iniciar", name="course_start")
     */
    public function startAction(Request $request, $id)
    {
        $this->validUser();
        if (!$course = $this->getCourseRepository()->find($id)) {
            throw new \Exception('Curso não encontrado.');
        }
        $module = $this->getModuleRepository()->findFirstByCourse($course);
        $lesson = $this->getLessonRepository()->findFirstByModule($module);
        if ($module==null || $lesson==null) {
            $request->getSession()
                 ->getFlashBag()
                 ->add('warning', 'Não é possível assistir este curso. Entre em contato com o administrador!');
            return $this->redirectToRoute('courses_index');
        }
        return $this->redirectToRoute('lesson_show', array('courseId' => $course->getId(), 'id' => $lesson->getId()));
    }

    /**
     * Inicia o curso redirecionando para a primeira aula.
     * @Route("/curso/alterar-modulo/{moduleId}", name="course_change_module")
     */
    public function changeModuleAction(Request $request, $moduleId)
    {
        $this->validUser();
        if (!$module = $this->getModuleRepository()->find($moduleId)) {
            throw new \Exception('Módulo não encontrado.');
        }
        $lesson = $this->getLessonRepository()->findFirstByModule($module);
        return $this->redirectToRoute('lesson_show', array('courseId' => $module->getCourse()->getId(), 'id' => $lesson->getId()));
    }

    /**
     * Exibe a tela de participação no curso, com as aulas já vistas e a serem concluídas.
     * @Route("/{id}/aulas", name="course_lessons")
     */
    public function lessonsAction(Request $request, $id)
    {
        if (!$course = $this->getCourseRepository()->find($id)) {
            throw new \Exception('Curso não encontrado.');
        }
        $lessons = $this->getLessonRepository()->findByCourse($course);
        return $this->render(
            'AppBundle:Course:lessons.html.twig',
            array('lessons' => $lessons)
        );
    }

    /**
    * Creates a form to edit a CommentCourse entity.
    *
    * @param CommentCourse $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditForm(CommentCourse $entity, $slug)
    {
        $courseType = new CommentCourseType();
        $form = $this->createForm($courseType, $entity, array(
            'action' => $this->generateUrl('course_comment_create', array('slug' => $slug)),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }

    /**
     * Creates a form to create a Client entity.
     *
     * @param Client $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(CommentCourse $entity, $slug)
    {
        $form = $this->createForm(new CommentCourseType(), $entity, array(
            'action' => $this->generateUrl('course_comment_create', array('slug' => $slug)),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
     * Feedback Course
     *
     * @Route("/feedback/{course_id}/aula/{lesson_id}", name="course_feedback")
     */
    public function feedbackAction(Request $request, $course_id, $lesson_id)
    {
        $em = $this->getDoctrine()->getManager();
        $courseFeedback = new CourseFeedback();
        $em = $this->getDoctrine()->getManager();
        $course = $em->getRepository('AppBundle:Course')->find($course_id);
        $lesson = $em->getRepository('AppBundle:Lesson')->find($lesson_id);
        $form = $this->createForm('AppBundle\Form\CourseFeedbackType', $courseFeedback);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $course = $em->getRepository('AppBundle:Course')->find($course_id);
            $courseFeedback->setCourse($course);
            $courseFeedback->setChecked(false);

            $em->persist($courseFeedback);
            $em->flush();

            $request->getSession()->getFlashBag()->add('success', "Feedback enviado com sucesso.");

            return $this->redirectToRoute('lesson_show', array(
                'courseId' => $course_id,
                'id' => $lesson_id
            ));
        }

        $lesson = $em->getRepository('AppBundle:Lesson')->find($lesson_id);

        return $this->render('AppBundle:CourseFeedback:index.html.twig', array(
            'lesson' => $lesson,
            'courseFeedback' => $courseFeedback,
            'lesson' => $lesson,
            'form' => $form->createView(),
        ));
    }
}
