<?php

namespace AppBundle\Controller;

use AppBundle\Entity\CourseFeedback;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;

/**
 * Coursefeedback controller.
 *
 * @Route("coursefeedback")
 */
class CourseFeedbackController extends Controller
{
    /**
     * Lists all courseFeedback entities.
     *
     * @Route("/", name="coursefeedback_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $courseFeedbacks = $em->getRepository('AppBundle:CourseFeedback')->findAll();

        return $this->render('coursefeedback/index.html.twig', array(
            'courseFeedbacks' => $courseFeedbacks,
        ));
    }

    /**
     * Creates a new courseFeedback entity.
     *
     * @Route("/new", name="coursefeedback_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $courseFeedback = new Coursefeedback();
        $form = $this->createForm('AppBundle\Form\CourseFeedbackType', $courseFeedback);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($courseFeedback);
            $em->flush();

            return $this->redirectToRoute('coursefeedback_show', array('id' => $courseFeedback->getId()));
        }

        return $this->render('coursefeedback/new.html.twig', array(
            'courseFeedback' => $courseFeedback,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a courseFeedback entity.
     *
     * @Route("/{id}", name="coursefeedback_show")
     * @Method("GET")
     */
    public function showAction(CourseFeedback $courseFeedback)
    {
        $deleteForm = $this->createDeleteForm($courseFeedback);

        return $this->render('coursefeedback/show.html.twig', array(
            'courseFeedback' => $courseFeedback,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing courseFeedback entity.
     *
     * @Route("/{id}/edit", name="coursefeedback_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, CourseFeedback $courseFeedback)
    {
        $deleteForm = $this->createDeleteForm($courseFeedback);
        $editForm = $this->createForm('AppBundle\Form\CourseFeedbackType', $courseFeedback);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('coursefeedback_edit', array('id' => $courseFeedback->getId()));
        }

        return $this->render('coursefeedback/edit.html.twig', array(
            'courseFeedback' => $courseFeedback,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a courseFeedback entity.
     *
     * @Route("/{id}", name="coursefeedback_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, CourseFeedback $courseFeedback)
    {
        $form = $this->createDeleteForm($courseFeedback);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($courseFeedback);
            $em->flush();
        }

        return $this->redirectToRoute('coursefeedback_index');
    }

    /**
     * Creates a form to delete a courseFeedback entity.
     *
     * @param CourseFeedback $courseFeedback The courseFeedback entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(CourseFeedback $courseFeedback)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('coursefeedback_delete', array('id' => $courseFeedback->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
