<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\RedirectResponse;
use AppBundle\Entity\Inscription;
use AppBundle\Entity\InscriptionStatus;
use AppBundle\Entity\Payment;
use AppBundle\Entity\PaymentStatus;

/**
 * Painel do usuário.
 * @Route("/painel")
 */
class DashboardController extends BaseController {

    /**
     * @Route("/", name="dashboard_index")
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $inscriptionStatusAprovado = $em->getReference('AppBundle:InscriptionStatus', InscriptionStatus::APROVADO);
        $courses = $this->getCourseRepository()->getInscritiptionCourse($this->getUser(), $inscriptionStatusAprovado);

        return $this->render('AppBundle:Dashboard:index.html.twig',
            array(
                    'courses' => $courses,
                    'data' => $this->getDataPorExtenso(),
                    'usuario' => $this->getUser(),
                )
        );
    }

    /**
     * @Route("/meus-certificados", name="dashboard_meus_certificados")
     **/
    public function certificadosAction()
    {
        $em = $this->getDoctrine()->getManager();
        // $courses = $this->getCourseRepository()->getCoursesFinished($this->getUser());
        // Cursos que necessitam aprovação
        $courses1 = $this->getRepositoryFromBase('Course')->findCourseAprovedAnswer($this->getUser());
        // Cursos que não necessitam aprovação
        $courses2 = $this->getRepositoryFromBase('Course')->getCoursesFinished($this->getUser());

        $courses = array_merge($courses1, $courses2);


        return $this->render('AppBundle:Dashboard:certificados.html.twig',
            array(
                    'courses' => $courses,
                    'data' => $this->getDataPorExtenso(),
                    'usuario' => $this->getUser(),
                )
        );
    }

    /**
     * @Route("/termos-de-uso", name="dashboard_download_termos_uso")
     * */
    public function downloadTermosUsuAction()
    {

        $html = $this->renderView('AppBundle:Dashboard:termos-uso-download.html.twig');
        $dompdf = $this->get('slik_dompdf');
        $dompdf->getpdf($html, 'portrait');
        $dompdf->stream("Enlab - Termos e Condições de Uso.pdf");
        $pdfoutput = $dompdf->output();
    }
}
