<?php

namespace AppBundle\Controller;

use JMS\Serializer\SerializerBuilder;
use Symfony\Component\HttpFoundation\Request;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Response;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use AppBundle\Entity\Inscription;
use AppBundle\Entity\Payment;
use AppBundle\Entity\Client;
use AppBundle\Entity\JobRole;
use AppBundle\Entity\Sector;
use AppBundle\Entity\Lead;
use AppBundle\Entity\Topic;
use AppBundle\Entity\Message;
use UserBundle\Entity\User;
use AppBundle\Entity\UserStatus;
use AppBundle\Entity\Contact;
use AppBundle\Entity\IndiqueCursos;
use AppBundle\Entity\OrcamentoContato;
use AppBundle\Entity\InscriptionStatus;
use AppBundle\Entity\MediaType;
use AppBundle\Entity\IqaLog;
use AppBundle\Form\ClientType;
use AppBundle\Form\ContactType;
use AppBundle\Form\OrcamentoContatoType;
use AppBundle\Form\IndiqueCursosType;
use AppBundle\Form\MessageType;

class HomeController extends BaseController
{

    /**
     * @Route("/seguro/{json}", name="home_security")
     */
    public function homeSecurityAction(Request $request, $json = null)
    {
        // $json = '{"Login":["uni15851"],"Cargo":["ANL TECNOL INFORMACAO PL"],"Status":["Active"],"Email":["wilmar.santos@unimedbh.com.br"],"Matricula":["15851"],"Nome":["Wilmar Francisco dos Santos (GTIN)","Wilmar Francisco dos Santos"],"NumeroEmpresa":["1"]}';
        //$json = json_encode($json);
        $goto = isset($_GET['goto']) ? $_GET['goto'] : null;
        $user  = $this->validUser($json);
        if (empty($user)) {
            // $user  = $this->validUser($json);
            return $this->render('AppBundle:Home:authenticate.html.twig', array());
        //throw $this->createAccessDeniedException();
        } else {
            //Validate if user has completed the iqa
            $token = new UsernamePasswordToken($user, null, 'homepage', array('ROLE_USER'));
            $this->get('security.token_storage')->setToken($token);
            $showPopup = $this->showIqaCicleConclusion();
            if(is_null($goto)){
                return $this->redirectToRoute('homepage');
            }else{
                return $this->redirect($goto);
            }
            
        }
    }

    /**
     * @Route("/teste-seguro", name="home_testesecurity")
     */
    public function homeTesteSecurityAction(Request $request)
    {
        // $json = '{"baseurlpath":"simplesaml\/","header":"{status:header_saml20_sp}","attributes":{"Gestao":["COOP - Coorperados"],"Status":["Active"],"Cargo":["Pediatria"],"Email":["paulo_edumac@yahoo.com.br"],"NumeroLocal":["2.01.01.01"],"Matricula":["43990"],"Login":["crm43990"],"NumeroEmpresa":["3"],"LocalTrabalho":["COOPERADOS"],"Grupo":["CLAUSU.PERFIL_TELESSAUDE","SIST_GESTAO_IUBH.PERFIL_COOPERADO","OUTSYS_TELESSAUDE.PERFIL_MEDICOESPECIALISTA","CLAUSU.PERFIL_MEDICO_COOPERADO"],"TipoEmpregado":["1"],"Nome":["Paulo Eduardo Machado Filho (MED)","Paulo Eduardo Machado Filho"]},"nameid":{"Format":"urn:oasis:names:tc:SAML:2.0:nameid-format:transient","SPProvidedID":null,"value":"VnhGydf7MeMzvp3LtVITf8hHi3Xh","NameQualifier":"UnimedBHIdP","SPNameQualifier":"https:\/\/lmssambatech.com.br\/simplesaml\/module.php\/saml\/sp\/metadata.php\/lmssambatech","element":{}},"logouturl":"http:\/\/hml.lmssambatech.com.br\/simplesaml\/module.php\/core\/authenticate.php?as=lmssambatech&logout"}';
        $json = '{"baseurlpath":"simplesaml\/","header":"{status:header_saml20_sp}","attributes":{"Gestao":["COOP - Coorperados"],"Status":["Active"],"Cargo":["Ortopedia e Traumatologia"],"NumeroLocal":["2.01.01.01"],"Matricula":["40597"],"Login":["crm40597"],"NumeroEmpresa":["3"],"LocalTrabalho":["COOPERADOS"],"Grupo":["CLAUSU.PERFIL_TELESSAUDE","SIST_GESTAO_IUBH.PERFIL_COOPERADO","OUTSYS_TELESSAUDE.PERFIL_MEDICOESPECIALISTA","CLAUSU.PERFIL_MEDICO_COOPERADO"],"TipoEmpregado":["1"],"Nome":["Andre Lopes Portugal (HUBH - MED)","Andre Lopes Portugal"]},"nameid":{"Format":"urn:oasis:names:tc:SAML:2.0:nameid-format:transient","SPProvidedID":null,"value":"t7LEQA1h2efL3sFScNnxpB1H0wtl","NameQualifier":"UnimedBHIdP","SPNameQualifier":"https:\/\/lmssambatech.com.br\/simplesaml\/module.php\/saml\/sp\/metadata.php\/lmssambatech","element":{}},"logouturl":"http:\/\/hml.lmssambatech.com.br\/simplesaml\/module.php\/core\/authenticate.php?as=lmssambatech&logout"}';
        $json = json_decode($json, true);
        $string = $json['attributes'];
        return $this->redirectToRoute('home_security', array(
            'json' => urlencode(json_encode($string)),
        ));
    }

    /**
     * @Route("/", name="homepage")
     */
    public function indexAction(Request $request)
    {
        $user = $this->validUser();

        $client = $this->getClient($user);

        $em = $this->getDoctrine()->getManager();
        $inscriptionStatusAprovado = $em->getReference('AppBundle:InscriptionStatus', InscriptionStatus::APROVADO);

        $entities = $this->getCourseRepository()->getInscritiptionCourse($this->getUser(), $inscriptionStatusAprovado);
        $entitiesHighlight = $this->getCourseRepository()->getOnlyNotEnrolled($this->getUser(), $inscriptionStatusAprovado);

        $coursesModalityPresencial = $this->getCourseRepository()->findBy(array(
            'modality' => 'Presencial',
            'active' => '1'
        ));

        $listNews = $this->getPostRepository()->findForHome();

        $testimonials = $this->getTestimonialRepository()->findActive();

        $bannersHome = array();
        $entitiesBanner = $em->getRepository('AppBundle:Banner')->findForHome($client);

        if (!$this->get('security.authorization_checker')->isGranted('ROLE_SUPER_ADMIN')) {
            foreach ($entitiesBanner as $bannerItem) {
                $bannerFilter = $bannerItem->getBannerFilter();
                if ($bannerFilter) {
                    $sectors = $this->getIdCollectionItens($bannerFilter->getSectors());
                    $jobRoles = $this->getIdCollectionItens($bannerFilter->getJobRoles());
                    $managements = $this->getIdCollectionItens($bannerFilter->getManagements());

                    if ($this->checkPropertyInCollection($client->getSector(), $sectors)
                        && $this->checkPropertyInCollection($client->getJobRole(), $jobRoles)
                        && $this->checkPropertyInCollection($client->getManagement(), $managements)
                        && (empty($bannerItem->getNumEmp()) || $client->getNumEnterprise() == $bannerItem->getNumEmp())) {
                        array_push($bannersHome, $bannerItem);
                    }
                }
            }
            $entitiesBanner = $bannersHome;
        }

        return $this->render('AppBundle:Home:index.html.twig', array(
            'entitiesHighlight' => $entitiesHighlight,
            'entities' => $entities,
            'entitiesBanner' => $entitiesBanner,
            'testimonials' => $testimonials,
            'client' => $client,
            'coursesModalityPresencial' => $coursesModalityPresencial,
            'listNews' => $listNews,

        ));
    }

    public function checkPropertyInCollection($entity, $collectionEntity)
    {
        if (!$collectionEntity || count($collectionEntity) == 0) {
            return true;
        }

        return ($entity && $entity->getId() && in_array($entity->getId(), $collectionEntity));
    }

    /**
     * @Route("/historico", name="home_historic")
     */
    public function historicAction(Request $request)
    {
        $this->validUser();
        $em = $this->getDoctrine()->getManager();
        $inscriptions = $em->getRepository('AppBundle:Inscription')->findByUser($this->getUser());
        $coursesList = $this->getRepositoryFromBase('Course')->getCoursesFinished($this->getUser());
        $completed = array();
        foreach ($coursesList as $course) {
            $totalLessons = $this->getRepositoryFromBase('Course')->getTotalLessonCourse($course);
            $totalUserLessons = $this->getRepositoryFromBase('Course')->getTotalLessonUserCourse($this->getUser(), $course);
            if ($totalLessons == $totalUserLessons) {
                array_push($completed, $course);
            }
        }

        //Buscar a média de notas geral
        $totalGeral = $this->getRepositoryFromBase('UserEvaluation')->getMelhoresNotas();
        $countTotalGeral = count($totalGeral);
        $notaGeral = 0;
        if ($countTotalGeral > 0) {
            foreach ($totalGeral as $value) {
                $notaGeral+=$value["betterGrade"];
            }
            $geral = $notaGeral/$countTotalGeral;
        } else {
            $geral = 0;
        }

        //Busca as notas de teste
        $totalAluno = $this->getRepositoryFromBase('UserEvaluation')->getMelhoresNotas($this->getUser());
        $countTotalAluno = count($totalAluno);
        $notaAluno = 0;

        if ($countTotalGeral > 0) {
            foreach ($totalAluno as $value) {
                $notaAluno += $value["betterGrade"];
            }
            if ($countTotalAluno>0) {
                $total = $notaAluno/$countTotalAluno;
            } else {
                $total = 0;
            }
        } else {
            $total = 0;
        }

        return $this->render(
            'AppBundle:Home:historic.html.twig',
            array(
                'inscriptions' => $inscriptions,
                'completed' => $completed,
                'notasGerais' => $geral,
                'notasAluno' => $total,
            )
        );
    }

    /**
     * @Route("/historico/{course_id}/notas-info-user", name="historic_notas_info")
     */
    public function showNotasInfoAction($course_id)
    {
        //Carrega o curso atual
        $course = $this->getCourseRepository()->find($course_id);

        //Buscar a média de notas geral
        $totalGeral = $this->getRepositoryFromBase('UserEvaluation')->getMelhoresNotas(null, $course);
        $countTotalGeral = count($totalGeral);
        $notaGeral = 0;
        if ($countTotalGeral > 0) {
            foreach ($totalGeral as $value) {
                $notaGeral+=$value["betterGrade"];
            }
            $geral = $notaGeral/$countTotalGeral;
        } else {
            $geral = 0;
        }

        //Busca as notas de teste
        $totalAluno = $this->getRepositoryFromBase('UserEvaluation')->getMelhoresNotas($this->getUser(), $course);
        // $tentativas = $this->getRepositoryFromBase('UserEvaluation')->getTentativas($this->getUser(), $course);
        $countTotalAluno = count($totalAluno);
        $notaAluno = 0;
        if ($countTotalGeral > 0 && $countTotalAluno > 0) {
            foreach ($totalAluno as $value) {
                $notaAluno+=$value["betterGrade"];
            }
            $total = $notaAluno/$countTotalAluno;
        } else {
            $total = 0;
        }
        $tentativas = 0;
        $modules = $course->getModules();
        if (!$modules->isEmpty()) {
            $tentativas = 1;
            $lastModule = $modules->last();
            if (count($lastModule->getEvaluations())>0) {
                $evaluation = $lastModule->getEvaluations()->get(0);
                $userEvaluations = $this->getUserEvaluationRepository()->findBy(array(
                    "user" => $this->getUser(),
                    "evaluation" => $evaluation,
                ));
                $tentativas = count($userEvaluations);
            }
        }

        return $this->render('AppBundle:Home:historic.notas.html.twig', array(
            'notasGerais' => $geral,
            'notasAluno' => $total,
            'tentativas' => $tentativas,
            'course' => $course
        ));
    }

    /**
     * @Route("/politica-de-uso", name="home_politic")
     */
    public function politicAction(Request $request)
    {
        $this->validUser();
        return $this->render('AppBundle:Home:politic.html.twig', array(
        ));
    }


    /**
     * @Route("/avaliacao", name="home_question")
     */
    public function questionAction(Request $request)
    {
        $this->validUser();
        return $this->render('AppBundle:Home:question.html.twig', array());
    }

    /**
     * @Route("/forum", name="home_forum")
     * @Template("AppBundle:Home:forum.html.twig")
     */
    public function forumAction(Request $request)
    {
        $this->validUser();
        $em = $this->getDoctrine()->getManager();
        $entities = $em->getRepository('AppBundle:Theme')->findAll();

        return array(
          'entities' => $entities,
        );
    }

    /**
     * @Route("/forum/theme/{theme_id}", name="home_forum_theme")
     * @Template("AppBundle:Home:forum.html.twig")
     */
    public function forumThemeAction(Request $request, $theme_id)
    {
        $this->validUser();
        $em = $this->getDoctrine()->getManager();
        $theme = $em->getRepository('AppBundle:Theme')->find($theme_id);
        $entities = $theme->getTopics();

        return array(
            'theme' => $theme,
            'entities' => $entities,
        );
    }

    /**
     * @Route("/forum/theme/{theme_id}/topic/{topic_id}", name="home_forum_topic")
     * @Template("AppBundle:Home:forum.message.html.twig")
     */
    public function forumTopicAction(Request $request, $theme_id, $topic_id)
    {
        $this->validUser();
        $em = $this->getDoctrine()->getManager();
        $topic = $em->getRepository('AppBundle:Topic')->find($theme_id);
        $entities = $topic->getMessages();

        $entity = new Message();
        $em = $this->getDoctrine()->getManager();

        $form = $this->createMessageForm($entity, $topic_id);
        $form->handleRequest($request);

        if ($request->isMethod('POST') || $request->isMethod('PUT')) {
            $topic = $em->getRepository('AppBundle:Topic')->find($topic_id);
            $entity->setTopic($topic);

            if (!$topic) {
                throw $this->createNotFoundException('Topico nÃ£o encontrado.');
            }

            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('home_forum_topic', array(
                'theme_id' => $theme_id,
                'topic_id' => $topic_id
            )));
        }

        return array(
            'form'   => $form->createView(),
            'theme_id' => $theme_id,
            'topic' => $topic,
            'entities' => $entities,
        );
    }

    /**
     * @Route("/chat", name="home_chat")
     */
    public function chatAction(Request $request)
    {
        $this->validUser();
        return $this->render('AppBundle:Home:chat.html.twig', array(
        ));
    }

    /**
     * @Route("/termos-de-uso", name="home_terms")
     */
    public function termsAction(Request $request)
    {
        $this->validUser();
        return $this->render('AppBundle:Home:terms.html.twig', array(
        ));
    }

    /**
     * @Route("/entre-em-contato", name="home_more_contact")
     */
    public function moreContactAction(Request $request)
    {
        $this->validUser();
        $entity = new Contact();
        $form = $this->createContactForm($entity);
        return $this->render('AppBundle:Contact:contact.html.twig', array(
          'form' => $form->createView()
        ));
    }

    /**
     * @Route("/teste_certificado", name="home_test_certificado")
     */
    public function testeCertificadoAction(Request $request)
    {
        $this->validUser();
        return $this->redirect($this->generateUrl('gerar_certificado_pdf', array('id' => 24)));
    }


    /**
     * @Route("/profile", name="fos_user_profile_show")
     */
    public function userProfileAction(Request $request)
    {
        $this->validUser();
        return $this->redirect($this->generateUrl('dashboard_index'));
    }

    /**
     * Creates a form to create a Message entity.
     *
     * @param Message $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createMessageForm(Message $entity, $topic_id)
    {
        $form = $this->createForm(new MessageType(), $entity, array(
            'action' => $this->generateUrl('backend_message_new', array(
                'topic_id' => $topic_id
            )),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /*
    * Cria form para cadastro de indicaÃ§Ã£o de cursos
    *
    */
    private function createContactForm(Contact $entity)
    {
        $form = $this->createForm(new ContactType(), $entity, array(
           'action' => $this->generateUrl('send_contact'),
           'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
     * @Route("/contact/send", name="send_contact")
     * @Method("POST")
     * @Template("AppBundle:Contact:contact.html.twig")
     */
    public function createSendContactAction(Request $request)
    {
        $this->validUser();
        $entity = new Contact();
        $form = $this->createContactForm($entity);
        $form->handleRequest($request);

        if ($form->isValid()) {
            try {
                $em = $this->getDoctrine()->getManager();
                $em->persist($entity);
                $em->flush();

                $message = \Swift_Message::newInstance()
                 ->setSubject("Contato enviado pelo site - Dúvidas")
                 ->setFrom("no-reply@lmssambatech.com.br")
                //  ->setTo("universidadeunimedbh@gmail.com")
                ->setTo("universidadecorporativa@unimedbh.com.br")
                 ->setBody(
<<<EOF
{$entity->getType()} - Contato enviado pelo site:

Nome: {$entity->getName()}
E-mail: {$entity->getEmail()}
Telefone: {$entity->getPhone()}
Assunto: {$entity->getSubject()}
Mensagem: {$entity->getMessage()}

EOF
);
                $this->get('mailer')->send($message);

                $request->getSession()->getFlashBag()->add('success', "Mensagem enviada com sucesso.");

                return $this->redirect($this->generateUrl('home_more_contact'));
            } catch (\Exception $e) {
                $this->log($e);
                $request->getSession()->getFlashBag()->add('error', 'Ocorreu algum erro inesperado. Tente novamente mais tarde!');
            }
        }

        return array(
           'entity' => $entity,
           'form'   => $form->createView(),
        );
    }

    /**
     * @Route("/home/iqa-cicle/popup", name="iqa-cicle-popup")
     */
    public function iqaCiclePopup()
    {
        if($this->getUser()){
            $this->log("!!!!");
            $this->log("HOMECONTROLLER: iqaCiclePopup");
            $this->log($this->getUser()->getId());
            $em = $this->getDoctrine()->getManager();
            //Variáveis para controle do modal
            $showModal = 0;
            $show100Modal = 0;
            $lmsAssistidos = 0;
            $podcastAssistidos = 0;
            $videosAssistidos = 0;
            $lmsPendente = false;
            $mediaCenterPendente = false;
            $modalMessage = "";
            $obrigatorioAssistido = 0;
            $percentage = 0;
            $totalObrigatorio = 0;
            $iqaCicle = null;
            if($this->getUser()->getUsergroup() && $this->getUser()->getUsergroup()->getCooperated()){
                $iqaCicle = $em->getRepository('AppBundle:IqaCicle')->getActiveIqaCicle();
                if($iqaCicle){
                    $totalObrigatorio = count($em->getRepository('AppBundle:IqaMidia')->findBy(array(
                        'iqaCicle' => $iqaCicle->getId(),
                        'mandatory' => '1',
                    )));
                    $client = $em->getRepository('AppBundle:Client')->find($this->getUser()->getId());
                    $this->log($client->getCrmForMediacenter());
                    $iqaMidiasLMS = $em->getRepository('AppBundle:IqaMidia')->findBy(array(
                        'iqaCicle' => $iqaCicle->getId(),
                        'plataform' => 'LMS',
                    ));
                    foreach ($iqaMidiasLMS as $item) {                   
                        $userEvaluation = $em->getRepository('AppBundle:UserEvaluation')->getApprovedByCrm($client, $em->getReference('AppBundle:Course', $item->getCourseId()));
                        if(!$userEvaluation){
                            $lmsPendente = true;
                        }else{
                            $lmsAssistidos++;
                            $percentage += $item->getPercentage();
                            if($item->getMandatory()){
                                $obrigatorioAssistido++;
                            }
                        }
                    }
                    $iqaMidiasMediaCenter = $em->getRepository('AppBundle:IqaMidia')->findBy(array(
                        'iqaCicle' => $iqaCicle->getId(),
                        'plataform' => 'Media Center',
                    ));
                    foreach ($iqaMidiasMediaCenter as $item) {
                        $svMedia = $this->getIqaCicleMediacenterRepository()->getMediaFromMediaCenter($item->getMediaId());
                        if($svMedia){
                            $userHasSvMedia = $this->getIqaCicleMediacenterRepository()->getUserHasSvMedia($client->getCrmForMediacenter(), $svMedia['mid']);
                            if($item->getMediaType()->getId() == MediaType::VIDEO && $userHasSvMedia){
                                $videosAssistidos++;
                                $percentage += $item->getPercentage();
                                if($item->getMandatory()){
                                    $obrigatorioAssistido++;
                                }
                            }else if($item->getMediaType()->getId() == MediaType::PODCAST && $userHasSvMedia){
                                $podcastAssistidos++;
                                $percentage += $item->getPercentage();
                                if($item->getMandatory()){
                                    $obrigatorioAssistido++;
                                }
                            }else{
                                $mediaCenterPendente = true;
                            }
                        }
                    }
                    $iqaCicleConcluded = $em->getRepository('AppBundle:IqaCicleConcluded')->findBy(array(
                        'iqaCicle' => $iqaCicle,
                        'uid' => $client->getCrmForMediacenter(),
                    ));
                    if(!$iqaCicleConcluded){
                        $this->log("@@@@@");
                        $this->log("HOMECONTROLLER: iqaCiclePopup NOT CONCLUDED");
                        $showModal = array_key_exists('SHOW_IQA_CICLE_MODAL', $_SESSION) ? $_SESSION['SHOW_IQA_CICLE_MODAL'] : 0 ;
                        $_SESSION['SHOW_IQA_CICLE_MODAL'] = 0;
                        $contentMessage = "";
                        // if($lmsAssistidos>0){
                        //     $contentMessage .= "<b>".$lmsAssistidos."</b>".($lmsAssistidos == 1 ? " Conteúdo" : " Conteúdos");
                        // }
                        // if($videosAssistidos> 0){
                        //     $contentMessage .= ((empty($contentMessage))?"": (($podcastAssistidos > 0 ? ", " : " e "))) . "<b>".$videosAssistidos."</b>".($videosAssistidos == 1 ? " Vídeo" : " Vídeos");
                        // }
                        // if($podcastAssistidos>0){
                        //     $contentMessage .= ((empty($contentMessage))?"": " e ") . "<b>".$podcastAssistidos."</b>".($podcastAssistidos == 1 ? " Podcast" : " Podcasts");
                        // }
                        // if(empty($contentMessage)){
                        //     $modalMessage="Você ainda não acessou nenhum conteúdo válido para o IQA.";
                        // }else{
                        //     $modalMessage="Você já acessou ".$contentMessage." válidos para o IQA.";
                        // }
                        //Não fez nenhum conteúdo IQA
                        if($obrigatorioAssistido  == 0 && $percentage == 0){
                            $modalMessage="Você ainda não concluiu nenhum conteúdo válido para o ciclo atual do IQA";
                        }else if($obrigatorioAssistido >= $totalObrigatorio && $percentage<100){//Fez o conteúdo obrigatório, mas não atingiu 100
                            $modalMessage="Você fez o tema obrigatório, mas ainda não atingiu os 100% de conteúdos válidos para o ciclo atual do IQA.";
                        }else if($obrigatorioAssistido < $totalObrigatorio && $percentage>=100){//Não fez o conteúdo obrigatório, mas atingiu 100
                            $modalMessage="Você já fez conteúdos válidos para o ciclo atual do IQA, mas ainda não concluiu o tema obrigatório.";
                        }else if($obrigatorioAssistido < $totalObrigatorio && $percentage<100){//Não fez o conteúdo obrigatório e não atingiu 100%
                            $modalMessage="Você já fez conteúdos válidos para o ciclo atual do IQA, mas ainda não atingiu 100% e não concluiu o tema obrigatório.";
                        }
                        $this->log("######");
                        $this->log($modalMessage);
                        $this->log("$$$$$$");
                        $this->log("totalObrigatorio ".$totalObrigatorio);
                        $this->log("obrigatorioAssistido ".$obrigatorioAssistido);
                        $this->log("percentage ".$percentage);
    
                        if($showModal){
                            //TODO - IQA: MENSAGEM SUCESSO
                            $iqaLog = new IqaLog();
                            $iqaLog->setIqaCicle($iqaCicle);
                            $iqaLog->setUser($this->getUser());
                            $iqaLog->setMessage($modalMessage);
                            $iqaLog->setPorcentagem($percentage);
                            $em->persist($iqaLog);
                            $em->flush();
                        }
                    }else{
                        $show100Modal = array_key_exists('SHOW_IQA_CICLE_MODAL', $_SESSION) ? $_SESSION['SHOW_IQA_CICLE_MODAL'] : 0 ;
                        $_SESSION['SHOW_IQA_CICLE_MODAL'] = 0;
                        if($show100Modal){
                            //TODO - IQA: MENSAGEM SUCESSO
                            $iqaLog = new IqaLog();
                            $iqaLog->setIqaCicle($iqaCicle);
                            $iqaLog->setUser($this->getUser());
                            $iqaLog->setMessage("Você já concluiu 100% dos conteúdos válidos para o ciclo atual do IQA, garantindo sua remuneração. PARABÉNS!");
                            $iqaLog->setPorcentagem($percentage);
                            $em->persist($iqaLog);
                            $em->flush();
                        }
                    }
                }
            }
    
            return $this->render('AppBundle:Home:popupIqaCicle.html.twig', array(
                'showModal' => $showModal,
                'show100Modal' => $show100Modal,
                'lmsAssistidos' => $lmsAssistidos,
                'podcastAssistidos' => $podcastAssistidos,
                'videosAssistidos' => $videosAssistidos,
                'lmsPendente' => $lmsPendente,
                'mediaCenterPendente' => $mediaCenterPendente,
                'modalMessage' => $modalMessage,
                'obrigatorio' => $obrigatorioAssistido >= $totalObrigatorio,
                'obrigatorioAssistido' => $obrigatorioAssistido,
                'totalObrigatorio' => $totalObrigatorio,
                'percentage' => $percentage,
                'iqaCicle' => $iqaCicle,
            ));
        }else{
            $this->log("!!!!");
            $this->log("HOMECONTROLLER: sem user");
        }
    }
}
