<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\RedirectResponse;
use AppBundle\Entity\InscriptionLesson;
use AppBundle\Entity\UserEvaluation;
use AppBundle\Entity\Lesson;
use AppBundle\Entity\CommentCourse;
use UserBundle\Entity\User;
use AppBundle\Form\CommentCourseType;
use AppBundle\Entity\Scorm12ScoTracking;
use AppBundle\Entity\Scorm12Sco;
use Sensio\Bundle\FrameworkExtraBundle\Configuration as EXT;
use JMS\DiExtraBundle\Annotation as DI;
use Symfony\Component\Security\Core\Exception\AccessDeniedException;

/**
 * Lesson controller.
 * @Route("/")
 */
class LessonController extends BaseController
{

    /**
     * @Route("/new-comment-course", name="course_comment_create", options={"expose"=true})
     */
    public function commentCourseAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $request = Request::createFromGlobals();
        $course = $request->request->get('course');
        $user = $request->request->get('user');
        $response = $request->request->get('response');
        $message = $request->request->get('message');
        $user = $em->getRepository('UserBundle:User')->find($user);
        $course = $em->getRepository('AppBundle:Course')->find($course);
        $entity = new CommentCourse();
        $entity->setUser($user);
        $entity->setCourse($course);
        $entity->setMessage($message);
        if ($response!=null) {
            $comment = $em->getRepository('AppBundle:CommentCourse')->find($response);
            $entity->setReference($comment);
        }
        $entity->setActive(false);
        $em->persist($entity);
        $em->flush();
        return $this->returnJson($entity);
    }

    /**
     * @Route("/curso/{courseId}/aula/{id}/finalizar", name="lesson_finish_action", options={"expose"=true})
     * @Method("PATCH")
     */
    public function finishAction(Request $request, $courseId, $id)
    {
        $user = $this->getUser();
        if (!$lesson = $this->getLessonRepository()->find($id)) {
            throw $this->createNotFoundException('Aula não encontrada.');
        }
        if (!$course = $this->getCourseRepository()->find($courseId)) {
            throw $this->createNotFoundException('Curso não encontrado.');
        }
        if (!$inscription = $this->getInscriptionRepository()->getLastInscriptionByUser($user, $course)) {
            // if($course->getAutoInscription()){
            //     return $this->redirectToRoute('course_company_subscribe', array("slug" => $course->getSlug()));
            // }else{
            throw $this->createNotFoundException('Usuário não matriculado.');
            // }
        }

        $concludedLessons = $this->getInscriptionLessonRepository()->findAllByInscription($inscription, true);

        $validaFimModulo = $this->getModuleRepository()->getLastLesson($lesson->getModule()->getId());

        $question = 0;

        if ((int)$validaFimModulo == $lesson->getPosition()) {
            $evaluation = $this->getEvaluationRepository()->findOneByModule($lesson->getModule());
            $question = count($this->getRepositoryFromBase('Question')->findBy(array('evaluation' => $evaluation)));
        }

        //Localiza o próximo módulo
        $nextModule = $this->getModuleRepository()->getNextModule($lesson->getModule());
        if ($nextModule!=null) {
            $firstLessonModule = $this->getLessonRepository()->findFirstByModule($nextModule);
            $firstLessonModule = $firstLessonModule->getId();
        } else {
            $firstLessonModule = null;
        }

        $inscriptionLesson = $this->getInscriptionLessonRepository()->findOneBy(array('inscription' => $inscription, 'lesson' => $lesson));
        $nextLesson = $this->getLessonRepository()->getNextLesson($lesson);
        $userEvaluation = $this->getUserEvaluationRepository()->findOneBy(array('user' => $user, 'course' => $course));
        
        if ($nextLesson!=null) {
            if (!$inscriptionLesson->isFinished()) {
                $em = $this->getDoctrine()->getManager();
                $inscriptionLesson->setFinished(new \DateTime());
                $em->persist($inscriptionLesson);
                $em->flush();
            }
            $inscriptionLessonNext = $this->getInscriptionLessonRepository()->findOneBy(array('inscription' => $inscription, 'lesson' => $nextLesson));
            if ($inscriptionLessonNext == null) {
                $em = $this->getDoctrine()->getManager();
                $inscriptionLessonNext = new InscriptionLesson();
                $inscriptionLessonNext->setInscription($inscription);
                $inscriptionLessonNext->setLesson($nextLesson);
                $em->persist($inscriptionLessonNext);
                $em->flush();
            }

            $concludedLessons = $this->getInscriptionLessonRepository()->findAllByInscription($inscription, true);
            if (!$userEvaluation && $course->getTotalEvaluations() == 0 && $course->getTotalLessons() == count($concludedLessons)) {
            
                $userEvaluation = new UserEvaluation();
                $userEvaluation->setUser($user);
                $userEvaluation->setCourse($course);
                $userEvaluation->setGrade(100);
                $userEvaluation->setApproved(true);
                $em->persist($userEvaluation);
                $em->flush();

                $courseService = $this->container->get('course.service');
                $courseService->createIntegrationFromFinishCourse($courseId, $user);
            }
            $nextLesson = $nextLesson->getId();
        } elseif ($nextLesson==null && $question == 0) {
            $em = $this->getDoctrine()->getManager();
            if (!$inscriptionLesson->isFinished()) {
                $inscriptionLesson->setFinished(new \DateTime());
                $em->persist($inscriptionLesson);
            }
            $em->flush();
            $concludedLessons = $this->getInscriptionLessonRepository()->findAllByInscription($inscription, true);
        
            if (!$userEvaluation && $course->getTotalEvaluations() == 0 && $course->getTotalLessons() == count($concludedLessons)) {
                
                $userEvaluation = new UserEvaluation();
                $userEvaluation->setUser($user);
                $userEvaluation->setCourse($course);
                $userEvaluation->setGrade(100);
                $userEvaluation->setApproved(true);
                $em->persist($userEvaluation);
                $em->flush();

                $courseService = $this->container->get('course.service');
                $courseService->createIntegrationFromFinishCourse($courseId, $user);
            }else if($course->getTotalEvaluations() == 0 && $course->getTotalLessons() == count($concludedLessons)){

                $courseService = $this->container->get('course.service');
                $courseService->createIntegrationFromFinishCourse($courseId, $user);
            }
        }else{
            
            $em = $this->getDoctrine()->getManager();
            if (!$inscriptionLesson->isFinished()) {
                $inscriptionLesson->setFinished(new \DateTime());
                $em->persist($inscriptionLesson);
                $em->flush();
            }
        }

        $showPopup = 0;
        // if($this->getUser()->getUsergroup() && $this->getUser()->getUsergroup()->getCooperated()){
        //     $iqaCicle = $em->getRepository('AppBundle:IqaCicle')->getActiveIqaCicle();
        //     if($iqaCicle){
        //         $lmsAssistidos = 0;
        //         $mediaCenterAssistidos = 0;
        //         $iqaCicle = $em->getRepository('AppBundle:IqaCicle')->getActiveIqaCicle();
        //         if($iqaCicle){
        //             $iqaMidiasMediaCenter = $em->getRepository('AppBundle:IqaMidia')->findBy(array(
        //                 'iqaCicle' => $iqaCicle->getId(),
        //                 'plataform' => 'Media Center',
        //             ));
        //             foreach ($iqaMidiasMediaCenter as $item) {
        //                 //Carrega o objeto svmedia
        //                 $svMedia = $this->getIqaCicleMediacenterRepository()->getMediaFromMediaCenter($item->getMediaId());
        //                 if($svMedia){
        //                     $userHasSvMedia = $this->getIqaCicleMediacenterRepository()->getUserHasSvMedia($this->getUser()->getUid(), $svMedia['mid']);
        //                     if($userHasSvMedia){
        //                         $mediaCenterAssistidos++;
        //                     }
        //                 }
        //             }

        //             $iqaMidiasLMS = $em->getRepository('AppBundle:IqaMidia')->findBy(array(
        //                 'iqaCicle' => $iqaCicle->getId(),
        //                 'plataform' => 'LMS',
        //             ));
        //             foreach ($iqaMidiasLMS as $item) {
        //                 //Verifica se o curso já foi assistido
        //                 $userEvaluation = $em->getRepository('AppBundle:UserEvaluation')->findOneBy(array(
        //                     'user' => $this->getUser(),
        //                     'course' => $em->getReference('AppBundle:Course', $item->getCourseId()),
        //                     'approved' => '1',
        //                 ));
        //                 if($userEvaluation){
        //                     $lmsAssistidos++;
        //                 }
        //             }
        //             if((count($iqaMidiasLMS) <= $lmsAssistidos) && (count($iqaMidiasMediaCenter) <= $mediaCenterAssistidos)){
        //                 $showPopup = 1;
        //             }
        //         }
        //     }
        // }

        return $this->returnJson(array(
            'inscriptionLesson' => $inscriptionLesson,
            'question' => $question,
            'module' => $lesson->getModule()->getId(),
            'nextLesson'=> $nextLesson,
            'nextModule' => $nextModule,
            'firstLessonModule'=> $firstLessonModule,
            'showPopup' => $showPopup,
        ));
    }

    /**
     * @Route("/curso/{courseId}/aula/{id}/integration", name="lesson_integration_action", options={"expose"=true})
     * @Method("POST")
     */
    public function integrationAction(Request $request, $courseId, $id)
    {
        $user = $this->getUser();
        if (!$lesson = $this->getLessonRepository()->find($id)) {
            throw $this->createNotFoundException('Aula não encontrada.');
        }
        if (!$course = $this->getCourseRepository()->find($courseId)) {
            throw $this->createNotFoundException('Curso não encontrado.');
        }
        if (!$inscription = $this->getInscriptionRepository()->getLastInscriptionByUser($user, $course)) {
            // if($course->getAutoInscription()){
            //     return $this->redirectToRoute('course_company_subscribe', array("slug" => $course->getSlug()));
            // }else{
            throw $this->createNotFoundException('Usuário não matriculado.');
            // }
        }

        $courseService = $this->container->get('course.service');
        $courseService->createIntegrationFromFinishCourse($courseId, $user);

        return $this->returnJson(array(
            'success' => true
        ));
    }

    /**
     * @Route("/curso/{courseId}/aula/{id}/carregar", name="lesson_load_action", options={"expose"=true})
     * @Method("PATCH")
     */
    public function loadAction(Request $request, $courseId, $id)
    {
        $user = $this->getUser();
        if (!$lesson = $this->getLessonRepository()->find($id)) {
            throw $this->createNotFoundException('Aula não encontrada.');
        }
        if (!$course = $this->getCourseRepository()->find($courseId)) {
            throw $this->createNotFoundException('Curso não encontrado.');
        }
        if (!$inscription = $this->getInscriptionRepository()->getLastInscriptionByUser($user, $course)) {
            throw $this->createNotFoundException('Usuário não matriculado.');
        }
        $inscriptionLesson = $this->getInscriptionLessonRepository()->findOneBy(array('inscription' => $inscription, 'lesson' => $lesson));
        if (!$inscriptionLesson->isLoaded()) {
            $em = $this->getDoctrine()->getManager();
            $inscriptionLesson->setLoaded(new \DateTime());
            $em->persist($inscriptionLesson);
            $em->flush();
        }
        return $this->returnJson($inscriptionLesson);
    }

    /**
     * @Route("/curso/{courseId}/aula/{id}/iniciar", name="lesson_start_action", options={"expose"=true})
     * @Method("PATCH")
     */
    public function startAction(Request $request, $courseId, $id)
    {
        $user = $this->getUser();
        if (!$lesson = $this->getLessonRepository()->find($id)) {
            throw $this->createNotFoundException('Aula não encontrada.');
        }
        if (!$course = $this->getCourseRepository()->find($courseId)) {
            throw $this->createNotFoundException('Curso não encontrado.');
        }
        if (!$inscription = $this->getInscriptionRepository()->getLastInscriptionByUser($user, $course)) {
            throw $this->createNotFoundException('Usuário não matriculado.');
        }
        $inscriptionLesson = $this->getInscriptionLessonRepository()->findOneBy(array('inscription' => $inscription, 'lesson' => $lesson));
        if (!$inscriptionLesson->isStarted()) {
            $em = $this->getDoctrine()->getManager();
            $inscriptionLesson->setStarted(new \DateTime());
            $em->persist($inscriptionLesson);
            $em->flush();
        }
        return $this->returnJson($inscriptionLesson);
    }

    /**
     * @Route("/curso/{courseId}/aula/{id}/{scoId}", name="lesson_show")
     */
    public function showAction(Request $request, $courseId, $id, $scoId = null)
    {
        $this->validUser();
        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();

        $media = null;

        if (!$lesson = $this->getLessonRepository()->find($id)) {
            throw $this->createNotFoundException('Aula não encontrada.');
        }
        if (!$course = $this->getCourseRepository()->find($courseId)) {
            throw $this->createNotFoundException('Curso não encontrado.');
        }
        if (!$inscription = $this->getInscriptionRepository()->getLastInscriptionByUser($user, $course)) {
            // throw $this->createNotFoundException('Usuário não matriculado.');
            // if ($course->getAutoInscription() || $this->get('security.authorization_checker')->isGranted('ROLE_SUPER_ADMIN')) {
            if ($course->isAccessAvailable($user) || $this->get('security.authorization_checker')->isGranted('ROLE_SUPER_ADMIN')) {
                return $this->redirectToRoute('course_company_subscribe', array("slug" => $course->getSlug()));
            } else {
                throw $this->createNotFoundException('Usuário não matriculado.');
            }
        }

        if ($lesson->getScormFile()!=null) {
            $type = "scorm";
        } elseif ($lesson->getSvVideo()!=null) {
            $type = "video";
            $media = $this->get("samba.videos.videos")->getMedia($lesson->getSvVideo());
        } else {
            $type = "texto";
            //$em = $this->getDoctrine()->getManager();
            if (!$inscriptionLesson = $this->getInscriptionLessonRepository()->findOneBy(array('inscription' => $inscription, 'lesson' => $lesson))) {
                $inscriptionLesson = new InscriptionLesson();
                $inscriptionLesson->setInscription($inscription);
                $inscriptionLesson->setLesson($lesson);
                $inscriptionLesson->setStarted(new \DateTime());
                $inscriptionLesson->setLoaded(new \DateTime());
                $inscriptionLesson->setFinished(new \DateTime());
                $em->persist($inscriptionLesson);
            }else if($inscriptionLesson->getStarted()==null && $inscriptionLesson->getFinished() == null){
                $inscriptionLesson->setStarted(new \DateTime());
                $inscriptionLesson->setFinished(new \DateTime());
                $em->persist($inscriptionLesson);
            }
            $nextLesson = $this->getLessonRepository()->getNextLesson($lesson);
            if($nextLesson){
                if (!$inscriptionLessonNext = $this->getInscriptionLessonRepository()->findOneBy(array('inscription' => $inscription, 'lesson' => $nextLesson))) {
                    $inscriptionLessonNext = new InscriptionLesson();
                    $inscriptionLessonNext->setInscription($inscription);
                    $inscriptionLessonNext->setLesson($nextLesson);
                    $inscriptionLessonNext->setLoaded(new \DateTime());
                    $em->persist($inscriptionLessonNext);
                }
            }
            $em->flush();
        }

        //$comments = $this->getCommentCourseRepository()->findBy(array("active"=>true, "course"=>$course));
        $comments = $this->getCommentCourseRepository()->findPrincipalComments($course);
        $inscriptionLesson = $this->getInscriptionLessonRepository()->findOneBy(array('inscription' => $inscription, 'lesson' => $lesson));
        if (!$inscriptionLesson || $inscriptionLesson == null) {
            // Não existe registro da aula na tabela incription_lesson, então criamos
            //$em = $this->getDoctrine()->getManager();
            $inscriptionLesson = new InscriptionLesson();
            $inscriptionLesson->setInscription($inscription);
            if ($type == "scorm") {
                $inscriptionLesson->setStarted(new \DateTime());
                $inscriptionLesson->setLoaded(new \DateTime());
            }
            $inscriptionLesson->setLesson($lesson);
            $em->persist($inscriptionLesson);
            $em->flush();
        }
        $courseFavorited = $em->getRepository('AppBundle:FavCourse')->findBy(array(
            'user' => $user->getId(),
            'course' => $course->getId()
        ));

        $courseLiked = $em->getRepository('AppBundle:LikeCourse')->findBy(array(
            'user' => $user->getId(),
            'course' => $course->getId()
        ));

        $courseLikes = $em->getRepository('AppBundle:LikeCourse')->findBy(array(
            'course' => $course->getId()
        ));

        $entity = new CommentCourse();
        $form = $this->createCreateForm($entity, $course->getSlug());

        $scoTracking = null;
        $scormPath = null;
        $nextSco = null;
        //Prepara o ambiente scorm
        if ($lesson->getScormFile()) {
            //Monta o diretório do Scorm
            $scormFile = $lesson->getScormFile();
            $scormFileDir = str_replace(".zip", "", $scormFile);
            if ($scoId!=null) {
                $scorm12Sco = $this->getScorm12ScoRepository()->find($scoId);

                $foundActual = false;
                foreach ($lesson->getScos() as $scoItem) {
                    if ($scoItem->getId() == $scorm12Sco->getId()) {
                        $foundActual = true;
                    } elseif ($foundActual) {
                        $nextSco = $scoItem;
                        $foundActual = false;
                    }
                }

                $scoTracking = $this->getScorm12ScoTrackingRepository()->findOneBy(
                    array('user' => $user->getId(), 'sco' => $scorm12Sco->getId())
                );

                if (is_null($scoTracking)) {
                    $scoTracking = $this->createScorm12ScoTracking($user, $scorm12Sco);
                }
                //Monta o path do SCO atual
                $scormPath = Lesson::UPLOAD_PATH_LESSON_SCORM."/".$scormFileDir."/". $scorm12Sco->getEntryUrl();
            } else {
                $scorm12Sco = $lesson->getScos()->get(0);
                $scoTracking = $this->getScorm12ScoTrackingRepository()->findOneBy(array(
                    'user' => $user->getId(),
                    'sco' => $scorm12Sco->getId()
                ));

                if (is_null($scoTracking)) {
                    $scoTracking = $this->createScorm12ScoTracking($user, $scorm12Sco);
                }

                if ($scorm12Sco->getIsBlock() && $scorm12Sco->getEntryUrl()==null) {
                    $scoTracking = $this->updateScorm12ScoTracking($scoTracking);
                    $scorm12ScoChild = $this->getScorm12ScoRepository()->findOneBy(array('scoParent'=>$scorm12Sco));
                    return $this->redirect($this->generateUrl('lesson_show', array(
                        'courseId' => $course->getId(),
                        'id' => $lesson->getId(),
                        'scoId' => $scorm12ScoChild->getId(),
                    )));
                }

                $foundActual = false;
                foreach ($lesson->getScos() as $scoItem) {
                    if ($scoItem->getId() == $scorm12Sco->getId()) {
                        $foundActual = true;
                    } elseif ($foundActual) {
                        $nextSco = $scoItem;
                        $foundActual = false;
                    }
                }
                //Monta o path do SCO atual
                $scormPath = Lesson::UPLOAD_PATH_LESSON_SCORM."/".$scormFileDir."/". $scorm12Sco->getEntryUrl();
            }
        }

        $scos = $lesson->getScos();
        $rootScos = array();

        foreach ($scos as $sco) {
            if (is_null($sco->getScoParent())) {
                $rootScos[] = $sco;
            }
        }

        $nextLesson = $this->getLessonRepository()->getNextLesson($lesson);
        $nextModule = $this->getModuleRepository()->getNextModule($lesson->getModule());

        $concludedLessons = $inscriptionLessons = $this->getInscriptionLessonRepository()->findAllByInscription($inscription, true);

        if ($course->getModuleDependency()) {
            if ($nextLesson != null && $type == "texto") {
                // if (!$inscriptionLessonNext = $this->getInscriptionLessonRepository()->findOneBy(array('inscription' => $inscription, 'lesson' => $nextLesson))) {
                //     // Não existe registro da aula na tabela incription_lesson, então criamos
                //     //$em = $this->getDoctrine()->getManager();
                //     $inscriptionLesson = new InscriptionLesson();
                //     $inscriptionLesson->setInscription($inscription);
                //     $inscriptionLesson->setLesson($nextLesson);
                //     $inscriptionLesson->setLoaded(new \DateTime());
                //     $em->persist($inscriptionLesson);
                //     //$em->flush();
                // }
            } elseif ($nextLesson == null && $type == "texto") {
                //$em = $this->getDoctrine()->getManager();
                if (!$inscriptionLesson = $this->getInscriptionLessonRepository()->findOneBy(array('inscription' => $inscription, 'lesson' => $lesson))) {
                    $inscriptionLesson = new InscriptionLesson();
                    $inscriptionLesson->setInscription($inscription);
                    $inscriptionLesson->setLesson($lesson);
                    $inscriptionLesson->setStarted(new \DateTime());
                    $inscriptionLesson->setLoaded(new \DateTime());
                    $inscriptionLesson->setFinished(new \DateTime());
                    $em->persist($inscriptionLesson);
                    $em->flush();
                }
                $userEvaluation = $this->getUserEvaluationRepository()->findOneBy(array('user' => $user, 'course' => $course));
                if (!$userEvaluation && $course->getTotalEvaluations() == 0) {
                    //$em = $this->getDoctrine()->getManager();
                    $userEvaluation = new UserEvaluation();
                    $userEvaluation->setUser($user);
                    $userEvaluation->setCourse($course);
                    $userEvaluation->setGrade(100);
                    $userEvaluation->setApproved(true);
                    $em->persist($userEvaluation);
                    $em->flush();
                }
            }
        }else{
            $userEvaluation = $this->getUserEvaluationRepository()->findOneBy(array('user' => $user, 'course' => $course));
            if($type == "texto" && $course->getTotalLessons() == count($concludedLessons) && !$userEvaluation && $course->getTotalEvaluations() == 0) {
                $userEvaluation = new UserEvaluation();
                $userEvaluation->setUser($user);
                $userEvaluation->setCourse($course);
                $userEvaluation->setGrade(100);
                $userEvaluation->setApproved(true);
                $em->persist($userEvaluation);
                $em->flush();
            }
        }

        $inscriptionLessons = $this->getInscriptionLessonRepository()->findByInscription($inscription);
        $totalQuestions = $this->getQuestionRepository()->questionsForCourse($course);
        if ($course->getModuleDependency()) {
            $modulesArray = array();
            foreach ($inscriptionLessons as $inscriptionLesson) {
                $moduleLesson = $inscriptionLesson->getLesson()->getModule();
                if (!in_array($moduleLesson->getId(), $modulesArray)) {
                    $modulesArray[] = $moduleLesson->getId();
                }
            }

            $modules = array();
            foreach ($modulesArray as $moduleItem) {
                $modules[] = $this->getModuleRepository()->find($moduleItem);
            }
        } else {
            $modules = $course->getModules();
        }

        //Verificar qual a última aula do módulo
        $lastLesson = $this->getLessonRepository()->findLastByModule($lesson->getModule());
        $evaluations = $this->getEvaluationRepository()->findByModule($lesson->getModule());
        $evaluatonAvailable = false;
        if (count($evaluations)>0) {
            //Verifica se já assistiu a última aula do módulo
            $lastInscriptionLesson = $this->getInscriptionLessonRepository()->findOneBy(array("inscription" => $inscription, "lesson" => $lastLesson));
            if ($lastInscriptionLesson != null && $lastInscriptionLesson->getFinished() != null) {
                $evaluatonAvailable = true;
            }
        }

        //$totalQuestions = 0;
        return $this->render('AppBundle:Lesson:show.html.twig', array(
            'lesson' => $lesson,
            'course' => $course,
            'inscription' => $inscription,
            'courseFavorited' => $courseFavorited,
            'courseLiked' => $courseLiked,
            'courseLikes' => $courseLikes,
            'totalQuestions' => $totalQuestions,
            'nextLesson' => $nextLesson,
            'nextModule' => $nextModule,
            'inscriptionLessons' => $inscriptionLessons,
            'inscriptionLessonsByModule' => $this->groupInscriptionLessonsByModule($course->getModules(), $inscriptionLessons),
            'form' => $form->createView(),
            'comments' => $comments,
            'modules' => $modules,
            'scos' => $rootScos,
            'scoTracking' => $scoTracking,
            'scormUrl' => $scormPath,
            'nextSco' => $nextSco,
            'evaluatonAvailable' => $evaluatonAvailable,
            'type' => $type,
            'media' => $media,
            'scoId' => $scoId 
        ));
    }
    
    /**
     * @Route("/curso-scorm/{id}/{scoId}", name="lesson_scorm_show")
     */
    public function showScormAction(Request $request, $id, $scoId = null)
    {
        $this->validUser();
        $em = $this->getDoctrine()->getManager();

        if (!$lesson = $this->getLessonRepository()->find($id)) {
            throw $this->createNotFoundException('Aula não encontrada.');
        }

        $user = $this->getUser();
        $module = $lesson->getModule();
        $course = $module->getCourse();

        if (!$inscription = $this->getInscriptionRepository()->getLastInscriptionByUser($user, $course)) {
            // throw $this->createNotFoundException('Usuário não matriculado.');
            // if ($course->getAutoInscription() || $this->get('security.authorization_checker')->isGranted('ROLE_SUPER_ADMIN')) {
            if ($course->isAccessAvailable($user) || $this->get('security.authorization_checker')->isGranted('ROLE_SUPER_ADMIN')) {
                return $this->redirectToRoute('course_company_subscribe', array("slug" => $course->getSlug()));
            } else {
                throw $this->createNotFoundException('Usuário não matriculado.');
            }
        }

        $scos = $lesson->getScos();
        $rootScos = array();

        foreach ($scos as $sco) {
            if (is_null($sco->getScoParent())) {
                $rootScos[] = $sco;
            }
        }
        //Prepara o ambiente scorm
        if ($lesson->getScormFile()) {
            //Monta o diretório do Scorm
            $scormFile = $lesson->getScormFile();
            $scormFileDir = str_replace(".zip", "", $scormFile);
            if ($scoId!=null) {
                $scorm12Sco = $this->getScorm12ScoRepository()->find($scoId);

                $foundActual = false;
                foreach ($lesson->getScos() as $scoItem) {
                    if ($scoItem->getId() == $scorm12Sco->getId()) {
                        $foundActual = true;
                    } elseif ($foundActual) {
                        $nextSco = $scoItem;
                        $foundActual = false;
                    }
                }

                $scoTracking = $this->getScorm12ScoTrackingRepository()->findOneBy(
                    array('user' => $user->getId(), 'sco' => $scorm12Sco->getId())
                );

                if (is_null($scoTracking)) {
                    $scoTracking = $this->createScorm12ScoTracking($user, $scorm12Sco);
                }
                //Monta o path do SCO atual
                $scormPath = Lesson::UPLOAD_PATH_LESSON_SCORM."/".$scormFileDir."/". $scorm12Sco->getEntryUrl();
            } else {
                $scorm12Sco = $lesson->getScos()->get(0);
                $scoTracking = $this->getScorm12ScoTrackingRepository()->findOneBy(array(
                    'user' => $user->getId(),
                    'sco' => $scorm12Sco->getId()
                ));

                if (is_null($scoTracking)) {
                    $scoTracking = $this->createScorm12ScoTracking($user, $scorm12Sco);
                }

                if ($scorm12Sco->getIsBlock() && $scorm12Sco->getEntryUrl()==null) {
                    $scoTracking = $this->updateScorm12ScoTracking($scoTracking);
                    $scorm12ScoChild = $this->getScorm12ScoRepository()->findOneBy(array('scoParent'=>$scorm12Sco));
                    return $this->redirect($this->generateUrl('lesson_show', array(
                        'courseId' => $course->getId(),
                        'id' => $lesson->getId(),
                        'scoId' => $scorm12ScoChild->getId(),
                    )));
                }

                $foundActual = false;
                foreach ($lesson->getScos() as $scoItem) {
                    if ($scoItem->getId() == $scorm12Sco->getId()) {
                        $foundActual = true;
                    } elseif ($foundActual) {
                        $nextSco = $scoItem;
                        $foundActual = false;
                    }
                }
                //Monta o path do SCO atual
                $scormPath = Lesson::UPLOAD_PATH_LESSON_SCORM."/".$scormFileDir."/". $scorm12Sco->getEntryUrl();
            }
        }
        return $this->render('AppBundle:Lesson:show-scorm.html.twig', array(
            'lesson' => $lesson,
            'course' => $course,
            'inscription' => $inscription,
            'scos' => $rootScos,
            'scoTracking' => $scoTracking,
            'scormUrl' => $scormPath,
        ));
    }

    public function createScorm12ScoTracking(User $user, Scorm12Sco $sco)
    {
        $em = $this->getDoctrine()->getManager();
        $scoTracking = new Scorm12ScoTracking();
        $scoTracking->setUser($user);
        $scoTracking->setSco($sco);
        $scoTracking->setLessonStatus('not attempted');
        $scoTracking->setSuspendData('');
        $scoTracking->setEntry('ab-initio');
        $scoTracking->setLessonLocation('');
        $scoTracking->setCredit('no-credit');
        $scoTracking->setTotalTime(0);
        $scoTracking->setSessionTime(0);
        $scoTracking->setLessonMode('normal');
        $scoTracking->setExitMode('');
        $scoTracking->setBestLessonStatus('not attempted');

        if (is_null($sco->getPrerequisites())) {
            $scoTracking->setIsLocked(false);
        } else {
            $scoTracking->setIsLocked(true);
        }
        $em->persist($scoTracking);
        $em->flush();

        return $scoTracking;
    }

    public function updateScorm12ScoTracking($scoTracking)
    {
        $em = $this->getDoctrine()->getManager();
        $scoTracking->setLessonStatus('completed');
        $scoTracking->setLessonMode('normal');
        $scoTracking->setBestLessonStatus('');
        $em->persist($scoTracking);
        $em->flush();

        return $scoTracking;
    }

    /**
     * @EXT\Route(
     *     "/scorm/tracking/commit/mode/{mode}/sco/{scoId}",
     *     name = "claro_scorm_12_tracking_commit",
     *     options={"expose"=true}
     * )
     * @EXT\ParamConverter(
     *      "scorm12Sco",
     *      class="AppBundle:Scorm12Sco",
     *      options={"id" = "scoId", "strictId" = true}
     * )
     *
     * @param string $datasString
     * @param string $mode  determines if given datas must be persisted
     *                      or logged
     *
     * @return Response
     */
    public function commitScorm12Tracking(
        Request $request,
        $mode,
        Scorm12Sco $scorm12Sco
    ) {
        $user = $this->getUser();
        $datasString = $request->request->get('datasString');
        //$scorm = $scorm12Sco->getScormResource();
        //$this->checkAccess('OPEN', $scorm);

        // if ($user === 'anon.') {
        //
        //     return new Response('', '204');
        // }

        $datasArray = explode("<-;->", $datasString);
        $studentId = intval($datasArray[0]);
        $lessonMode = $datasArray[1];
        $lessonLocation = $datasArray[2];
        $lessonStatus = $datasArray[3];
        $credit = $datasArray[4];
        $scoreRaw = intval($datasArray[5]);
        $scoreMin = intval($datasArray[6]);
        $scoreMax = intval($datasArray[7]);
        $sessionTime = $datasArray[8];
        $totalTime = $datasArray[9];
        $suspendData = $datasArray[10];
        $entry = $datasArray[11];
        $exitMode = $datasArray[12];


        if ($user->getId() !== $studentId) {
            throw new AccessDeniedException();
        }
        $sessionTimeInHundredth = $this->convertTimeInHundredth($sessionTime);

        $scoTracking = $this->getScorm12ScoTrackingRepository()->findOneBy(
            array('user' => $user->getId(), 'sco' => $scorm12Sco->getId())
        );

        if (is_null($scoTracking)) {
            $scoTracking = $this->createScorm12ScoTracking($user, $scorm12Sco);
        }
        $scoTracking->setEntry($entry);
        $scoTracking->setExitMode($exitMode);
        $scoTracking->setLessonLocation($lessonLocation);
        $scoTracking->setLessonStatus($lessonStatus);
        $scoTracking->setScoreMax($scoreMax);
        $scoTracking->setScoreMin($scoreMin);
        $scoTracking->setScoreRaw($scoreRaw);
        $scoTracking->setSessionTime($sessionTimeInHundredth);
        $scoTracking->setSuspendData($suspendData);
        $em = $this->getDoctrine()->getManager();
        $em->persist($scoTracking);
        $em->flush();

        $lesson = $scorm12Sco->getLesson();
        $scos = $lesson->getScos();

        $completed = 0;

        foreach ($scos as $sco) {
            $scoTrackingVerify = $this->getScorm12ScoTrackingRepository()->findOneBy(
                array('user' => $user->getId(), 'sco' => $sco->getId())
            );
            if ($scoTrackingVerify!=null && ($scoTrackingVerify->getLessonStatus() == "completed" || $scoTrackingVerify->getLessonStatus() == "COMPLETED")) {
                $completed++;
            }
        }

        return $this->returnJson(array('scos'=>count($scos),'scoComplete'=> $completed,'scormComplete'=> (count($scos) == $completed),'status' => $scoTracking->getLessonStatus()));
    }

    /**
     * @EXT\Route(
     *     "/scorm/tracking/verify-ending/sco/{scoId}",
     *     name = "claro_scorm_12_verify_ending",
     *     requirements={"datasString"=".+"},
     *     options={"expose"=true}
     * )
     * @EXT\ParamConverter(
     *      "scorm12Sco",
     *      class="AppBundle:Scorm12Sco",
     *      options={"id" = "scoId", "strictId" = true}
     * )
     *
     * @param string $datasString
     * @param string $mode  determines if given datas must be persisted
     *                      or logged
     *
     * @return Response
     */
    public function verifyScorm12Ending(
        Scorm12Sco $scorm12Sco
    ) {
        $user = $this->getUser();

        $lesson = $scorm12Sco->getLesson();
        $scos = $lesson->getScos();

        $completed = 0;

        foreach ($scos as $sco) {
            $scoTrackingVerify = $this->getScorm12ScoTrackingRepository()->findOneBy(
                array('user' => $user->getId(), 'sco' => $sco->getId())
            );
            if ($scoTrackingVerify!=null && ($scoTrackingVerify->getLessonStatus() == "completed" || $scoTrackingVerify->getLessonStatus() == "COMPLETED")) {
                $completed++;
            }
        }

        return $this->returnJson(array('scos'=>count($scos),'scoComplete'=> $completed,'scormComplete'=> (count($scos) == $completed)));
    }

    /**
     * Ordena e agrupa aulas por módulos
     */
    private function groupInscriptionLessonsByModule($modules, $inscriptionLessons)
    {
        $inscriptionsByModule = array();
        foreach ($modules as $module) {
            $moduleLessons = array();
            foreach ($inscriptionLessons as $inscriptionLesson) {
                if ($inscriptionLesson->getLesson()->getModule()->getId() == $module->getId()) {
                    array_push($moduleLessons, $inscriptionLesson);
                }
            }
            array_push($inscriptionsByModule, array($module, $moduleLessons));
        }
        return $inscriptionsByModule;
    }

    /**
     * Creates a form to create a Client entity.
     *
     * @param Client $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(CommentCourse $entity, $slug)
    {
        $form = $this->createForm(new CommentCourseType(), $entity, array(
            'action' => $this->generateUrl('course_comment_create', array('slug' => $slug)),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Create'));

        return $form;
    }

    /**
    * Creates a form to edit a CommentCourse entity.
    *
    * @param CommentCourse $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditForm(CommentCourse $entity, $slug)
    {
        $courseType = new CommentCourseType();
        $form = $this->createForm($courseType, $entity, array(
            'action' => $this->generateUrl('course_comment_create', array('slug' => $slug)),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }

    /**
     * Converts time (HHHH:MM:SS.hh) to integer (hundredth of second)
     *
     * @param string $time
     */
    private function convertTimeInHundredth($time)
    {
        $timeInArray = explode(':', $time);
        $timeInArraySec = explode('.', $timeInArray[2]);
        $timeInHundredth = 0;

        if (isset($timeInArraySec[1])) {
            if (strlen($timeInArraySec[1]) === 1) {
                $timeInArraySec[1] .= "0";
            }
            $timeInHundredth = intval($timeInArraySec[1]);
        }
        $timeInHundredth += intval($timeInArraySec[0]) * 100;
        $timeInHundredth += intval($timeInArray[1]) * 6000;
        $timeInHundredth += intval($timeInArray[0]) * 360000;

        return $timeInHundredth;
    }

    /**
     * Converts a time in seconds to a DateInterval string
     *
     * @param int $seconds
     */
    private function retrieveIntervalFromSeconds($seconds)
    {
        $result = '';
        $remainingTime = (int)$seconds;

        if (empty($remainingTime)) {
            $result .= 'PT0S';
        } else {
            $nbDays = (int)($remainingTime / 86400);
            $remainingTime %= 86400;
            $nbHours = (int)($remainingTime / 3600);
            $remainingTime %= 3600;
            $nbMinutes = (int)($remainingTime / 60);
            $nbSeconds = $remainingTime % 60;
            $result .= 'P'.$nbDays.'DT'.$nbHours.'H'.$nbMinutes.'M'.$nbSeconds.'S';
        }

        return $result;
    }

    /**
     * Checks format of given session time interval and tries to fix format if invalid
     *
     * @param string $sessionTime
     */
    private function formatSessionTime($sessionTime)
    {
        $formattedValue = 'PT0S';
        $generalPattern = '/^P([0-9]+Y)?([0-9]+M)?([0-9]+D)?T([0-9]+H)?([0-9]+M)?([0-9]+S)?$/';
        $decimalPattern = '/^P([0-9]+Y)?([0-9]+M)?([0-9]+D)?T([0-9]+H)?([0-9]+M)?[0-9]+\.[0-9]{1,2}S$/';

        if ($sessionTime !== 'PT') {
            if (preg_match($generalPattern, $sessionTime)) {
                $formattedValue = $sessionTime;
            } elseif (preg_match($decimalPattern, $sessionTime)) {
                $formattedValue = preg_replace(array('/\.[0-9]+S$/'), array('S'), $sessionTime);
            }
        }

        return $formattedValue;
    }
}
