<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use PagSeguroBundle\Entity\PagSeguroNotificationType;


class PaymentController extends BaseController
{
  /**
   * Recebe as notificações enviadas automaticamente pelo pagseguro
   *
   * @Route("/notificacao-teste", name="payment_notification_teste")
   * @Template()
   */
  public function notificationTesteAction()
  {
    $this->get("logger")->err("[PAGSEGURO] ACESSANDO NOTIFICAÇÃO TESTE");
    $success = $this->get("pagseguro_manager")->transactionNotification("7C5EFEA442F642F6543114668F9000CC6461");
    return array('success' => $success);
  }

  /**
   * Recebe as notificações enviadas automaticamente pelo pagseguro
   *
   * @Route("/notificacao", name="payment_notification")
   * @Template()
   */
  public function notificationAction()
  {
    $this->get("logger")->err("[PAGSEGURO] ACESSANDO NOTIFICAÇÃO");
    $success = $this->receiveNotification();
    return array('success' => $success);
  }

  /**
   * Recebe as notificações enviadas automaticamente pelo pagseguro
   *
   * @Route("/pagamento/sucesso", name="payment_success")
   * @Template()
   */
  public function successAction()
  {
    $this->get("logger")->err("[PAGSEGURO] TELA DE SUCESSO");
    //Recebe os parâmetros de retorno do pagseguro
    $payment_id = $this->getRequest()->query->get('payment_id');
    $transaction_id = $this->getRequest()->query->get('transaction_id');
    //Verifica se possui parametros de retorno do pagseguro
    if(!is_null($payment_id) && !is_null($transaction_id)){
      $this->get("logger")->err("[PAGSEGURO] TELA DE SUCESSO - ATUALIZANDO PAGAMENTO: $payment_id CODIGO: $transaction_id");
      $em = $this->getDoctrine()->getManager();
      //Atualiza o pagamento com o código do gateway retornado
      $payment = $this->getPaymentRepository()->findOneById($payment_id);
      $payment->setGatewayCode($transaction_id);
      $em->persist($payment);
      $em->flush();
      $success = true;
    }else{
      $this->get("logger")->err("[PAGSEGURO] TELA DE SUCESSO - PARAMETROS NAO LOCALIZADOS - PAGAMENTO: $payment_id CODIGO: $transaction_id");
      //Parâmetros de retorno incorretos
      $success = false;
    }

    return array('success' => $success);
  }

  /**
  * Verifica os dados recebidos através da notificação automatica
  */
  function receiveNotification() {

      //utilizado na requisição, antes de fazer qualquer coisa.
      if ($this->getRequest()->getMethod() == 'POST') {
          $code = (isset($_POST['notificationCode']) && trim($_POST['notificationCode']) !== "" ?
              trim($_POST['notificationCode']) : null);
          $type = (isset($_POST['notificationType']) && trim($_POST['notificationType']) !== "" ?
              trim($_POST['notificationType']) : null);

          $this->get("logger")->err("[PAGSEGURO] NOTIFICACAO - PARAMETROS RECEBIDOS - CODE: $code TYPE: $type");

          //Verifica se os parâmetros foram enviado
          if ($code && $type) {

              $notificationType = new PagSeguroNotificationType($type);
              $strType = $notificationType->getTypeFromValue();

              //Verifica o tipo de notificação
              switch ($strType) {
                  case 'TRANSACTION':
                    $this->get("logger")->err("[PAGSEGURO] NOTIFICACAO - TRANSACTION");
                    $return = $this->get("pagseguro_manager")->transactionNotification($code);
                    break;

                  default:
                    $this->get("logger")->err("[PAGSEGURO] NOTIFICACAO - TIPO DE NOTIFICAÇÃO INVÁLIDA: $strType");
                    return false;
              }
              return $return;
          } else {
            $this->get("logger")->err("[PAGSEGURO] NOTIFICACAO - PARAMETROS INVÁLIDOS - CODE: $code TYPE: $type");
            return false;
          }

      }
      return false;
  }


}
