<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\RedirectResponse;
use AppBundle\Form\PostType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use AppBundle\Entity\Post;
use AppBundle\Entity\LikePost;
use AppBundle\Entity\CommentPost;
use AppBundle\Form\CommentPostType;

/**
 * @Route("/noticias")
 */
class PostController extends BaseController
{

	/**
     * @Route("", name="post_index")
     */
	public function indexAction(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$noticias = $em->getRepository("AppBundle:Post")->findAllActivePosts();

		$paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $noticias,
            $this->get('request')->query->get('page', 1),
            20
        );

        return $this->render('AppBundle:Post:index.html.twig', array(
            'pagination' => $pagination,
        ));
	}

	/**
     * @Route("/{slug}", name="post_show")
     */
	public function showAction(Request $request, $slug)
	{
		$em = $this->getDoctrine()->getManager();
		$post = $em->getRepository("AppBundle:Post")->findOneBySlug($slug);

		if(!$post){
			throw $this->createNotFoundException('Postagem não encontrada.');
		}

		$postLikes = $em->getRepository('AppBundle:LikePost')->findBy(array(
			'post' => $post->getId()
		));

		$comments = $em->getRepository('AppBundle:CommentPost')->findBy(array(
			'post' => $post->getId()
		));

		$comment = new CommentPost();
		$form = $this->createCreateCommentForm($comment);

		return $this->render('AppBundle:Post:show.html.twig',
			array(
				'post' => $post,
				'postLikes' => $postLikes,
				'comments' => $comments,
				'form' => $form->createView(),
			)
		);
	}

	/**
     * Like Post
     * @Route("/ajax/{id}/like", name="post_like_ajax", options={"expose"=true})
     */
	public function likePostAjaxAction($id)
	{
		try {
			$em = $this->getDoctrine()->getManager();
			$user = $this->getUser();
			$post = $this->getPostRepository()->find($id);

			if (!$post) {
				$return = array("responseCode" => 400);
				return $this->returnJson($return);
			}

			$likePosts = $this->getLikePostRepository()->findBy(array(
				"user" => $user,
				"post" => $post
			));

			if (count($likePosts)>0) {
				foreach ($likePosts as $likePost) {
					$em->remove($likePost);
				}
			} else {
				$likePost = new LikePost();
				$likePost->setUser($user);
				$likePost->setPost($post);

				$em->persist($likePost);
			}

			$em->flush();

			$likes = $this->getLikePostRepository()->findBy(array(
				"post" => $post
			));
			$return = array("responseCode" => 200, "total_likes"=>count($likes));
			return $this->returnJson($return);
		} catch (Exception $e) {
			$return = array("responseCode" => 400);
			return $this->returnJson($return);
		}
	}

	/**
     * @Route("/ajax/new-comment-post", name="new_comment_create", options={"expose"=true})
     */
	public function commentPostAction(Request $request)
	{
		$em = $this->getDoctrine()->getManager();
		$request = Request::createFromGlobals();
		$post = $request->request->get('post');
		// $user = $request->request->get('user');
		$response = $request->request->get('response');
		$message = $request->request->get('message');
		// $user = $em->getRepository('UserBundle:User')->find($user);
		$post = $em->getRepository('AppBundle:Post')->find($post);
		try{
			$entity = new CommentPost();
			$entity->setUser($this->getUser());
			$entity->setPost($post);
			$entity->setMessage($message);
			$entity->setActive(true);
			if ($response != null) {
				$comment = $em->getRepository('AppBundle:CommentPost')->find($response);
				$entity->setReference($comment);
			}
			$em->persist($entity);
			$em->flush();
		} catch (Exception $e) {
			$this->log($e);
		}
		return $this->returnJson($entity);
	}

	/**
     * Creates a form to create a Post entity.
     *
     * @param Post $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
	private function createCreatePostForm(Post $entity)
	{
		$form = $this->createForm(new PostType(), $entity, array(
			'action' => $this->generateUrl('post_create'),
			'method' => 'POST',
		));

		$form->add('submit', 'submit', array('label' => 'Create'));

		return $form;
	}

    /**
    * Creates a form to edit a CommentPost entity.
    *
    * @param Post $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditPostForm(Post $entity)
    {
    	$postType = new PostType();
    	$form = $this->createForm($postType, $entity, array(
    		'action' => $this->generateUrl('post_create'),
    		'method' => 'PUT',
    	));

    	$form->add('submit', 'submit', array('label' => 'Update'));

    	return $form;
    }

    // Comment Create Form

    /**
     * Creates a form to create a CommentPost entity.
     *
     * @param CommentPost $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateCommentForm(CommentPost $entity)
    {
    	$form = $this->createForm(new CommentPostType(), $entity, array(
    		'action' => $this->generateUrl('new_comment_create'),
    		'method' => 'POST',
    	));

    	$form->add('submit', 'submit', array('label' => 'Create'));

    	return $form;
    }

    /**
    * Creates a form to edit a CommentPost entity.
    *
    * @param CommentPost $entity The entity
    *
    * @return \Symfony\Component\Form\Form The form
    */
    private function createEditCommentForm(CommentPost $entity)
    {
    	$commentPostType = new CommentPostType();
    	$form = $this->createForm($commentPostType, $entity, array(
    		'action' => $this->generateUrl('new_comment_create'),
    		'method' => 'PUT',
    	));

    	$form->add('submit', 'submit', array('label' => 'Update'));

    	return $form;
    }
}