<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\RedirectResponse;
use AppBundle\Entity\Answer;
use AppBundle\Entity\UserEvaluation;

/**
 * Question controller.
 * @Route("/")
 */
class QuestionController extends BaseController
{

    /**
     * @Route("/avaliacao/{module_id}", name="question_show", options={"expose"=true})
     */
    public function showAction(Request $request, $module_id)
    {
        $em = $this->getDoctrine()->getManager();
        $this->validUser();
        $user = $this->getUser();

        if (!$module = $this->getModuleRepository()->find($module_id)) {
            throw $this->createNotFoundException('Módulo não encontrado.');
        }

        $em = $this->getDoctrine()->getManager();


        if (!$evaluation = $this->getEvaluationRepository()->findOneByModule($module)) {
            throw $this->createNotFoundException('Avaliação não encontrada.');
        }

        $questions = $this->getQuestionRepository()->findRandomByEvaluation($evaluation);

        $userEvaluations = $this->getUserEvaluationRepository()->findBy(array(
            "user" => $user,
            "evaluation" => $evaluation
        ));

        $correctQuestions = array();
        foreach ($questions as $question) {
            foreach ($question->getQuestionitems() as $questionItem) {
                if ($questionItem->getCorrectAnswer()) {
                    array_push($correctQuestions, $questionItem->getId());
                }
            }
        }

        $inscription = $em->getRepository("AppBundle:Inscription")->getLastInscriptionByUser($user, $module->getCourse());
        if ($inscription == null) {
            $attempts = 100;
        } else {
            $attempts = $inscription->getAttempts();
        }

        if (count($userEvaluations) < $attempts) {
            // if (count($userEvaluations)<1000000000) {
            return $this->render('AppBundle:Question:show.html.twig', array(
                'evaluation' => $evaluation,
                'questions' => $questions,
                'correctQuestions' => $correctQuestions
            ));
        } else {
            //Localiza o próximo módulo
            $nextModule = $this->getModuleRepository()->getNextModule($evaluation->getModule());
            if ($nextModule != null) {
                $firstQuestionModule = $this->getLessonRepository()->findFirstByModule($nextModule);
                return $this->redirect($this->generateUrl('lesson_show', array(
                    'courseId' => $nextModule->getCourse()->getId(),
                    'id'=> $firstQuestionModule->getId()
                )));
            } else {
                $nota = $this->getUserEvaluationRepository()->getMelhoresNotas($user, null, $evaluation);
                foreach ($nota as $value) {
                    if ($value["betterGrade"] < $evaluation->getMinimumGrade()) {
                        $valid = false;
                    } else {
                        $valid = true;
                    }
                }
                if ($valid) {
                    $course = $evaluation->getModule()->getCourse();
                    if ($course->getSurvey()) {
                        $survey = $course->getSurvey();
                        $surveyAnswer = $this->getSurveyAnswerRepository()->findBy(array(
                            "user" => $user,
                            "course" => $course,
                            "survey" => $survey
                        ));
                        if ($surveyAnswer) {
                            $this->successMessage($request, 'Você concluiu o curso '.$course->getTitle());
    
                            return $this->redirect($this->generateUrl('course_finish', array(
                                'courseId' => $course->getId()
                            )));
                        } else {
                            $this->successMessage($request, 'Você concluiu o curso '.$course->getTitle());
                            return $this->redirect($this->generateUrl('survey_show', array(
                                'course_id' => $course->getId()
                            )));
                        }
                    } else {
                        $this->successMessage($request, 'Você concluiu o curso '.$course->getTitle());
    
                        return $this->redirect($this->generateUrl('course_finish', array(
                            'courseId' => $course->getId()
                        )));
                    }
                } else {
                    $repository = $em->getRepository('AppBundle:InscriptionLesson');
                    $inscriptonLesson = $repository->getMaxInscriptionLesson($inscription);
                    $request->getSession()
                         ->getFlashBag()
                         ->add('error', "O resultado mínimo para a avaliação deste módulo não foi atingido. Você não poderá emitir o certificado ao final do curso.");

                    return $this->redirectToRoute('lesson_show', array(
                        'courseId' => $module->getCourse()->getId(),
                        'id' => $inscriptonLesson->getLesson()->getId()
                    ));
                }
            }
        }
    }

    /**
     * @Route("/avaliacao/{evaluation_id}/enviar", name="question_submit")
     */
    public function enviarRespostasAction(Request $request, $evaluation_id)
    {
        $this->validUser();
        $user = $this->getUser();

        if (!$evaluation = $this->getEvaluationRepository()->find($evaluation_id)) {
            throw $this->createNotFoundException('Avaliação não encontrado.');
        }

        $em = $this->getDoctrine()->getManager();

        //Obtem as respostas preenchidas
        $answersArray = $request->request->get('question_item');
        $totalQuestions = 0;
        $correctAnswer = 0;
        
        $userEvaluation = new UserEvaluation();
        $userEvaluation->setEvaluation($evaluation);
        $userEvaluation->setUser($this->getUser());
        $userEvaluation->setCourse($evaluation->getModule()->getCourse());
        $em->persist($userEvaluation);

        $questions = array();
        //Itera sobre as respostas preenchidas
        foreach ($answersArray as $question_id => $questionitem_id) {
            //Carrega a question selecionada
            $question = $this->getQuestionRepository()->find($question_id);
            //Carrega a questionitem selecionada
            $questionItem = $this->getQuestionItemRepository()->find($questionitem_id);
            //Verifica se o usuário já respondeu esta questão
            $answer = new Answer();
            $answer->setUserEvaluation($userEvaluation);
            $answer->setQuestion($question);
            $answer->setQuestionItem($questionItem);
            $answer->setCorrectAnswer($questionItem->getCorrectAnswer());
            $em->persist($answer);
            if ($questionItem->getCorrectAnswer()) {
                $correctAnswer++;
            }
            $totalQuestions++;
            $question->setQuestionItem($questionItem);
            array_push($questions, $question);
        }
        //$em->flush();

        $percentAcertado = ($correctAnswer*100)/$totalQuestions;
        $userEvaluation->setGrade($percentAcertado);
        $userEvaluation->setApproved(($userEvaluation->getGrade() >= $evaluation->getMinimumGrade()));
        $em->persist($userEvaluation);
        $em->flush();

        if ($userEvaluation->getGrade() >= $evaluation->getMinimumGrade()) {
            $courseService = $this->container->get('course.service');
            $courseService->createIntegrationFromFinishCourse($userEvaluation->getCourse()->getId(), $this->getUser());
        }

        //Localiza a primeira aula
        $firstLesson = $this->getLessonRepository()->findFirstByModule($evaluation->getModule());
        //Localiza o próximo módulo
        $nextModule = $this->getModuleRepository()->getNextModule($evaluation->getModule());


        return $this->render('AppBundle:Question:show.results.html.twig', array(
            'evaluation' => $evaluation,
            'questions' => $questions,
            'userEvaluation'=> $userEvaluation
        ));
    }

    /**
     * @Route("/avaliacao/{user_evaluation}/results", name="question_evaluation_results")
     */
    public function evaluationResultsAction(Request $request, $user_evaluation)
    {
        if (!$userEvaluation = $this->getUserEvaluationRepository()->find($user_evaluation)) {
            throw $this->createNotFoundException('Avaliação não encontrado.');
        }
        $evaluation = $userEvaluation->getEvaluation();
        //Localiza a primeira aula
        $firstLesson = $this->getLessonRepository()->findFirstByModule($evaluation->getModule());
        //Localiza o próximo módulo
        $nextModule = $this->getModuleRepository()->getNextModule($evaluation->getModule());
        $user = $this->getUser();
        if ($userEvaluation->getGrade() >= $evaluation->getMinimumGrade()) {
            if ($nextModule!=null) {
                $firstQuestionModule = $this->getLessonRepository()->findFirstByModule($nextModule);
                $request->getSession()
                ->getFlashBag()
                ->add('success', 'Suas respostas foram salvas com sucesso!');
                return $this->redirect($this->generateUrl('lesson_show', array('courseId' => $nextModule->getCourse()->getId(), 'id'=> $firstQuestionModule->getId())));
            } else {
                $firstQuestionModule = $this->getLessonRepository()->findFirstByModule($nextModule);
                $course = $evaluation->getModule()->getCourse();
                if ($course->getSurvey()) {
                    $survey = $course->getSurvey();
                    $surveyAnswer = $this->getSurveyAnswerRepository()->findBy(array(
                        "user" => $user,
                        "course" => $course,
                        "survey" => $survey
                    ));
                    if ($surveyAnswer) {
                        $this->successMessage($request, 'Você concluiu o curso '.$course->getTitle());

                        return $this->redirect($this->generateUrl('course_finish', array(
                            'courseId' => $course->getId()
                        )));
                    } else {
                        $this->successMessage($request, 'Você concluiu o curso '.$course->getTitle());

                        return $this->redirect($this->generateUrl('survey_show', array('course_id' => $course->getId())));
                    }
                } else {
                    $this->successMessage($request, 'Você concluiu o curso '.$course->getTitle());

                    return $this->redirect($this->generateUrl('course_finish', array(
                        'courseId' => $course->getId()
                    )));
                }
            }
        } else {
            //TODO show validação
            return $this->render('AppBundle:Question:result.html.twig', array(
                'evaluation' => $evaluation,
                'module' => $evaluation->getModule(),
                'firstLesson' => $firstLesson,
                'nextModule' => $nextModule,
                'userEvaluation' => $userEvaluation,
                'firstQuestionModule' => ($nextModule != null ? $this->getLessonRepository()->findFirstByModule($nextModule) : $nextModule)
            ));
        }
    }

    /**
     * @Route("/avaliacao-question-random/{question_id}", name="question_item_random")
     */
    public function showRandomQuestionsAction($question_id)
    {
        //Carrega a questão atual
        $question = $this->getQuestionRepository()->find($question_id);

        //Lista de itens
        $questionItens = $this->getQuestionItemRepository()->findRandomByQuestion($question);
        return $this->render('AppBundle:Question:question.item.html.twig', array(
            'questionItens' => $questionItens,
            'question' => $question
        ));
    }
}
