<?php

namespace AppBundle\Controller;

use JMS\Serializer\SerializerBuilder;
use Symfony\Component\HttpFoundation\Request;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\RedirectResponse;
use AppBundle\Entity\Inscription;
use AppBundle\Entity\Payment;
use AppBundle\Entity\Client;
use AppBundle\Entity\JobRole;
use AppBundle\Entity\Sector;
use AppBundle\Entity\Lead;
use UserBundle\Entity\User;
use AppBundle\Entity\UserStatus;
use AppBundle\Entity\Contact;
use AppBundle\Form\ClientType;
use AppBundle\Form\ContactType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use AppBundle\Entity\OrcamentoContato;
use AppBundle\Form\OrcamentoContatoType;
use AppBundle\Entity\IndiqueCursos;
use AppBundle\Form\IndiqueCursosType;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;
use AppBundle\Entity\InscriptionStatus;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;

/**
 * Report controller.
 * @Route("/relatorio")
 */
class ReportController extends BaseController
{


    /**
    * @Route("/relatorio-lideranca", name="superior_report")
    */
    public function superiorReportAction(Request $request, $query = null)
    {
        $this->validUser();
        $em = $this->getDoctrine()->getManager();
        $query = $this->getRequest()->get("query");
        $inscriptions = $this->getInscriptionRepository()->getInscriptionBySuperior($this->getUser(), $query, true);

        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
            $inscriptions,
            $this->get('request')->query->get('page', 1),
            50
        );

        return $this->render('AppBundle:Report:report.superior.html.twig', array(
            'pagination' => $pagination,
            'user' => $this->getUser(),
            'query' => $query
        ));
    }

    /**
    * @Route("/planilha", name= "backend_planilha")
    */
  public function planilhaAction(Request $request, $query = null)
  {

    $em = $this->getDoctrine()->getManager();
    $query = $this->getRequest()->get("query");
    $dataAtual = new \DateTime('now');

    $inscriptions = $this->getInscriptionRepository()->getInscriptionBySuperior($this->getUser(), $query, false);

    //excel
    $phpExcelObject = $this->get('phpexcel')->createPHPExcelObject();

    $phpExcelObject->getProperties()->setCreator($this->getUser()->getUsername())
        ->setLastModifiedBy("Unimed")
        ->setTitle("Planilha de controle(Unimed)")
        ->setSubject("Planilha de controle(Unimed)")
        ->setDescription("Planilha de controle(Unimed)")
        ->setKeywords("Unimed")
        ->setCategory("Planilha de controle");

    //Primeira aba da planilha - Certidões vencidas
    $phpExcelObject->setActiveSheetIndex(0)
      ->setCellValue('A1', 'Funcionário')
      ->setCellValue('B1', 'Curso')
      ->setCellValue('C1', 'Data da matrícula')
      ->setCellValue('D1', 'Data final')
      ->setCellValue('E1', 'Status')
      ->setCellValue('F1', 'Nota');
    $i = 2;

    foreach ($inscriptions as $inscription) {
        //Busca todas as aulas assistidas
        $listInscriptionLessons = $this->getInscriptionLessonRepository()->findBy(array("inscription"=>$inscription));
        //Obtem curso
        $course = $inscription->getCourse();
        //Obtem user
        $user = $inscription->getUser();
        //Variável de controle de aulas do curso
        $totalLessons = 0;
        //Variável de controle de avaliações do curso
        $totalEvaluation = 0;
        //Nota mínima para ser aprovado no curso
        $minimumGrade = 0;
        //Variável de controle de nota
        $nota = 0;
        foreach ($course->getModules() as $module) {
            //Atualiza a varíavel de controle
            $totalLessons+=count($module->getLessons());
        }
        //Busca todas as aulas concluídas
        $listLessonsConcluded = $this->getInscriptionLessonRepository()->findAllByInscription($inscription, true);
        $totalLessonsConcluded = count($listLessonsConcluded);
        /*
        * Lista de status:
        * Não iniciou: nenhuma aula assistida
        * Em andamento: não completou todas as aulas
        * Concluído: completou todas as aulas
        */
        $status = "Não iniciou";
        //Verifica se todas as aulas foram concluídas
        if ($totalLessonsConcluded = $totalLessons) {
            //Percorre todos os módulos
            foreach ($course->getModules() as $module) {
                //Percorre todas as avaliações do módulo
                foreach ($module->getEvaluations() as $evaluation) {
                    //Atualiza a quantidade de avaliações
                    $totalEvaluation++;
                    //Obtem as notas tiradas
                    $userEvaluations = $this->getUserEvaluationRepository()->findBy(array("user"=>$user, "evaluation"=>$evaluation));
                    if (count($userEvaluations)>0) {
                        //Soma as notas mínimas da avaliação
                        $minimumGrade += $evaluation->getMinimumGrade();
                        //Busca a nota da primeira avaliação, que será considerada
                        $userEvaluation = $userEvaluations[0];
                    }
                }
            }
            //Verifica a média
            if ($totalEvaluation > 0) {
                $minimumGrade = $minimumGrade/$totalEvaluation;
            }
        }

        //Busca as notas de teste
        $totalAluno = $this->getRepositoryFromBase('UserEvaluation')->getMelhoresNotas($user, $course);
        $countTotalAluno = count($totalAluno);
        $notaAluno = 0;
        if ($countTotalAluno > 0) {
            foreach ($totalAluno as $value) {
                $notaAluno+=$value["betterGrade"];
            }
            $nota = $notaAluno/$countTotalAluno;
        } else {
            $nota = 0;
        }

        $lastInscriptionLesson = null;
        //Tratamento para exibição de resultados
        if($totalEvaluation == 0){
            $nota = " - ";
            if (count($listInscriptionLessons) > 0) {
                if ($totalLessonsConcluded = $totalLessons) {
                    $status = "Concluído";
                    //Obtem a última aula assistida
                    $lastInscriptionLesson = end($listInscriptionLessons);
                } else {
                    $status = "Em andamento";
                }
            }
        }
        if($totalEvaluation > 0){
            if ($nota == 0) {
                $nota = " - ";
                if (count($listInscriptionLessons) > 0) {
                    if ($totalLessonsConcluded = $totalLessons) {
                        $status = "Concluído";
                        $lastInscriptionLesson = end($listInscriptionLessons);
                    } else {
                        $status = "Em andamento";
                    }
                }else{
                    $status = "Incompleto";
                }
            }elseif($nota > 0 && $nota < $minimumGrade){
                $status = "Reprovado";
            }else{
                $status = "Aprovado";
                $lastInscriptionLesson = end($listInscriptionLessons);
            }
        }

      $phpExcelObject->setActiveSheetIndex(0)
        ->setCellValue('A'.$i, $inscription->getUser()->getFullName())
        ->setCellValue('B'.$i, $inscription->getCourse()->getTitle())
        ->setCellValue('C'.$i, $inscription->getDtCreation()->format('d/m/Y'))
        ->setCellValue('D'.$i, $lastInscriptionLesson!=null && $lastInscriptionLesson->getFinished()!=null?$lastInscriptionLesson->getFinished()->format('d/m/Y'):"")
        ->setCellValue('E'.$i, $status)
        ->setCellValue('F'.$i, $nota);
      $i++;
    }

    //Autosize nas colunas da planilha
    foreach (range('A','F') as $columnID) {
        $phpExcelObject->getActiveSheet()->getColumnDimension($columnID)
        ->setAutoSize(true);
    }

    $phpExcelObject->setActiveSheetIndex(0);

    $phpExcelObject->getActiveSheet()->setTitle('Inscrições');

    $writer = $this->get('phpexcel')->createWriter($phpExcelObject, 'Excel2007');

    $response = $this->get('phpexcel')->createStreamedResponse($writer);

    $dispositionHeader = $response->headers->makeDisposition(
          ResponseHeaderBag::DISPOSITION_ATTACHMENT,
          'Unimed - Acompanhamento.xlsx'
    );
    $response->headers->set('Content-Type', 'text/vnd.ms-excel; charset=utf-8');
    $response->headers->set('Pragma', 'public');
    $response->headers->set('Cache-Control', 'maxage=1');
    $response->headers->set('Content-Disposition', $dispositionHeader);

    return $response;

    return $this->redirectToRoute('superior_report');
  }

}
