<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Template;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\JsonResponse;

class SambaVideosController extends BaseController
{
  /**
   * @Route("/available_videos", name="available_videos", options={"expose"=true})
   * @Template()
   */
  public function showAvailableVideosAction()
  {

    try {
        $em = $this->getDoctrine()->getManager();
        $request = Request::createFromGlobals();

        $medias = $this->get("samba.videos.videos")->getMedias();

        $html = "<table>";
        foreach($medias as $media){
            //$checked = (in_array($media->id, $sv_video) ? 'checked="checked"' : '');
            $html.= "<tr>";
            $html.= "<td>";
            $html.= "<input type='radio' name='sv_videos[]' value='{$media->id}' />";
            $html.= "</td>";
            $html.= "<td>";
            $html.= "<img src='{$media->thumbs[0]->url}' width='50px' />";
            $html.= "</td>";
            $html.= "<td>";
            $html.= $media->title;
            $html.= "</td>";
            $html.= "</tr>";
        }
        $html.= "</table>";

        $return = array("responseCode" => 200, "results" => $html);
    } catch (\Exception $e) {
        $return = array("responseCode" => 400, 'errorMessage' => $e->getTraceAsString());
    }

    return $this->returnJson($return);
  }

  /**
   * @Route("/avaliable-videos-preview", name="available_videos_preview", options={"expose"=true})
   * @Template()
   */
  public function showAvailableVideosPreviewAction()
  {

    try {
        $em = $this->getDoctrine()->getManager();
        $request = Request::createFromGlobals();
        $id_media = $request->query->get('id_media');

        $medias = $this->get("samba.videos.videos")->getMedias();

        $html = "";
        foreach($medias as $media){
          $checked = ($media->id == $id_media ? 'checked="checked"' : '');
            $html .= '<div class="col-md-3 col-sm-3 col-xs-3 mg-t20 text-center box-label mg-b20">';
            $html.= '<div class="col-md-12 col-sm-12 col-xs-12">';
            $html.= "<input type='radio' name='id_media_degustacao' ".$checked." class='check_video' value='{$media->id}' id='{$media->id}' onclick='checkClick();' />";
            $html.= "</div>";
            $html.= "<label for='{$media->id}'>";
            $html.= '<div class="col-md-12 col-sm-12 col-xs-12 mg-t20">';
            $html.= "<img src='{$media->thumbs[0]->url}' class='img-responsive center-img' />";
            $html.= "</div>";
            $html.= '<div class="col-md-12 col-sm-12 col-xs-12 mg-t10">';
            $html.= $media->title;
            $html.= "</div>";
            $html.= "</label>";
            $html.= "</div>";
        }

        $return = array("responseCode" => 200, "results" => $html);
    } catch (\Exception $e) {
        $return = array("responseCode" => 400, 'errorMessage' => $e->getTraceAsString());
    }

    return $this->returnJson($return);
  }

  /**
   * @Route("/avaliable-videos-load-media", name="available_videos_load_media", options={"expose"=true})
   * @Template()
   */
  public function showAvailableVideosLoadMediaAction()
  {

    try {
        $em = $this->getDoctrine()->getManager();
        $request = Request::createFromGlobals();
        $sv_video = $request->query->get('sv_video');
        $media = $this->get("samba.videos.videos")->getMedia($sv_video);
        return new JsonResponse(array("responseCode" => 200, "result" => $media));
    } catch (\Exception $e) {
        $return = array("responseCode" => 400, 'errorMessage' => $e->getTraceAsString());
    }

    return $this->returnJson($return);
  }

  /**
   * @Route("/avaliable-videos-preview-typeahead", name="available_videos_preview_typeahead", options={"expose"=true})
   * @Template()
   */
  public function showAvailableVideosPreviewTypeaheadAction()
  {

    try {
        $em = $this->getDoctrine()->getManager();
        $request = Request::createFromGlobals();
        $query = $request->query->get('q');
        $query = $this->get("samba.videos.videos")->urlToSearch($query);
        $medias = $this->get("samba.videos.videos")->getMedias(50, 0, "&search=".$query);
        return new JsonResponse($medias);
    } catch (\Exception $e) {
        $return = array("responseCode" => 400, 'errorMessage' => $e->getTraceAsString());
    }

    return $this->returnJson($return);
  }

}
