<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Search controller.
 *
 * @Route("/busca")
 */
class SearchController extends BaseController
{
    /**
     * Busca de resultados
     * @Route("/{query}", name="search_show")
     */
    public function searchAction(Request $request, $query = null)
    {
      $user = $this->validUser();

      $client = $this->getClient($user);

      // Recupera o parametro q
      $query = $this->getRequest()->get("query");
      $em = $this->getDoctrine()->getManager();
      //Obtem o curso através do slug informado
      $courses = $em->getRepository('AppBundle:Course')->findForSearch($user, $query);

      $paginator = $this->get('knp_paginator');

      $pagination = $paginator->paginate(
              $courses, $this->get('request')->query->get('page', 1), 20
      );
      $pagination->setParam('query', 'query');

      return $this->render('AppBundle:Search:search.html.twig', array(
        'pagination' => $pagination,
        'query' => $query,
        'client' => $client
      ));
    }

}
