<?php

namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AppBundle\Controller\BaseController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\JsonResponse;
use AppBundle\Entity\SurveyAnswer;
use AppBundle\Entity\SurveyComment;

/**
 * Survey controller.
 * @Route("/")
 */
class SurveyController extends BaseController
{

    /**
     * @Route("/pesquisa-satisfacao/{course_id}", name="survey_show", options={"expose"=true})
     */
    public function showAction(Request $request, $course_id)
    {
        $user = $this->getUser();

        if (!$course = $this->getCourseRepository()->find($course_id)) {
            throw $this->createNotFoundException('Curso não encontrado.');
        }

        if ($course->getSurvey()) {
            $surveyAnswer = $this->getSurveyAnswerRepository()->findBy(array(
                "user" => $user,
                "course" => $course,
                "survey" => $course->getSurvey()
            ));

            if ($surveyAnswer) {
                $this->successMessage($request, 'Você já respondeu à pesquisa de satisfação do curso '.$course);
        
                return $this->redirect($this->generateUrl('course_finish', array(
                    'courseId' => $course->getId()
                )));
            } else {
                $surveyItens = $this->getSurveyItemRepository()->findBySurvey($course->getSurvey());
                $conclusionLink = $course->getConclusionLink();
                if (!empty($conclusionLink)) {
                    if (filter_var($conclusionLink, FILTER_VALIDATE_URL)) { 
                        $conclusionLink = $conclusionLink;
                    }else{
                        $conclusionLink = "http://".$conclusionLink;
                    }
                }

                $dataRequest = $request->query->all();
                
                return $this->render('AppBundle:Survey:show.html.twig', array(
                    'course' => $course,
                    'surveyItens' => $surveyItens,
                    'conclusionLink' => $conclusionLink,
                    'concludedIqaCicle' => array_key_exists('concludedIqaCicle', $dataRequest) ? $dataRequest['concludedIqaCicle'] : ""
                ));
            }
        } else {
            return $this->redirect($this->generateUrl('home_certificate'));
        }
    }

    /**
     * @Route("/pesquisa-satisfacao/{course_id}/enviar", name="survey_submit")
     */
    public function enviarRespostasAction(Request $request, $course_id)
    {
        $user = $this->getUser();

        if (!$course = $this->getCourseRepository()->find($course_id)) {
            throw $this->createNotFoundException('Avaliação não encontrado.');
        }

        $data = $request->request->all();
        $surveyItensData = $data['survey_item'];
        $comments_itens = $data['survey_item_comment'];
        $comment = $data['survey_comment'];

        $surveyItens = $this->getSurveyItemRepository()->findBySurvey($course->getSurvey());

        $em = $this->getDoctrine()->getManager();
        $surveyAnswer = $this->getSurveyAnswerRepository()->findBy(array(
            "user" => $user,
            "course" => $course,
            "survey" => $course->getSurvey()
        ));

        if (!$surveyAnswer) {
            foreach ($surveyItensData as $key => $item) {
                $surveyAnswer = new SurveyAnswer();
                $surveyAnswer->setUser($user);
                $surveyItem = $this->getSurveyItemRepository()->find($key);
                $surveyAnswer->setSurveyItem($surveyItem);
                $surveyAnswer->setCourse($course);
                $surveyAnswer->setValue($item);
                $surveyAnswer->setComment($comments_itens[$key]);
                $surveyAnswer->setSurvey($course->getSurvey());
                $em->persist($surveyAnswer);
                $em->flush();
            }
        }

        $this->successMessage($request, 'Obrigado por responder nossa pesquisa de satisfação! Você concluiu o curso '.$course->getTitle());
    
        return $this->redirect($this->generateUrl('course_finish', array(
            'courseId' => $course->getId()
        )));
    }

    /**
     * Set entity SurveyAnswer
     * @param $params [array]
     * @param $course [object]
     * @param $user [object]
     *
     * @return $surveyAnswer [object] entity
     */
    public function handleSurveyAnswer($params, $course, $user = null)
    {
        if (!$user) {
            $user = $this->getUser();
        }

        $surveyItem = $this->getSurveyItemRepository()->find($params['survey_item_id']);
        $surveyAnswer = new SurveyAnswer();
        $surveyAnswer->setUser($user);
        $surveyAnswer->setSurveyItem($surveyItem);
        $surveyAnswer->setCourse($course);
        $surveyAnswer->setValue($params['survey_answer_value']);
        $surveyAnswer->setComment($params['survey_answer_comment']);
        $surveyAnswer->setSurvey($course->getSurvey());

        return $surveyAnswer;
    }

    /**
     * @Route("/pesquisa-satisfacao/answer/save", name="survey_item_answer_save", options={"expose"=true})
     * @Method("POST")
     */
    public function surveyItemAnswerAction(Request $request)
    {
        try {
            $dataRequest = $request->request->all();
            $em = $this->getDoctrine()->getManager();
            $user = $this->getUser();
            $course = $this->getCourseRepository()->find($dataRequest['course']);

            $surveyItem = $this->getSurveyItemRepository()->find($dataRequest['survey_item_id']);
            $findSurveyAnswer = $em->getRepository('AppBundle:SurveyAnswer')->findOneBy(array(
                'user' => $user,
                'course' => $course,
                'survey' => $course->getSurvey(),
                'surveyItem' => $surveyItem
            ));

            if (!$findSurveyAnswer) {
                $surveyAnswer = $this->handleSurveyAnswer($dataRequest, $course, $user);

                $em->persist($surveyAnswer);
                $em->flush();
            }

            $response = array(
                'data' => 'done',
                'responseCode' => 200,
                'courseId' => $dataRequest['course']
            );

            return new JsonResponse($response);
        } catch (Exception $e) {
            $this->log($e);
            return new JsonResponse(array(
                'error' => 'true',
                'msg' => $e,
                'responseCode' => 500
            ));
        }
    }
}
